//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <x11/WSDunixExternal.h>
#include <stdio.h>
#include <WSClocaleSet.h>
#ifndef MacOS
#include <dlfcn.h>
#else //MacOS
#include <Carbon/Carbon.h>
#include <Strings.h>
//#include <CodeFragments.h>
//#include <Aliases.h>

#include <mach-o/dyld.h>
#define RTLD_LAZY 0
void* dlopen(char* fname,long){
    int result;
    NSObjectFileImage handle;
    result = NSCreateObjectFileImageFromFile(fname, &handle);
    if (result != NSObjectFileImageSuccess) {
printf("Failed to load file:%s\n", fname);
      return NULL;
    }
    NSLinkModule(handle,fname, TRUE);
    return handle;
};
void* dlsym(void* ptr,char* procn){
    WSCstring procn2("_");
    procn2 << procn;
    if(NSIsSymbolNameDefined(procn)) {
printf("Failed to find symbol=%s\n",procn);
    }
    /* NSLookupAndBindSymbol require function name with "_" !! */
    NSSymbol sym = NSLookupAndBindSymbol(procn2.getString());
    void* ret = (void*)NSAddressOfSymbol(sym);

    return ret;
  return (void*)ret;
}
#endif //MacOS

WSMFclassInit(WSDunixExternal,WSDexternal);

WSDexternal* _unix_external_create(){
  return new WSDunixExternal;
}

class _unix_external_init {
  public: _unix_external_init(){
    WSDexternal::setCreateInstanceHandler((void*)_unix_external_create);
  };
};

_unix_external_init  _unix_external_init_execute;

WSDunixExternal::WSDunixExternal(){
  _dl_ptr = NULL;
}

WSDunixExternal::~WSDunixExternal(){
  if (_dl_ptr != NULL){
    close();
  }
}

long WSDunixExternal::open(char* name){
  _ptr = NULL;
  WSDexternal::setTempData(NULL); 

  _dll_name.setString(name);
  _dll_name.delHeadSpace();
  char* fn = _dll_name.getString(WSGIappLocaleSet()->getSystemLocaleEncoding())
;
#ifdef MacOS
  WSCstring tmp1;
  if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_UTF8){
extern char* utf8_to_macutf8(char*);
    char* fn2 = utf8_to_macutf8(
       _dll_name.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
    if (fn2 != NULL){
      tmp1.setString(fn2);
      delete fn2;
      fn = tmp1.getString();
    }
  }
#endif

  _dl_ptr = dlopen(fn,RTLD_LAZY);
  if (_dl_ptr != NULL){
    _ptr = WSDexternal::getTempData();
    return WS_NO_ERR;
  }
#ifndef MacOS
fprintf(stderr,"Error: WSDunixExternal::open  dll open error:%s\n",dlerror());
#endif //MacOS
  return WS_ERR;
}

long WSDunixExternal::close(){
  if (_dl_ptr != NULL){
#ifndef MacOS
    dlclose(_dl_ptr);
#endif //MacOS
    _dl_ptr = NULL;
    _ptr = NULL;
  }
  return WS_NO_ERR;
}

WSCstring* WSDunixExternal::getObjectSymbols(){
  if (_ptr != NULL){
    WSCstring* str = new WSCstring;
    char** sym = (char**) _ptr;
    long i=0;
    while(1){
      if (sym[i] == NULL){
        break;
      }
      str->addString(sym[i]);
      str->addString(" ");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
    }
    return str;
  }
  return NULL;
}

