# -*- coding: utf-8 -*-
#   WillowNG - Content Filtering Web Proxy 
#   Copyright (C) 2006  Travis Watkins
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Library General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import dbus
import dbus.service
import dbus.glib

class WillowNGInterface(dbus.service.Object):
    def __init__(self, bus_name, object_path='/com/ubuntu/WillowNG'):
        dbus.service.Object.__init__(self, bus_name, object_path)

    @dbus.service.method('com.ubuntu.WillowNG')
    def trainBad(self, url):
        bad = self.domain.isBad(url)
        good = self.domain.isGood(url)
        if not good:
            self.domain.add('good', url)
        self.bayes.train('bad', url)
        if bad:
            self.domain.add('bad', url)
        else:
            self.domain.remove(url)

    @dbus.service.method('com.ubuntu.WillowNG')
    def trainGood(self, url):
        bad = self.domain.isBad(url)
        good = self.domain.isGood(url)
        if not good:
            self.domain.add('good', url)
        self.bayes.train('good', url)
        if bad:
            self.domain.add('bad', url)
        else:
            self.domain.remove(url)

    @dbus.service.method('com.ubuntu.WillowNG')
    def domainBad(self, domain):
        self.domain.add('bad', domain)

    @dbus.service.method('com.ubuntu.WillowNG')
    def domainGood(self, domain):
        self.domain.add('good', domain)

    @dbus.service.method('com.ubuntu.WillowNG')
    def removeDomain(self, domain):
        self.domain.remove(domain)

    @dbus.service.method('com.ubuntu.WillowNG')
    def getDomains(self):
        return self.domain.get()
      
system_bus = dbus.SystemBus()
name = dbus.service.BusName('com.ubuntu.WillowNG', bus=system_bus)
interface = WillowNGInterface(name)
