/**
 * Sum.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente le produit de deux fonctions.
 *
 * @author Nicolae
 */
public class Product extends DefaultMap {

	private Map f;
	private Map g;

	private double[] v1 = new double[2]; 
	private double[] v2 = new double[2]; 
	
	/**
	 * Cache le constructor standard.
	 */
	private Product() {}
	
	/**
	 * Constructor qui initialise les deux applications.
	 *
	 * @param f application.
	 * @param f application.
	 */
	public Product(Map f, Map g) {
		this.f = f;
		this.g = g;
	}

	/* (non-Javadoc)
	 * @see maths.DefaultMap#apply()
	 */
	protected void apply() {
		f.value(x, y, v1);
		g.value(x, y, v2);

		fx = v1[0] * v2[0] - v1[1] * v2[1];
		fy = v1[0] * v2[1] + v1[1] * v2[0];
	}

	/* (non-Javadoc)
	 * @see maths.DefaultMap#inverse()
	 */
	public Map[] inverse() {
		return null;
	}

	protected void compDiff() {
		Map df = f.differential();
		Map dg = g.differential();
		
		if(df == null || dg == null)
			der = null;
		else {			
			Map fdg = new Product(f, dg);
			Map dfg = new Product(df, g);			
			
			der = new Sum(fdg, dfg);
		}
	}
}
