%{
/* inclusions, dfinition */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include "chemeq.h"

  int yylex();
  int yyerror(char * msg);

typedef struct{
  int i, d; /* integer numerator, denominator */
  double r;
  AtomeListe * al;
  Molec * m;
  Chemeq * cq;
  Membre * mb;
  char symb[4];
  moltype t;
  string s;
} yystype;

#define YYSTYPE yystype 

/* variables globales */

 yystype result;
 extern char * yytext;
 extern int position;
 int isequation;

%}

%token Atome
%token SpcPlus
%token Plus
%token Moins
%token Fleche
%token Int
%token Charge
%token Frac
%token Real
%token SpcLpar
%token Lpar
%token Rpar
%token Lsq
%token Rsq
%token Haut
%token Spc
%token Sol
%token Gas
%token Aqueous
%token Egal

%%

/* les rgles */
but : chemeq cste{
  result=$1;
  result.cq->constante($2.s);
  result.cq->valeur($2.r);
  isequation=1;
}
| molec {
  result=$1;
  isequation=0;
}
;

cste : /* rien */ {$$.s = ""; $$.r = -1.0; /* valeur ngative : non dfini */}
| SpcLpar cste1 Rpar {$$ = $2;}
;

cste1 : spc01 nombre volt{$$.s = ""; $$.r = $2.r;}
| spc01 id spc01 Egal spc01 nombre volt{$$.s = $2.s; $$.r = $6.r;}
;

nombre : Real {$$.r=$1.r;}
| Int {$$.r=1.0*$1.i;}
| Plus spc01 Real{$$.r=$3.r;}
| Moins spc01 Real{$$.r=-$3.r;}
| Plus spc01 Int{$$.r=1.0*$3.i;}
| Moins spc01 Int{$$.r=-1.0*$3.i;}
;

volt : /* rien */
| spc01 Atome {if ($2.s != string("V")) yyerror ("only 'V' allowed as unit"); }
;

id : Atome {/* $$.s contient le nom */}
;

chemeq : membre Spc Fleche spc01 membre{
  $$.cq = new Chemeq($1.mb,$5.mb);
}
;

membre : membre SpcPlus spc01 molecs {
  $$.mb->push_back($4.m);
}
| molecs {
  $$.mb = new Membre;
  $$.mb->push_back($1.m);
}
;

molecs : Int spc01 molec {
  $$ = $3;
  $$.m->nombre($1.i);
}
| Frac spc01 molec {
  $$ = $3;
  $$.m->nombre($1.i,$1.d);
}
| molec{
  $$ = $1; 
}
;

spc01 : /*rien*/
| Spc
;

molec : composition0 typage{
  $$.m = new Molec($1.al,0); $$.m->typage($2.t);
}
| composition0 charge typage{
  $$.m = new Molec($1.al,$2.i);$$.m->typage($3.t);
}
;


composition0 : composition {$$.al=$1.al;}
| Lsq spc01 composition spc01 Rsq {$$.al=$3.al; $$.al->sq(1);}
;

typage : /* rien */ {$$.t = aqueous;}
| Aqueous {$$.t = aqueous;}
| Sol {$$.t = sol;}
| Gas {$$.t = gas;}
;

charge : Plus {$$.i=1;}
| Haut Plus {$$.i=1;}
| Haut Charge {$$.i=$2.i;}
| Moins{$$.i=-1;}
| Haut  Moins{$$.i=-1;}
;

groupe : Lpar composition Rpar {
  $$=$2; 
}
;

atome_general : groupe {
  $$.al = new AtomeListe("",0,0,$1.al);
}
| Atome{
  char buffer[25];
  if ($1.i==-2) { /* ce n'est pas un atome recens */
    sprintf(buffer,"nonexistent atom : %s", $1.symb);
    yyerror(buffer);
  }
  $$.al = new AtomeListe($1.symb,$1.i);
}
;

composition : atome_general molecularite composition {
  $$ = $1;
  $$.al->setmolecularite($2.i);
  $$.al->setsuivant($3.al);
}
| atome_general molecularite{
  $$.al = $1.al;
  $$.al->setmolecularite($2.i);
}
;

molecularite : /*rien*/{
  $$.i=1;
}
| Int {
  $$=$1; 
}
;

%%
#include "chemlex.cc"

yyFlexLexer lexer;

int yylex(){
  return lexer.yylex();
}

/* le programme lui-mme */

inline int yyerror(char * msg){
  fprintf(stderr, "ERROR %s at %d\n ", msg, position);
  exit(1);
}

void printHelp(){
  cout << "Usage : chemeq [-m] [-l] [-c] [-w] [-n] [-h]" << endl;
  cout << "        default is equivalent to 'chemeq -mlcwn'" << endl;
  cout << "        chemeq reads its standard input which must be a standard" << endl;
  cout << "        chemical equation. It outputs many strings useful for chemical" << endl;
  cout << "        calculations." << endl;
  cout << "        As an example you can try the following command :" << endl;
  cout << "        echo \"Fes -> Fe^2+ + 2 e- (0.44 V)\" | chemeq" << endl;
}

int main(int argc, char * argv[]){
  char * optstr = "mlcwnh", ch;
  bool nooption=1;

  if (argc>1 && !strcmp(argv[1],"-h")){
    printHelp(); return 0;
  }
  yyparse();
  if (isequation) {
    while (-1 != (ch=getopt(argc,argv,optstr))){
      switch(ch){
      case 'm': nooption=0;
	result.cq->printnorm(cout); cout << endl;
	break;
      case 'l': nooption=0;
	cout << *result.cq << endl;
	break;
      case 'c': nooption=0;
	cout << result.cq->equilibre() << endl;
	break;
      case 'w': nooption=0;
	result.cq->printNernst(cout); cout << endl;
	break;
      case 'n': nooption=0;
	result.cq->normalise();
	result.cq->printnorm(cout); cout << endl;
	break;
      case 'h':
	printHelp();
	break;
      }
    }
    if (nooption){
      result.cq->printnorm(cout); cout << endl;
      cout << *result.cq << endl;
      cout << result.cq->equilibre() << endl;
      result.cq->printNernst(cout); cout << endl;
      result.cq->normalise();
      result.cq->printnorm(cout); cout << endl;
    }
  }
  else { /* ce n'est pas une quation */
    cout << *result.m;
  }
  return 0;
}
