/*    Copyright (C) 2002-2003 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

	/* Block parsing routines
	 * Return value:
	 * 0 if no match.
	 * 1 if match.
	 * -1 if error. */

void outval(char *tit, char *val)
{
    char *p, l, r;
    val=find_word_start(val);
    strip_trailing_spaces(val);
    if(*val==0) {
	snprintf(outptr,sizeof(outbuf)-(outptr-outbuf)-1,"%s=_EMPTY_ ",tit);
	goto outend;
    }
    if(*find_word_end(val)==0) {
	snprintf(outptr,sizeof(outbuf)-(outptr-outbuf)-1,"%s=%s ",tit,val);
    }
    else {
	l='('; r=')';
	if(strchr(val,l)!=NULL || strchr(val,l)!=NULL) {
	    l='['; r=']';
	    if(strchr(val,l)!=NULL || strchr(val,l)!=NULL) {
		l='{'; r='}';
		if(strchr(val,l)!=NULL || strchr(val,l)!=NULL) {
		    l='"'; r='"';
		    if(strchr(val,l)!=NULL || strchr(val,l)!=NULL) {
			l=r=' ';
			for(p=val;*p;p++) if(*p==' ') *p='_';
		    }
		}
	    }
	}
	snprintf(outptr,sizeof(outbuf)-(outptr-outbuf)-1,"%s=%c%s%c ",tit,l,val,r);
    }
    outend: outptr+=strlen(outptr);
}

void cleartag(struct block *blk)
{
    int i, len, level;
    listtype *tag;
    len=blk->len; tag=blk->tag; level=blk->lind2;
    if(level==0) {
	memset(tag,0,blk->len*sizeof(listtype));
    }
    else for(i=0; i<len; i++) {
	if(tag[i]>=level) tag[i]=0;
    }
}

int mt_this(struct block *blk, char *start, int level)
{
    int r;
    if(level > MAX_LEVELS) error("level_overflow %.20s",start);
    start=find_word_start(start);
/*    if(debug) fprintf(stderr,"lvl=%d. Checking against block %d for %.10s.\n",level,blk-blockbuf,start);
*/    r = blk->fn(blk,start,level);
    if(debug) fprintf(stderr,"lvl=%d. Tested %d block %d for %.10s.\n",level,r,blk-blockbuf,start);
    return r;
}

int mt_next(struct block *blk, char *start, int level)
{
    if(blk->nextblock<0) {
	if(*start) return 0; else return 1;
    }
    return mt_this(blockbuf+blk->nextblock,start,level);
}

int mt_string(struct block *blk, char *start, int level)
{
    char *p;
    int r;
    if(blk->len>0) {
	if(memcmp(blk->string,start,blk->len)!=0) return 0;
	p=start+blk->len; if(*p && !myisspace(*p)) return 0;
    }
    else p=start;
    r = mt_next(blk,p,level+1);
    if(debug) fprintf(stderr,"Strcmp %d %.20s. <-> %.20s.\n",r, blk->string,start);
    return r;
}

int mt_dic(struct block *blk, char *start, int level)
{
    int i,t;
    struct entry *et;
    char *p;
    
    i=blk->lind1;
    t=search_dic(entry+dic[i].start,dic[i].len,sizeof(entry[0]),start);
    if(t>=0) {
	et=entry+(dic[i].start+t);
	if(itemchr(et->replace,blk->string)==NULL) return 0;
	p=start+et->olen;
	return mt_next(blk,p,level+1);
    }
    switch(dic[i].unknown_type) {
	case unk_leave: {
	    if(memcmp(start,blk->string,blk->len)==0 ||
	       (start[blk->len]!=0 && !myisspace(start[blk->len])))
	      return 0;
	    return mt_next(blk,find_word_start(start+blk->len),level+1);	    
	}
	case unk_replace: {
	    if(strcmp(dic[i].unknown,blk->string)!=0) return 0;
	    return mt_next(blk,start,level+1);
	}
	case unk_delete: return 0;
    }
    return 0;
}

int _permpick1(struct block *blk, char *start, int level)
{
    int i, j, k, r, re;
    
    level++;
    i=blk->lists[blk->lind1][blk->lind2];
    blk->lind2++; cleartag(blk);
ppstart:
    if(i>=blk->len) {		/* optional match */
	i-=blk->len;
	r=mt_next(blk,start,level);
	if(r) goto end;
    }
    if(i>=0) {
	r=mt_this(blockbuf+blk->sublock+i,start,level);
	goto end;
    }
    r=0;
    switch(i) {
	case -1: {	/* any */
	    any:
	    for(k=blk->lstart;k<blk->len;k++) {
		blk->tag[k]=blk->lind2;
		r=mt_this(blockbuf+blk->sublock+k,start,level);
		cleartag(blk);
		if(r) break;
	    }
	    goto end;
	}
	case -2: {	/* any unused */
	    unused:
	    for(k=blk->lstart;k<blk->len;k++) {
		if(blk->tag[k]>0) continue;
		blk->tag[k]=blk->lind2;
		r=mt_this(blockbuf+blk->sublock+k,start,level);
		cleartag(blk);
		if(r) break;
	    }
	    goto end;
	}
	case -3: {	/* any unused bigger */
	    unused_bigger:
	    for(k=blk->len-1;k>=blk->lstart && blk->tag[k]==0;k--);
	    for(k++;k<blk->len;k++) {
		blk->tag[k]=blk->lind2;
		r=mt_this(blockbuf+blk->sublock+k,start,level);
		cleartag(blk);
		if(r) break;
	    }
	    goto end;
	}
	case -4: {	/* any unused smaller; not used */
	    unused_smaller:
	    for(j=0; j<blk->len && blk->tag[j]==0;j++);
	    for(k=blk->lstart;k<j;k++) {
		blk->tag[k]=blk->lind2;
		r=mt_this(blockbuf+blk->sublock+k,start,level);
		cleartag(blk);
		if(r) break;
	    }
	    goto end;
	}
	case -5: {	/* repeat */
	    re=blk->lind2-1;
	    if(blk->lind2<2 || blk->string == start) goto end;
	    blk->string=start;
	    r=mt_next(blk,start,level);
	    if(r) goto end;
	    blk->lind2=re;
	    i=blk->lists[blk->lind1][blk->lind2 - 1];
	    goto ppstart;
	}
	case -6: {
	    r=mt_next(blk,start,level);
	    if(r) goto end;
	    goto any;
	}
	case -7: {
	    r=mt_next(blk,start,level);
	    if(r) goto end;
	    goto unused;
	}
	case -8: {
	    r=mt_next(blk,start,level);
	    if(r) goto end;
	    goto unused_bigger;
	}
	case -9: {
	    r=mt_next(blk,start,level);
	    if(r) goto end;
	    goto unused_smaller;
	}
	case -10: {	/* unused. */
	    goto end;
	}
	case -11: {	/* unused. */
	    goto end;
	}
	case -12: {	/* insertion */
 	    if(blk->tag[0]==0) {
		blk->tag[0]=blk->lind2;
		r=mt_this(blockbuf+blk->sublock,start,level);
		cleartag(blk);
		if(r) goto end;
	    }
	    r=_permpick1(blk,start,level+1);
	    goto end;
	}
	case -13: {	/* insertion end */
	    if(blk->tag[0]) r=mt_next(blk,start,level+1);
	    else r=0;
	    goto end;
	}
    }
end:
    if(r==0) blk->lind2--;
    return r;
}

int mt_permpick(struct block *blk, char *start, int level)
{
    int r;
    if(blk->lind1==0 && blk->lind2==0) {
	for(r=0;blk->lind1<blk->lcnt;blk->lind1++,blk->lind2=0){
	    cleartag(blk);
	    r=_permpick1(blk,start,level);
	    if(r) break;
	}
	blk->lind1=blk->lind2=0;
	return r;
    }
    if(blk->lind2>=blk->listlen[blk->lind1]) {
	return mt_next(blk,start,level);
    }
    return _permpick1(blk,start,level);
}

int mt_neg(struct block *blk, char *start, int level)
{
    int r;
    if(blk->lind2) {
	return 1;
    }
    blk->lind2=1;
    r=mt_this(blockbuf+blk->sublock,start,level+1);
    blk->lind2=0;
    if(r==0) return mt_next(blk,start,level+1);
    if(r==1) return 0;
    else return r;
}

int mt_nomatch(struct block *blk, char *start, int level)
{
    return 0;
}

int mt_out(struct block *blk, char *start, int level)
{
    int r, l;
    char *tit;
    char buf[MAX_LINELEN+1];
    if(blk->lind2) {
	blk->string=start;
	return mt_next(blk,start,level+1);
    }
    blk->lind2++;
    tit=blk->string;
    r=mt_this(blockbuf+blk->sublock,start,level+1);
    blk->lind2=0;
    if(r) {
	l=blk->string - start;
	if(l>=0 && l<MAX_LINELEN) {
	    memmove(buf,start,l); buf[l]=0;
	    outval(tit, buf);
	}
    }
    blk->string=tit;
    return r;
}

int mt_w(struct block *blk, char *start, int level)
{
    char *p1, *p2;
    char buf[MAX_NAMELEN+1];
    int l;
    p1=find_word_start(start); p2=find_word_end(p1); l=p2-p1;
    if(*p2) p2++;
    if(l>=MAX_NAMELEN) return 0;
    memmove(buf,p1,l); buf[l]=0;
    if(wordchr(wbuf,buf)==NULL) return 0;
    return mt_next(blk,p2,level+1);
}

int mt_wild(struct block *blk, char *start, int level)
{
    char *p;
    int i,l,r;

    l=blk->lstart;
    for(i=0,p=find_word_start(start);i<l;i++,p=find_word_start(find_word_end(p))) {
	if(*p==0) return 0;
    }
    l=blk->len;
    if(l==0) return mt_next(blk,p,level+1);
    for(i=0; i<=l && *p; i++, p=find_word_start(find_word_end(p))) {
	r=mt_next(blk,p,level+1);
	if(r) return r;
    }
    if(i<=l) return mt_next(blk,p,level+1);
    else return 0;
}

int match(char *p)
{
    outptr=outbuf; *outptr=0;
    return mt_this(blockbuf,find_word_start(p),0);
}

