/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.jmol.util.Logger;

public class BinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setStream(BufferedInputStream bufferedInputStream, boolean bl) {
        if (bufferedInputStream == null) {
            return;
        }
        this.stream = new DataInputStream(bufferedInputStream);
        this.isBigEndian = bl;
    }

    public void setStream(DataInputStream dataInputStream) {
        this.stream = dataInputStream;
    }

    public void setRandom(boolean bl) {
        this.isRandom = bl;
    }

    public byte readByte() throws Exception {
        return this.stream.readByte();
    }

    public void readByteArray(byte[] byArray) throws Exception {
        this.stream.read(byArray);
    }

    public void readByteArray(byte[] byArray, int n, int n2) throws Exception {
        this.stream.read(byArray, n, n2);
    }

    public short readShort() throws Exception {
        return this.isBigEndian ? this.stream.readShort() : (short)(this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8);
    }

    public int readInt() throws Exception {
        return this.isBigEndian ? this.stream.readInt() : this.readLEInt();
    }

    public int readUnsignedShort() throws Exception {
        int n = this.stream.readByte() & 0xFF;
        int n2 = this.stream.readByte() & 0xFF;
        return this.isBigEndian ? (n << 8) + n2 : (n2 << 8) + n;
    }

    public long readLong() throws Exception {
        return this.isBigEndian ? this.stream.readLong() : (long)this.stream.readByte() & 0xFFL | ((long)this.stream.readByte() & 0xFFL) << 8 | ((long)this.stream.readByte() & 0xFFL) << 16 | ((long)this.stream.readByte() & 0xFFL) << 24 | ((long)this.stream.readByte() & 0xFFL) << 32 | ((long)this.stream.readByte() & 0xFFL) << 40 | ((long)this.stream.readByte() & 0xFFL) << 48 | ((long)this.stream.readByte() & 0xFFL) << 54;
    }

    public float readFloat() throws Exception {
        return this.isBigEndian ? this.stream.readFloat() : Float.intBitsToFloat(this.readLEInt());
    }

    public double readDouble() throws Exception {
        return this.isBigEndian ? this.stream.readDouble() : Double.longBitsToDouble(this.readLELong());
    }

    private int readLEInt() throws Exception {
        return this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8 | (this.stream.readByte() & 0xFF) << 16 | (this.stream.readByte() & 0xFF) << 24;
    }

    private long readLELong() throws Exception {
        return (long)this.stream.readByte() & 0xFFL | ((long)this.stream.readByte() & 0xFFL) << 8 | ((long)this.stream.readByte() & 0xFFL) << 16 | ((long)this.stream.readByte() & 0xFFL) << 24 | ((long)this.stream.readByte() & 0xFFL) << 32 | ((long)this.stream.readByte() & 0xFFL) << 40 | ((long)this.stream.readByte() & 0xFFL) << 48 | ((long)this.stream.readByte() & 0xFFL) << 56;
    }

    public void seek(long l) {
        try {
            this.stream.reset();
            this.stream.skipBytes((int)l);
        }
        catch (Exception exception) {
            Logger.error(null, exception);
        }
    }
}

