/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.functions.CubicSegment;
import edu.hws.jcm.functions.FunctionParserExtension;

public class TableFunction
extends FunctionParserExtension {
    public static final int SMOOTH = 0;
    public static final int PIECEWISE_LINEAR = 1;
    public static final int STEP = 2;
    public static final int STEP_LEFT = 3;
    public static final int STEP_RIGHT = 4;
    private int style;
    private double[] xCoords = new double[10];
    private double[] yCoords = new double[10];
    private CubicSegment[] segments;
    private int pointCt;

    public TableFunction() {
        this(0);
    }

    public TableFunction(int n) {
        this.style = this.style;
        if (this.style == 0) {
            this.segments = new CubicSegment[9];
        }
    }

    public void copyDataFrom(TableFunction tableFunction) {
        this.xCoords = (double[])tableFunction.xCoords.clone();
        this.yCoords = (double[])tableFunction.yCoords.clone();
        this.style = -1;
        this.setStyle(tableFunction.style);
    }

    public void setStyle(int n) {
        if (n == this.style || n < 0 || n > 4) {
            return;
        }
        this.style = n;
        if (n == 0) {
            this.segments = new CubicSegment[this.xCoords.length - 1];
            int n2 = 0;
            while (n2 < this.pointCt - 1) {
                this.segments[n2] = new CubicSegment(this.xCoords[n2], this.xCoords[n2 + 1], this.yCoords[n2], this.yCoords[n2 + 1], 0.0, 0.0);
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.pointCt - 1) {
                this.interpolateDerivatives(n3);
                ++n3;
            }
        } else {
            this.segments = null;
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void addPoints(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            return;
        }
        int n = dArray.length;
        if (dArray2 == null) {
            n = 0;
        } else if (dArray2.length < n) {
            n = dArray2.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(dArray[n2], dArray2[n2]);
            ++n2;
        }
        int n3 = n;
        while (n3 < dArray.length) {
            this.addPoint(dArray[n3], 0.0);
            ++n3;
        }
    }

    public void addIntervals(int n, double d, double d2) {
        if (n < 1) {
            return;
        }
        double d3 = (d2 - d) / (double)n;
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(d + (double)n2 * d3, 0.0);
            ++n2;
        }
        this.addPoint(d2, 0.0);
    }

    public int addPoint(double d, double d2) {
        int n;
        if (Double.isNaN(d)) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.pointCt && this.xCoords[n2] < d) {
            ++n2;
        }
        if (n2 < this.pointCt && this.xCoords[n2] == d) {
            this.yCoords[n2] = d2;
        } else {
            if (this.pointCt == this.xCoords.length) {
                double[] dArray = new double[2 * this.xCoords.length];
                System.arraycopy(this.xCoords, 0, dArray, 0, this.xCoords.length);
                this.xCoords = dArray;
                dArray = new double[2 * this.yCoords.length];
                System.arraycopy(this.yCoords, 0, dArray, 0, this.yCoords.length);
                this.yCoords = dArray;
                if (this.style == 0) {
                    CubicSegment[] cubicSegmentArray = new CubicSegment[this.xCoords.length - 1];
                    System.arraycopy(this.segments, 0, cubicSegmentArray, 0, this.pointCt - 1);
                    this.segments = cubicSegmentArray;
                }
            }
            n = this.pointCt;
            while (n > n2) {
                this.xCoords[n] = this.xCoords[n - 1];
                this.yCoords[n] = this.yCoords[n - 1];
                --n;
            }
            this.xCoords[n2] = d;
            this.yCoords[n2] = d2;
            if (this.style == 0 && this.pointCt > 0) {
                if (n2 == this.pointCt) {
                    this.segments[this.pointCt - 1] = new CubicSegment();
                } else {
                    int n3 = this.pointCt - 1;
                    while (n3 > n2) {
                        this.segments[n3] = this.segments[n3 - 1];
                        --n3;
                    }
                    this.segments[n2] = new CubicSegment();
                }
            }
            ++this.pointCt;
        }
        if (this.style == 0 && this.pointCt > 0) {
            if (n2 > 0) {
                this.segments[n2 - 1].setData(this.xCoords[n2 - 1], this.xCoords[n2], this.yCoords[n2 - 1], this.yCoords[n2], 0.0, 0.0);
            }
            if (n2 < this.pointCt - 1) {
                this.segments[n2].setData(this.xCoords[n2], this.xCoords[n2 + 1], this.yCoords[n2], this.yCoords[n2 + 1], 0.0, 0.0);
            }
            n = n2 - 2;
            while (n <= n2 + 1) {
                this.interpolateDerivatives(n);
                ++n;
            }
        }
        return n2;
    }

    private void interpolateDerivatives(int n) {
        if (n < 0 || n > this.pointCt - 2) {
            return;
        }
        if (this.pointCt == 2) {
            this.segments[0].setDerivativesFromNeighbors(Double.NaN, 0.0, Double.NaN, 0.0);
        } else if (n == 0) {
            this.segments[0].setDerivativesFromNeighbors(Double.NaN, 0.0, this.xCoords[2], this.yCoords[2]);
        } else if (n == this.pointCt - 2) {
            this.segments[this.pointCt - 2].setDerivativesFromNeighbors(this.xCoords[this.pointCt - 3], this.yCoords[this.pointCt - 3], Double.NaN, 0.0);
        } else {
            this.segments[n].setDerivativesFromNeighbors(this.xCoords[n - 1], this.yCoords[n - 1], this.xCoords[n + 2], this.yCoords[n + 2]);
        }
    }

    public int getPointCount() {
        return this.pointCt;
    }

    public double getX(int n) {
        if (n >= 0 && n < this.pointCt) {
            return this.xCoords[n];
        }
        throw new IllegalArgumentException("Point index out of range: " + n);
    }

    public double getY(int n) {
        if (n >= 0 && n < this.pointCt) {
            return this.yCoords[n];
        }
        throw new IllegalArgumentException("Point index out of range: " + n);
    }

    public void setY(int n, double d) {
        if (n < 0 || n >= this.pointCt) {
            throw new IllegalArgumentException("Point index out of range: " + n);
        }
        this.yCoords[n] = d;
        if (this.style == 0) {
            if (n > 0) {
                this.segments[n - 1].setData(this.xCoords[n - 1], this.xCoords[n], this.yCoords[n - 1], this.yCoords[n], 0.0, 0.0);
            }
            if (n < this.pointCt - 1) {
                this.segments[n].setData(this.xCoords[n], this.xCoords[n + 1], this.yCoords[n], this.yCoords[n + 1], 0.0, 0.0);
            }
            int n2 = n - 2;
            while (n2 <= n + 1) {
                this.interpolateDerivatives(n2);
                ++n2;
            }
        }
    }

    public int findPoint(double d) {
        int n = 0;
        while (n < this.pointCt) {
            if (d == this.xCoords[n]) {
                return n;
            }
            if (!(d > this.xCoords[n])) break;
            ++n;
        }
        return -1;
    }

    public void removePointAt(int n) {
        if (n < 0 || n >= this.pointCt) {
            throw new IllegalArgumentException("Point index out of range: " + n);
        }
        --this.pointCt;
        int n2 = n;
        while (n2 < this.pointCt) {
            this.xCoords[n2] = this.xCoords[n2 + 1];
            this.yCoords[n2] = this.yCoords[n2 + 1];
            ++n2;
        }
        if (this.style == 0) {
            this.style = -1;
            this.setStyle(0);
        }
    }

    public void removeAllPoints() {
        this.pointCt = 0;
        this.xCoords = new double[10];
        this.yCoords = new double[10];
    }

    public double getVal(double d) {
        return this.computeValue(d, null, 0);
    }

    /*
     * Exception decompiling
     */
    private double computeValue(double var1_1, Cases var3_2, int var4_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public double getValueWithCases(double[] dArray, Cases cases) {
        return this.computeValue(dArray[0], cases, 0);
    }

    public double getVal(double[] dArray) {
        return this.computeValue(dArray[0], null, 0);
    }

    public Function derivative(int n) {
        if (n != 1) {
            throw new IllegalArgumentException("Attempt to take the derivative of a function of one argument with respect to argument number " + n);
        }
        return new Deriv(this);
    }

    public Function derivative(Variable variable) {
        return null;
    }

    public boolean dependsOn(Variable variable) {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public void apply(StackOfDouble stackOfDouble, Cases cases) {
        double d = stackOfDouble.pop();
        stackOfDouble.push(this.computeValue(d, cases, 0));
    }

    private static class Deriv
    extends FunctionParserExtension {
        TableFunction derivativeOf;
        int derivativeLevel;

        Deriv(Deriv deriv) {
            this.derivativeLevel = deriv.derivativeLevel + 1;
            this.derivativeOf = deriv.derivativeOf;
        }

        Deriv(TableFunction tableFunction) {
            this.derivativeLevel = 1;
            this.derivativeOf = tableFunction;
        }

        public String getName() {
            String string = this.derivativeOf.getName();
            int n = 0;
            while (n < this.derivativeLevel) {
                string = String.valueOf(string) + "'";
                ++n;
            }
            return string;
        }

        public void setName(String string) {
        }

        public double getValueWithCases(double[] dArray, Cases cases) {
            return this.derivativeOf.computeValue(dArray[0], cases, this.derivativeLevel);
        }

        public double getVal(double[] dArray) {
            return this.derivativeOf.computeValue(dArray[0], null, this.derivativeLevel);
        }

        public Function derivative(int n) {
            if (n != 1) {
                throw new IllegalArgumentException("Attempt to take the derivative of a function of one argument with respect to argument number " + n);
            }
            return new Deriv(this);
        }

        public Function derivative(Variable variable) {
            return null;
        }

        public boolean dependsOn(Variable variable) {
            return false;
        }

        public int getArity() {
            return 1;
        }

        public void apply(StackOfDouble stackOfDouble, Cases cases) {
            double d = stackOfDouble.pop();
            stackOfDouble.push(this.derivativeOf.computeValue(d, cases, this.derivativeLevel));
        }
    }
}

