/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.StringTokenizer;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FunctionEditDialog;
import rene.zirkel.objects.MoveableObject;

public class UserFunctionObject
extends ConstructionObject
implements MoveableObject {
    Expression EY = null;
    double[] X = new double[]{0.0};
    String[] Var = new String[]{"x"};
    protected double Xpos;
    protected double Ypos;
    protected boolean Fixed;
    protected Expression EXpos;
    protected Expression EYpos;
    double C;
    double R;
    double W;
    double H;
    public boolean EditAborted;
    double oldx;
    double oldy;
    double startx;
    double starty;

    public UserFunctionObject(Construction construction) {
        super(construction);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Function";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(this.getDisplayValue());
    }

    public void validate() {
        this.Valid = this.EY != null ? this.EY.isValid() : false;
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            try {
                this.Xpos = this.EXpos.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            try {
                this.Ypos = this.EYpos.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
    }

    public void setExpressions(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.Var = new String[stringTokenizer.countTokens()];
        this.X = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.Var[n++] = stringTokenizer.nextToken();
        }
        this.EY = new Expression(string2, this.getConstruction(), this, this.Var);
        this.validate();
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        FontMetrics fontMetrics = myGraphics.getFontMetrics();
        this.W = this.H = (double)fontMetrics.getHeight();
        this.C = zirkelCanvas.col(this.Xpos);
        this.R = zirkelCanvas.row(this.Ypos);
        myGraphics.setColor(this);
        this.setFont(myGraphics);
        myGraphics.drawString(AngleObject.translateToUnicode(this.getDisplayValue()), this.C, this.R);
        this.R -= this.H;
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.X[0];
    }

    public double getValue(String string) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        for (int i = 0; i < this.Var.length; ++i) {
            if (!string.equals(this.Var[i])) continue;
            return this.X[i];
        }
        return this.X[0];
    }

    public String getDisplayValue() {
        String string = "";
        if (this.showName()) {
            if (this.getAlias() != null) {
                string = this.getAlias() + " : ";
            }
            string = string + this.getName() + "(" + this.Var[0];
            for (int i = 1; i < this.Var.length; ++i) {
                string = string + "," + this.Var[i];
            }
            string = string + ")";
            if (this.showValue()) {
                string = string + "=";
            }
        }
        if (this.showValue()) {
            string = string + (this.EY == null ? "" : this.EY.toString());
        }
        return string;
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        return this.C <= (double)n && this.R <= (double)n2 && (double)n <= this.C + this.W && (double)n2 <= this.R + this.H;
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        FunctionEditDialog functionEditDialog;
        while (true) {
            Warning warning;
            Frame frame;
            functionEditDialog = new FunctionEditDialog(zirkelCanvas, this);
            functionEditDialog.setVisible(true);
            this.EditAborted = false;
            if (functionEditDialog.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (!this.EY.isValid()) {
                frame = zirkelCanvas.getFrame();
                warning = new Warning(frame, this.EY.getErrorText(), Zirkel.name("warning"), true);
                warning.center(frame);
                warning.setVisible(true);
            }
            if (this.EXpos != null && !this.EXpos.isValid()) {
                frame = zirkelCanvas.getFrame();
                warning = new Warning(frame, this.EXpos.getErrorText(), Zirkel.name("warning"), true);
                warning.center(frame);
                warning.setVisible(true);
                continue;
            }
            if (this.EYpos == null || this.EYpos.isValid()) break;
            frame = zirkelCanvas.getFrame();
            warning = new Warning(frame, this.EYpos.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        this.validate();
        this.updateText();
        zirkelCanvas.getConstruction().updateCircleDep();
        zirkelCanvas.repaint();
        if (functionEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("f", this.EY.toString());
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            xmlWriter.printArg("x", this.EXpos.toString());
        } else {
            xmlWriter.printArg("x", "" + this.Xpos);
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            xmlWriter.printArg("y", this.EYpos.toString());
        } else {
            xmlWriter.printArg("y", "" + this.Ypos);
        }
        if (this.Fixed) {
            xmlWriter.printArg("fixed", "true");
        }
        xmlWriter.printArg("var", this.getVar());
    }

    public void translate() {
        try {
            this.EY = new Expression(this.EY.toString(), this.getConstruction(), this, this.Var);
            ConstructionObject constructionObject = this.getTranslation();
            this.setTranslation(this);
            if (this.Fixed) {
                try {
                    this.setFixed(this.EXpos.toString(), this.EYpos.toString());
                    this.EXpos.translate();
                    this.EYpos.translate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.validate();
            this.setTranslation(constructionObject);
        }
        catch (Exception exception) {
            System.out.println();
            System.out.println(this.getName());
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void setFixed(boolean bl) {
        this.Fixed = bl;
        if (!this.Fixed) {
            this.EYpos = null;
            this.EXpos = null;
        }
        this.updateText();
    }

    public void setFixed(String string, String string2) {
        this.Fixed = true;
        this.EXpos = new Expression(string, this.getConstruction(), this);
        this.EYpos = new Expression(string2, this.getConstruction(), this);
        this.updateText();
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public String getEXpos() {
        if (this.EXpos != null) {
            return this.EXpos.toString();
        }
        return "" + this.round(this.Xpos);
    }

    public String getEYpos() {
        if (this.EYpos != null) {
            return this.EYpos.toString();
        }
        return "" + this.round(this.Ypos);
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return false;
    }

    public boolean equals(ConstructionObject constructionObject) {
        return false;
    }

    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.EY);
        if (this.Fixed) {
            this.addDepending(this.EXpos);
            this.addDepending(this.EYpos);
        }
        return DL.elements();
    }

    public void addDepending(Expression expression) {
        if (expression != null) {
            Enumeration enumeration = expression.getDepList().elements();
            while (enumeration.hasMoreElements()) {
                DL.add((ConstructionObject)enumeration.nextElement());
            }
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public double evaluateF(double[] dArray) throws ConstructionException {
        int n;
        int n2 = dArray.length;
        if (n2 > this.X.length) {
            n2 = this.X.length;
        }
        for (n = 0; n < n2; ++n) {
            this.X[n] = dArray[n];
        }
        for (n = n2; n < this.X.length; ++n) {
            this.X[n] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception exception) {
            throw new ConstructionException("");
        }
    }

    public double evaluateF(double d2) throws ConstructionException {
        this.X[0] = d2;
        for (int i = 1; i < this.X.length; ++i) {
            this.X[i] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception exception) {
            throw new ConstructionException("");
        }
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean canDisplayName() {
        return true;
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public String getVar() {
        String string = this.Var[0];
        for (int i = 1; i < this.Var.length; ++i) {
            string = string + " " + this.Var[i];
        }
        return string;
    }

    public void dragTo(double d2, double d3) {
        this.move(this.oldx + (d2 - this.startx), this.oldy + (d3 - this.starty));
    }

    public void move(double d2, double d3) {
        this.Xpos = d2;
        this.Ypos = d3;
    }

    public boolean moveable() {
        return !this.Fixed;
    }

    public void startDrag(double d2, double d3) {
        this.oldx = this.Xpos;
        this.oldy = this.Ypos;
        this.startx = d2;
        this.starty = d3;
    }

    public double getX() {
        return this.Xpos;
    }

    public double getY() {
        return this.Ypos;
    }
}

