/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome;

import fr.ove.openmath.jome.ctrl.linear.LinearParser;
import fr.ove.openmath.jome.ctrlview.bidim.BidimDisplay;
import fr.ove.openmath.jome.ctrlview.bidim.Display;
import fr.ove.openmath.jome.ctrlview.bidim.FormulaDisplay;
import fr.ove.openmath.jome.ctrlview.bidim.GraphicContext;
import fr.ove.openmath.jome.ctrlview.bidim.OneFormulaLayout;
import fr.ove.openmath.jome.ctrlview.bidim.selection.SelectionManager;
import fr.ove.openmath.jome.model.Formula;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;

public class Jome
extends Container {
    private Formula formula;
    Display jomeDisplay;
    FormulaDisplay formulaDisplay;
    private GraphicContext graphicContext = new GraphicContext(new Font("Times New Roman", 0, 14), Color.black, Color.white, Color.yellow);
    LinearParser linearParser = new LinearParser();

    public Jome() {
        this.setLayout(new FlowLayout(0, 0, 0));
        super.setFont(this.graphicContext.getFont());
        this.formula = new Formula();
        this.linearParser.addLinearParserListener(this.formula);
        SelectionManager selectionManager = new SelectionManager();
        this.formulaDisplay = new FormulaDisplay();
        this.formulaDisplay.setGraphicContext(this.graphicContext);
        this.formulaDisplay.addControlListener(this.formula);
        this.formulaDisplay.setShiftX(10);
        this.formulaDisplay.setShiftY(10);
        this.formula.addModelListener(this.formulaDisplay);
        this.jomeDisplay = new BidimDisplay(this.graphicContext);
        this.jomeDisplay.drawBounds();
        OneFormulaLayout oneFormulaLayout = new OneFormulaLayout();
        oneFormulaLayout.initDisplay(this.jomeDisplay);
        this.jomeDisplay.setLayout(oneFormulaLayout);
        this.jomeDisplay.addSelectionEventListener(selectionManager);
        this.jomeDisplay.add(this.formulaDisplay);
        this.add(this.jomeDisplay);
        this.setLinear("");
    }

    public Dimension getPreferredSize() {
        return this.jomeDisplay.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        Color color2 = this.getBackground();
        if (color2 != null) {
            graphics.setColor(color2);
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(color);
        }
        super.paint(graphics);
    }

    public void setLinear(String string) {
        this.linearParser.parse(string);
        this.jomeDisplay.invalidate();
        this.jomeDisplay.setComputeAttributes(true);
        this.validate();
        this.repaint();
    }

    public String getLinear() {
        return this.formula.createLinear("");
    }

    public String getLinearSelection() {
        return this.formulaDisplay.getLinearSelection();
    }

    public void setShiftX(int n) {
        n = n < 1 ? 1 : n;
        this.formulaDisplay.setShiftX(n);
        this.jomeDisplay.invalidate();
        this.jomeDisplay.setComputeAttributes(true);
        this.validate();
        this.repaint();
    }

    public int getShiftX() {
        return this.formulaDisplay.getShiftX();
    }

    public void setShiftY(int n) {
        n = n < 1 ? 1 : n;
        this.formulaDisplay.setShiftY(n);
        this.jomeDisplay.invalidate();
        this.jomeDisplay.setComputeAttributes(true);
        this.validate();
        this.repaint();
    }

    public int getShiftY() {
        return this.formulaDisplay.getShiftY();
    }

    public void setFont(Font font) {
        this.graphicContext.setFont(font);
        this.formulaDisplay.setFont(font);
        this.jomeDisplay.invalidate();
        this.jomeDisplay.setComputeAttributes(true);
        this.validate();
        super.setFont(font);
    }

    public void setForegroundColor(Color color) {
        this.graphicContext.setForegroundColor(color);
        this.repaint();
    }

    public Color getForegroundColor() {
        return this.graphicContext.getForegroundColor();
    }

    public void setBackgroundColor(Color color) {
        this.graphicContext.setBackgroundColor(color);
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.graphicContext.getBackgroundColor();
    }

    public void setSelectionColor(Color color) {
        this.graphicContext.setSelectionColor(color);
        this.repaint();
    }

    public Color getSelectionColor() {
        return this.graphicContext.getSelectionColor();
    }

    public void setDrawBounds(boolean bl) {
        if (bl) {
            this.jomeDisplay.drawBounds();
        } else {
            this.jomeDisplay.dontDrawBounds();
        }
    }

    public boolean getDrawBounds() {
        return this.jomeDisplay.weDrawBounds();
    }

    public void iconifySelection() {
        this.formulaDisplay.iconify();
    }

    public void uniconifySelectedIcons() {
        this.formulaDisplay.uniconify();
    }

    public void uniconifyAllIcons() {
        this.formulaDisplay.uniconifyAll();
    }

    public void substitute(String string) {
        if (string != null && !string.equals("")) {
            this.formulaDisplay.substitute(string);
        }
    }
}

