/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.gdi.Arc;
import org.freehep.graphicsio.emf.gdi.BeginPath;
import org.freehep.graphicsio.emf.gdi.CreateBrushIndirect;
import org.freehep.graphicsio.emf.gdi.CreatePen;
import org.freehep.graphicsio.emf.gdi.DeleteObject;
import org.freehep.graphicsio.emf.gdi.EndPath;
import org.freehep.graphicsio.emf.gdi.FillPath;
import org.freehep.graphicsio.emf.gdi.LineTo;
import org.freehep.graphicsio.emf.gdi.LogBrush32;
import org.freehep.graphicsio.emf.gdi.LogPen;
import org.freehep.graphicsio.emf.gdi.MoveToEx;
import org.freehep.graphicsio.emf.gdi.SelectObject;
import org.freehep.util.io.Tag;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class EMF2SVG {
    private EMFInputStream is;
    private Element svg;
    private Element currentPath;
    private Element group;
    private Point currentPosition;
    private Object currentObject;
    private LogPen currentPen;
    private HashMap objects = new HashMap();

    public EMF2SVG(EMFInputStream eMFInputStream) {
        this.is = eMFInputStream;
    }

    public String getSVG() {
        XMLOutputter xMLOutputter;
        Object object;
        try {
            object = this.is.readHeader();
            System.out.println("header " + object);
            this.svg = new Element("svg");
            this.svg.setAttribute("version", "1.1");
            this.svg.setAttribute("width", "" + ((EMFHeader)object).getBounds().width / 10);
            this.svg.setAttribute("height", "" + ((EMFHeader)object).getBounds().height / 10);
            this.group = new Element("g");
            this.group.setAttribute("transform", "scale(0.1)");
            this.svg.addContent((Content)this.group);
            xMLOutputter = new Element("g");
            xMLOutputter.setAttribute("transform", "translate( " + -1 * ((EMFHeader)object).getBounds().x + " " + -1 * ((EMFHeader)object).getBounds().y + ")");
            this.group.addContent((Content)xMLOutputter);
            this.group = xMLOutputter;
            Tag tag = this.is.readTag();
            while (tag != null) {
                System.out.println(tag);
                this.map(tag);
                tag = this.is.readTag();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = null;
        try {
            xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
            object = xMLOutputter.outputString(this.svg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private void map(Tag tag) {
        if (tag instanceof Arc) {
            Arc arc = (Arc)tag;
            Element element = new Element("path");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("M" + arc.getStart().x + "," + arc.getStart().y);
            stringBuffer.append(" ");
            stringBuffer.append("a" + arc.getBounds().width / 2 + "," + arc.getBounds().height / 2);
            stringBuffer.append(" 0 ");
            stringBuffer.append(" 0,0");
            stringBuffer.append(arc.getEnd().x + "," + arc.getEnd().y);
            element.setAttribute("d", stringBuffer.toString());
            element.setAttribute("stroke", "blue");
            element.setAttribute("stroke-width", "1");
            this.group.addContent((Content)element);
        } else if (tag instanceof BeginPath) {
            this.beginPath();
        } else if (tag instanceof CreateBrushIndirect) {
            CreateBrushIndirect createBrushIndirect = (CreateBrushIndirect)tag;
            this.objects.put(new Integer(createBrushIndirect.getIndex()), createBrushIndirect.getBrush());
        } else if (tag instanceof CreatePen) {
            CreatePen createPen = (CreatePen)tag;
            this.currentPen = createPen.getPen();
        } else if (tag instanceof DeleteObject) {
            this.objects.remove(new Integer(((DeleteObject)tag).getIndex()));
        } else if (!(tag instanceof EndPath)) {
            if (tag instanceof FillPath) {
                if (this.currentObject instanceof LogBrush32) {
                    LogBrush32 logBrush32 = (LogBrush32)this.currentObject;
                    this.currentPath.setAttribute("fill", this.printColor(logBrush32.getColor()));
                    this.currentPath.setAttribute("fill-rule", "evenodd");
                } else {
                    System.out.println("unsupported object " + this.currentObject + " for FillPath");
                }
            } else if (tag instanceof LineTo) {
                LineTo lineTo = (LineTo)tag;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.currentPath.getAttributeValue("d"));
                stringBuffer.append("L " + lineTo.getPoint().x + " " + lineTo.getPoint().y + " ");
                Attribute attribute = this.currentPath.getAttribute("d");
                attribute.setValue(stringBuffer.toString());
            } else if (tag instanceof MoveToEx) {
                if (this.currentPath == null) {
                    this.beginPath();
                }
                MoveToEx moveToEx = (MoveToEx)tag;
                this.currentPosition = moveToEx.getPoint();
                StringBuffer stringBuffer = new StringBuffer();
                Attribute attribute = this.currentPath.getAttribute("d");
                stringBuffer.append(attribute.getValue());
                stringBuffer.append("M " + this.currentPosition.x + " " + this.currentPosition.y + " ");
                attribute.setValue(stringBuffer.toString());
            } else if (tag instanceof SelectObject) {
                this.currentObject = this.objects.get(new Integer(((SelectObject)tag).getIndex()));
            } else {
                System.out.println("tag " + tag + " not supported");
            }
        }
    }

    private void beginPath() {
        if (this.currentPath != null) {
            this.closePath();
        }
        this.currentPath = new Element("path");
        this.currentPath.setAttribute("d", "");
        if (this.currentPen != null) {
            this.currentPath.setAttribute("stroke", this.printColor(this.currentPen.getColor()));
            this.currentPath.setAttribute("stroke-width", "" + this.currentPen.getWidth());
        }
        this.group.addContent((Content)this.currentPath);
    }

    private void closePath() {
    }

    private String printColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        stringBuffer.append(Integer.toHexString(color.getRed()));
        stringBuffer.append(Integer.toHexString(color.getGreen()));
        stringBuffer.append(Integer.toHexString(color.getBlue()));
        String string = stringBuffer.toString();
        if ("#00ff".equals(string)) {
            string = "#00f";
        }
        return string.toString();
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            EMFInputStream eMFInputStream = new EMFInputStream(fileInputStream);
            EMF2SVG eMF2SVG = new EMF2SVG(eMFInputStream);
            File file = new File("test.svg");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(eMF2SVG.getSVG());
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

