/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.ImageSizePanel;
import org.freehep.graphicsio.exportchooser.ImageTypePanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.OptionTextField;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.util.UserProperties;

public class SVGExportFileType
extends AbstractExportFileType {
    private static final String[] versionList = new String[]{"Version 1.1 (REC-SVG11-20030114)"};
    private OptionCheckBox compress;

    public String getDescription() {
        return "Scalable Vector Graphics";
    }

    public String[] getExtensions() {
        return new String[]{"svg", "svgz"};
    }

    public String[] getMIMETypes() {
        return new String[]{"image/svg+xml"};
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties properties) {
        UserProperties userProperties = new UserProperties(properties, SVGGraphics2D.getDefaultProperties());
        String string = SVGGraphics2D.class.getName();
        ImageSizePanel imageSizePanel = new ImageSizePanel(userProperties, string);
        OptionPanel optionPanel = new OptionPanel("Format");
        optionPanel.add("0 * [5 15 5 15] r", new JLabel("SVG Version"));
        optionPanel.add("1 * [5 15 5 15] lw", new OptionComboBox(userProperties, SVGGraphics2D.VERSION, versionList));
        this.compress = new OptionCheckBox(userProperties, SVGGraphics2D.COMPRESS, "Compress");
        optionPanel.add("0 * * 1 [5 15 5 15] w", this.compress);
        optionPanel.add("0 * * 1 [5 15 5 15] w", new OptionCheckBox(userProperties, SVGGraphics2D.STYLABLE, "Stylable"));
        OptionPanel optionPanel2 = new OptionPanel("Embed / Export Images");
        OptionCheckBox optionCheckBox = new OptionCheckBox(userProperties, SVGGraphics2D.EXPORT_IMAGES, "Export");
        optionPanel2.add("0 * * 1 [5 15 5 15] w", optionCheckBox);
        JLabel jLabel = new JLabel("Image Suffix");
        optionPanel2.add("0 * [5 15 5 15] r", jLabel);
        optionCheckBox.enables(jLabel);
        OptionTextField optionTextField = new OptionTextField(userProperties, SVGGraphics2D.EXPORT_SUFFIX, 20);
        optionPanel2.add("1 * [5 15 5 15] lw", optionTextField);
        optionCheckBox.enables(optionTextField);
        InfoPanel infoPanel = new InfoPanel(userProperties, string, new String[]{"Creator", "Title"});
        OptionPanel optionPanel3 = new OptionPanel();
        optionPanel3.add("0 * wt", imageSizePanel);
        optionPanel3.add("0 * wt", optionPanel);
        optionPanel3.add("0 * wh", new JLabel());
        OptionPanel optionPanel4 = new OptionPanel();
        optionPanel4.add("0 * wt", new BackgroundPanel(userProperties, string, true));
        optionPanel4.add("0 * wt", optionPanel2);
        optionPanel4.add("0 * wt", new ImageTypePanel(userProperties, string, new String[]{"Smallest Size", "PNG", "JPG"}));
        optionPanel4.add("0 * wh", new JLabel());
        OptionPanel optionPanel5 = new OptionPanel();
        optionPanel5.add("0 0 [5 5 5 5] wt", optionPanel3);
        optionPanel5.add("1 0 [5 5 5 5] wt", optionPanel4);
        optionPanel5.add("0 1 2 1 [5 5 5 5] wt", infoPanel);
        optionPanel5.add("0 * wh", new JLabel());
        return optionPanel5;
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Component component) throws IOException {
        return new SVGGraphics2D(outputStream, component);
    }

    public VectorGraphics getGraphics(File file, Component component) throws IOException {
        return new SVGGraphics2D(file, component);
    }

    public File adjustFilename(File file, Properties properties) {
        UserProperties userProperties = new UserProperties(properties, SVGGraphics2D.getDefaultProperties());
        if (userProperties.isProperty(SVGGraphics2D.COMPRESS)) {
            return SVGExportFileType.adjustExtension(file, "svgz", null, "");
        }
        return SVGExportFileType.adjustExtension(file, "svg", null, "");
    }
}

