/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.svg.SVGGlyph;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class SVGFontTable {
    private Hashtable glyphs = new Hashtable();
    private static final Properties replaceFonts = new Properties();

    private SVGGlyph addGlyph(int n2, Font font) {
        Hashtable hashtable = this.getGlyphs(font);
        SVGGlyph sVGGlyph = (SVGGlyph)hashtable.get(String.valueOf(n2));
        if (sVGGlyph == null) {
            sVGGlyph = this.createGlyph(n2, font);
            hashtable.put(String.valueOf(n2), sVGGlyph);
        }
        return sVGGlyph;
    }

    private SVGGlyph createGlyph(int n2, Font font) {
        GlyphVector glyphVector = font.createGlyphVector(new FontRenderContext(null, true, true), String.valueOf((char)n2));
        return new SVGGlyph(glyphVector.getGlyphOutline(0), n2, glyphVector.getGlyphMetrics(0));
    }

    protected void addGlyphs(String string, Font font) {
        font = this.untransform(font);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.addGlyph(string.charAt(i2), font);
        }
    }

    private Hashtable getGlyphs(Font font) {
        Hashtable hashtable = (Hashtable)this.glyphs.get(font = this.untransform(font));
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.glyphs.put(font, hashtable);
        }
        return hashtable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.glyphs.keys();
        while (enumeration.hasMoreElements()) {
            Font font = (Font)enumeration.nextElement();
            Map<TextAttribute, ?> map = font.getAttributes();
            SVGFontTable.normalize(map);
            stringBuffer.append("<font id=\"");
            stringBuffer.append(map.get(TextAttribute.FAMILY));
            stringBuffer.append("\">\n");
            stringBuffer.append("<font-face font-family=\"");
            stringBuffer.append(map.get(TextAttribute.FAMILY));
            stringBuffer.append("\" ");
            if (TextAttribute.WEIGHT_BOLD.equals(map.get(TextAttribute.WEIGHT))) {
                stringBuffer.append("font-weight=\"bold\" ");
            } else {
                stringBuffer.append("font-weight=\"normal\" ");
            }
            if (TextAttribute.POSTURE_OBLIQUE.equals(map.get(TextAttribute.POSTURE))) {
                stringBuffer.append("font-style=\"italic\" ");
            } else {
                stringBuffer.append("font-style=\"normal\" ");
            }
            Float f2 = (Float)map.get(TextAttribute.SIZE);
            stringBuffer.append("font-size=\"");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(f2.floatValue()));
            stringBuffer.append("\" ");
            stringBuffer.append("units-per-em=\"");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(SVGGlyph.FONT_SIZE));
            stringBuffer.append("\" ");
            TextLayout textLayout = new TextLayout("By", font, new FontRenderContext(new AffineTransform(), true, true));
            stringBuffer.append("ascent=\"");
            stringBuffer.append(textLayout.getAscent());
            stringBuffer.append("\" ");
            stringBuffer.append("desscent=\"");
            stringBuffer.append(textLayout.getDescent());
            stringBuffer.append("\" ");
            stringBuffer.append("/>\n");
            SVGGlyph sVGGlyph = this.createGlyph(font.getMissingGlyphCode(), font);
            stringBuffer.append("<missing-glyph ");
            stringBuffer.append(sVGGlyph.getHorizontalAdvanceXString());
            stringBuffer.append(" ");
            stringBuffer.append(sVGGlyph.getPathString());
            stringBuffer.append("/>\n");
            Iterator iterator = this.getGlyphs(font).values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                stringBuffer.append("\n");
            }
            stringBuffer.append("</font>\n");
        }
        return stringBuffer.toString();
    }

    private Font untransform(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        map.put(TextAttribute.SIZE, new Float(SVGGlyph.FONT_SIZE));
        map.remove(TextAttribute.TRANSFORM);
        map.remove(TextAttribute.SUPERSCRIPT);
        return new Font(map);
    }

    public static void normalize(Map map) {
        FontTable.normalize(map);
        String string = replaceFonts.getProperty(((String)map.get(TextAttribute.FAMILY)).toLowerCase());
        if (string == null) {
            string = (String)map.get(TextAttribute.FAMILY);
        }
        map.put(TextAttribute.FAMILY, string);
    }

    static {
        replaceFonts.setProperty("dialog", "Helvetica");
        replaceFonts.setProperty("dialoginput", "Courier New");
        replaceFonts.setProperty("serif", "Times");
        replaceFonts.setProperty("timesroman", "Times");
        replaceFonts.setProperty("sansserif", "Helvetica");
        replaceFonts.setProperty("monospaced", "Courier New");
        replaceFonts.setProperty("zapfdingbats", "Wingdings");
    }
}

