/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class EMFPolygon
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPoints;
    private Point[] points;

    public EMFPolygon() {
        super(3, 1);
    }

    public EMFPolygon(Rectangle rectangle, int n2, Point[] pointArray) {
        this();
        this.bounds = rectangle;
        this.numberOfPoints = n2;
        this.points = pointArray;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n4 = eMFInputStream.readDWORD();
        EMFPolygon eMFPolygon = new EMFPolygon(rectangle, n4, eMFInputStream.readPOINTL(n4));
        return eMFPolygon;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeDWORD(this.numberOfPoints);
        eMFOutputStream.writePOINTL(this.numberOfPoints, this.points);
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #points: " + this.numberOfPoints;
    }
}

