/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;

public class ProgressDialog
extends JDialog {
    private JProgressBar progressBar;
    private JLabel label;
    private int progress;
    private IOException exception;
    private AbstractExportFileType.CancelThread thread;

    public ProgressDialog(Component component, int n2, String string) {
        this.setTitle("Exporting file...");
        this.setModal(true);
        this.exception = null;
        this.progress = 0;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.progressBar = new JProgressBar(0, n2);
        jPanel.add(this.progressBar);
        this.label = new JLabel(string);
        jPanel.add(this.label);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.this.cancel();
            }
        });
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel2, "South");
        this.setDefaultCloseOperation(0);
        this.pack();
        if (component != null) {
            Point point = component.getLocation();
            this.setLocation(point.x + component.getWidth() / 2 - this.getWidth() / 2, point.y + component.getHeight() / 2 - this.getHeight() / 2);
        }
    }

    public void step(String string) {
        this.progressBar.setValue(++this.progress);
        this.label.setText(string);
        this.repaint();
    }

    public void exceptionOccured(IOException iOException) {
        this.exception = iOException;
    }

    public IOException getException() {
        return this.exception;
    }

    public void interruptOnCancel(AbstractExportFileType.CancelThread cancelThread) {
        this.thread = cancelThread;
    }

    public void cancel() {
        if (this.thread != null) {
            this.thread.cancel();
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.dispose();
    }
}

