/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.ASCII85;
import org.freehep.util.io.EncodingException;

public class ASCII85InputStream
extends InputStream
implements ASCII85 {
    private boolean endReached;
    private int[] b = new int[4];
    private int bIndex;
    private int bLength;
    private int[] c = new int[5];
    private int lineNo;
    private int prev;
    private InputStream in;

    public ASCII85InputStream(InputStream inputStream) {
        this.in = inputStream;
        this.bIndex = 0;
        this.bLength = 0;
        this.endReached = false;
        this.prev = -1;
        this.lineNo = 1;
    }

    public int read() throws IOException {
        if (this.bIndex >= this.bLength) {
            if (this.endReached) {
                return -1;
            }
            this.bLength = this.readTuple();
            if (this.bLength < 0) {
                return -1;
            }
            this.bIndex = 0;
        }
        int n2 = this.b[this.bIndex];
        ++this.bIndex;
        return n2;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    private int readTuple() throws IOException, EncodingException {
        int n2 = 0;
        int n3 = -1;
        block8: while (!this.endReached && n2 < 5) {
            this.prev = n3;
            n3 = this.in.read();
            switch (n3) {
                case -1: {
                    throw new EncodingException("missing '~>' at end of ASCII85 stream");
                }
                case 122: {
                    this.b[3] = 33;
                    this.b[2] = 33;
                    this.b[1] = 33;
                    this.b[0] = 33;
                    return 4;
                }
                case 126: {
                    if (this.in.read() != 62) {
                        throw new EncodingException("Invalid ASCII85 EOD");
                    }
                    this.endReached = true;
                    continue block8;
                }
                case 13: {
                    ++this.lineNo;
                    continue block8;
                }
                case 10: {
                    if (this.prev == 13) continue block8;
                    ++this.lineNo;
                    continue block8;
                }
                case 0: 
                case 9: 
                case 12: 
                case 32: {
                    continue block8;
                }
            }
            this.c[n2] = n3;
            ++n2;
        }
        if (n2 > 0) {
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                if (i2 >= n2) {
                    this.c[i2] = 33;
                    continue;
                }
                int n4 = i2;
                this.c[n4] = this.c[n4] - 33;
            }
            long l2 = (long)this.c[0] * 52200625L + (long)this.c[1] * 614125L + (long)this.c[2] * 7225L + (long)this.c[3] * 85L + (long)this.c[4] & 0xFFFFFFFFL;
            this.b[0] = (int)(l2 >> 24 & 0xFFL);
            this.b[1] = (int)(l2 >> 16 & 0xFFL);
            this.b[2] = (int)(l2 >> 8 & 0xFFL);
            this.b[3] = (int)(l2 & 0xFFL);
        }
        return n2 - 1;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Usage: ASCII85InputStream filename");
            System.exit(1);
        }
        ASCII85InputStream aSCII85InputStream = new ASCII85InputStream(new FileInputStream(stringArray[0]));
        int n2 = aSCII85InputStream.read();
        while (n2 != -1) {
            System.out.write(n2);
            n2 = aSCII85InputStream.read();
        }
        aSCII85InputStream.close();
        System.out.flush();
    }
}

