/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.Molecule;
import java.util.ArrayList;

public class DataSheet {
    public static final int COLTYPE_MOLECULE = 1;
    public static final int COLTYPE_STRING = 2;
    public static final int COLTYPE_INTEGER = 3;
    public static final int COLTYPE_REAL = 4;
    public static final int COLTYPE_BOOLEAN = 5;
    private ArrayList<Column> cols = new ArrayList();
    private ArrayList<Object[]> rows = new ArrayList();
    private boolean isDirty = false;

    public int NumCols() {
        return this.cols.size();
    }

    public int NumRows() {
        return this.rows.size();
    }

    public static String TypeName(int Type2) {
        return Type2 == 1 ? "molecule" : (Type2 == 2 ? "string" : (Type2 == 4 ? "real" : (Type2 == 3 ? "integer" : (Type2 == 5 ? "boolean" : "?"))));
    }

    public boolean IsDirty() {
        return this.isDirty;
    }

    public void SetDirty() {
        this.isDirty = true;
    }

    public void ClearDirty() {
        this.isDirty = false;
    }

    public String ColName(int N) {
        return this.cols.get((int)N).Name;
    }

    public int ColType(int N) {
        return this.cols.get((int)N).Type;
    }

    public String ColDescr(int N) {
        return this.cols.get((int)N).Descr;
    }

    public boolean IsNull(int RN, int CN) {
        return this.rows.get(RN)[CN] == null;
    }

    public Molecule GetMolecule(int RN, int CN) {
        return (Molecule)this.rows.get(RN)[CN];
    }

    public String GetString(int RN, int CN) {
        return (String)this.rows.get(RN)[CN];
    }

    public int GetInteger(int RN, int CN) {
        return (Integer)this.rows.get(RN)[CN];
    }

    public double GetReal(int RN, int CN) {
        return (Double)this.rows.get(RN)[CN];
    }

    public boolean GetBoolean(int RN, int CN) {
        return (Boolean)this.rows.get(RN)[CN];
    }

    public Object GetObject(int RN, int CN) {
        return this.rows.get(RN)[CN];
    }

    public void SetToNull(int RN, int CN) {
        this.rows.get((int)RN)[CN] = null;
    }

    public void SetMolecule(int RN, int CN, Molecule V) {
        if (this.ColType(CN) == 1) {
            this.rows.get((int)RN)[CN] = V == null ? V : V.Clone();
        }
    }

    public void SetString(int RN, int CN, String V) {
        if (this.ColType(CN) == 2) {
            this.rows.get((int)RN)[CN] = V;
        }
    }

    public void SetInteger(int RN, int CN, int V) {
        if (this.ColType(CN) == 3) {
            this.rows.get((int)RN)[CN] = new Integer(V);
        }
    }

    public void SetReal(int RN, int CN, double V) {
        if (this.ColType(CN) == 4) {
            this.rows.get((int)RN)[CN] = new Double(V);
        }
    }

    public void SetBoolean(int RN, int CN, boolean V) {
        if (this.ColType(CN) == 5) {
            this.rows.get((int)RN)[CN] = new Boolean(V);
        }
    }

    public void SetObject(int RN, int CN, Object V) {
        this.rows.get((int)RN)[CN] = V;
    }

    public int AppendColumn(String Name, int Type2, String Descr) {
        Column c = new Column();
        c.Name = Name;
        c.Type = Type2;
        c.Descr = Descr;
        this.cols.add(c);
        for (int n = 0; n < this.rows.size(); ++n) {
            Object[] d1 = this.rows.get(n);
            Object[] d2 = new Object[d1.length + 1];
            for (int i = 0; i < d1.length; ++i) {
                d2[i] = d1[i];
            }
            d2[d1.length] = null;
            this.rows.set(n, d2);
        }
        return this.cols.size() - 1;
    }

    public int AppendRow() {
        this.rows.add(new Object[this.cols.size()]);
        return this.rows.size() - 1;
    }

    public void DeleteRow(int RN) {
        this.rows.remove(RN);
    }

    public void DeleteColumn(int CN) {
        this.cols.remove(CN);
        for (int n = 0; n < this.rows.size(); ++n) {
            Object[] prev = this.rows.get(n);
            Object[] cur = new Object[this.cols.size() - 1];
            int j = 0;
            for (int i = 0; i < prev.length; ++i) {
                if (i == CN) continue;
                cur[j++] = prev[i];
            }
            this.rows.set(n, cur);
        }
    }

    public void ChangeColumnName(int CN, String Name, String Descr) {
        Column c = this.cols.get(CN);
        if (Name != null) {
            c.Name = Name;
        }
        if (Descr != null) {
            c.Descr = Descr;
        }
    }

    public boolean ChangeColumnType(int CN, int NewType, boolean Force) {
        boolean incompatible;
        if (CN < 0 || CN >= this.NumCols()) {
            return false;
        }
        if (this.ColType(CN) == NewType) {
            return true;
        }
        boolean bl = incompatible = this.ColType(CN) == 1 || NewType == 1;
        if (incompatible && !Force) {
            return false;
        }
        Column col = this.cols.get(CN);
        int prevType = col.Type;
        col.Type = NewType;
        int nrows = this.rows.size();
        for (int n = 0; n < nrows; ++n) {
            Object[] row = this.rows.get(n);
            if (row[CN] == null) continue;
            if (incompatible) {
                row[CN] = null;
                continue;
            }
            String val = "";
            if (prevType == 2) {
                val = (String)row[CN];
            } else if (prevType == 3) {
                val = String.valueOf((Integer)row[CN]);
            } else if (prevType == 4) {
                val = String.valueOf(((Double)row[CN]).intValue());
            } else if (prevType == 5) {
                val = (Boolean)row[CN] != false ? "true" : "false";
            }
            row[CN] = null;
            try {
                if (NewType == 2) {
                    row[CN] = val;
                    continue;
                }
                if (NewType == 3) {
                    row[CN] = new Integer(val);
                    continue;
                }
                if (NewType == 4) {
                    row[CN] = new Double(val);
                    continue;
                }
                if (NewType != 5) continue;
                row[CN] = val.toLowerCase().compareTo("true") == 0 ? Boolean.TRUE : Boolean.FALSE;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return true;
    }

    public void ReorderColumns(int[] Order) {
        int n;
        boolean identity = true;
        for (int n2 = 0; n2 < Order.length - 1; ++n2) {
            if (Order[n2] == Order[n2 + 1] + 1) continue;
            identity = false;
            break;
        }
        if (identity) {
            return;
        }
        ArrayList<Column> newcols = new ArrayList<Column>();
        for (n = 0; n < this.cols.size(); ++n) {
            newcols.add(this.cols.get(Order[n]));
        }
        this.cols = newcols;
        for (n = 0; n < this.rows.size(); ++n) {
            Object[] row = this.rows.get(n);
            Object[] newrow = new Object[row.length];
            for (int i = 0; i < row.length; ++i) {
                newrow[i] = row[Order[i]];
            }
            this.rows.set(n, newrow);
        }
    }

    class Column {
        String Name;
        int Type;
        String Descr;

        Column() {
        }
    }
}

