/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.MathObject;
import java.io.Serializable;
import java.util.Hashtable;

public class SymbolTable
implements Serializable {
    private Hashtable symbols;
    private SymbolTable parent;

    SymbolTable() {
        this(null);
    }

    SymbolTable(SymbolTable symbolTable) {
        this.parent = symbolTable;
        this.symbols = new Hashtable();
    }

    SymbolTable getParent() {
        return this.parent;
    }

    public synchronized MathObject get(String string) {
        if (string == null) {
            return null;
        }
        Object v = this.symbols.get(string);
        if (v != null) {
            return (MathObject)v;
        }
        if (this.parent != null) {
            return this.parent.get(string);
        }
        return null;
    }

    public synchronized void add(MathObject mathObject) {
        if (mathObject == null) {
            throw new NullPointerException("Can't put a null symbol in SymbolTable.");
        }
        this.add(mathObject.getName(), mathObject);
    }

    public synchronized void add(String string, MathObject mathObject) {
        if (mathObject == null) {
            throw new NullPointerException("Can't put a null symbol in SymbolTable.");
        }
        if (string == null) {
            throw new NullPointerException("Can't put unnamed MathObject in SymbolTable.");
        }
        this.symbols.put(string, mathObject);
    }

    public synchronized void remove(String string) {
        if (string != null) {
            this.symbols.remove(string);
        }
    }
}

