/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.objects.AngleObject;

class AngleEditDialog
extends ObjectEditDialog
implements IconBarListener {
    TextField Length;
    Checkbox Fixed;
    IconBar SizeIB;

    public AngleEditDialog(Frame frame, AngleObject angleObject) {
        super(frame, Zirkel.name("edit.angle.title"), angleObject, "angle");
    }

    public void addFirst(Panel panel) {
        AngleObject angleObject = (AngleObject)this.O;
        this.Length = new TextFieldAction(this, "Length", angleObject.getE(), 30);
        panel.add(new MyLabel(Zirkel.name("edit.angle.length")));
        panel.add(this.Length);
        if (angleObject.canFix()) {
            this.Fixed = new Checkbox("");
            this.Fixed.setState(angleObject.fixed());
        } else {
            this.Length.setEditable(false);
        }
        if (this.Fixed != null) {
            panel.add(new MyLabel(Zirkel.name("edit.fixed")));
            panel.add(this.Fixed);
        }
    }

    public void doAction(String string) {
        if (string.equals("Length") && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else {
            super.doAction(string);
        }
    }

    public void addSecond(Panel panel) {
        AngleObject angleObject = (AngleObject)this.O;
        this.SizeIB = new IconBar(this.F);
        this.SizeIB.addToggleGroupLeft("angle", 5);
        this.SizeIB.toggle("angle", angleObject.getDisplaySize());
        this.SizeIB.addSeparatorLeft();
        this.SizeIB.addOnOffLeft("filled");
        this.SizeIB.setState("filled", angleObject.isFilled());
        this.SizeIB.addOnOffLeft("obtuse");
        this.SizeIB.setState("obtuse", angleObject.getObtuse());
        panel.add(new MyLabel(""));
        panel.add(this.SizeIB);
        this.SizeIB.setIconBarListener(this);
    }

    public void iconPressed(String string) {
        if (string.equals("filled")) {
            if (this.SizeIB.getState("filled")) {
                this.IB.setState("isback", true);
                this.ThicknessIB.setEnabled("solid", true);
            } else {
                this.IB.setState("isback", false);
                this.ThicknessIB.setState("solid", false);
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        super.iconPressed(string);
    }

    public void setAction() {
        AngleObject angleObject = (AngleObject)this.O;
        if (this.Fixed != null && this.Fixed.getState()) {
            angleObject.setFixed(this.Length.getText());
        }
        if (this.Fixed != null && !this.Fixed.getState()) {
            angleObject.setFixed(false);
        }
        angleObject.setDisplaySize(this.SizeIB.getToggleState("angle"));
        angleObject.setFilled(this.SizeIB.getState("filled"));
        angleObject.setObtuse(this.SizeIB.getState("obtuse"));
        Global.setParameter("unit.angle", this.Unit.getText());
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.Length.requestFocus();
        } else {
            super.focusGained(focusEvent);
        }
    }
}

