/*
 * Copyright 1998, Luiz Otavio L. Zorzella
 *           1999, Eric Pouech
 *
 * Purpose:   multimedia declarations (internal to WINMM & MMSYSTEM DLLs)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <stdarg.h>

#include "windef.h"
#include "winbase.h"
#include "mmddk.h"

/* Who said goofy boy ? */
#define	WINE_DI_MAGIC	0x900F1B01

typedef struct tagWINE_DRIVER
{
    DWORD			dwMagic;
    /* as usual LPWINE_DRIVER == hDriver32 */
    DWORD			dwFlags;
    HMODULE			hModule;
    DRIVERPROC			lpDrvProc;
    DWORD_PTR		  	dwDriverID;
    struct tagWINE_DRIVER*	lpPrevItem;
    struct tagWINE_DRIVER*	lpNextItem;
} WINE_DRIVER, *LPWINE_DRIVER;

typedef	DWORD	(CALLBACK *WINEMM_msgFunc32)(UINT, UINT, DWORD_PTR, DWORD_PTR, DWORD_PTR);

/* for each loaded driver and each known type of driver, this structure contains
 * the information needed to access it
 */
typedef struct tagWINE_MM_DRIVER_PART {
    int				nIDMin;		/* lower bound of global indexes for this type */
    int				nIDMax;		/* hhigher bound of global indexes for this type */
    WINEMM_msgFunc32	        fnMessage32;	/* pointer to function */
} WINE_MM_DRIVER_PART;

#define	MMDRV_AUX		0
#define	MMDRV_MIXER		1
#define	MMDRV_MIDIIN		2
#define	MMDRV_MIDIOUT		3
#define	MMDRV_WAVEIN		4
#define	MMDRV_WAVEOUT		5
#define MMDRV_MAX		6

/* each low-level .drv will be associated with an instance of this structure */
typedef struct tagWINE_MM_DRIVER {
    HDRVR			hDriver;
    LPSTR			drvname;	/* name of the driver */
    unsigned			bIsMapper : 1;	/* TRUE if mapper */
    WINE_MM_DRIVER_PART		parts[MMDRV_MAX];/* Information for all known types */
} WINE_MM_DRIVER, *LPWINE_MM_DRIVER;

typedef struct tagWINE_MLD {
/* EPP struct tagWINE_MLD*	lpNext; */		/* not used so far */
       UINT			uDeviceID;
       UINT			type;
       UINT			mmdIndex;		/* index to low-level driver in MMDrvs table */
       DWORD_PTR		dwDriverInstance;	/* this value is driver related, as opposed to
							 * opendesc.dwInstance which is client (callback) related */
       WORD			dwFlags;
       DWORD_PTR		dwCallback;
       DWORD_PTR		dwClientInstance;
} WINE_MLD, *LPWINE_MLD;

typedef struct  {
       WINE_MLD			mld;
} WINE_WAVE, *LPWINE_WAVE;

typedef struct {
       WINE_MLD			mld;
       MIDIOPENDESC		mod;			/* FIXME: should be removed */
} WINE_MIDI, *LPWINE_MIDI;

typedef struct {
       WINE_MLD			mld;
} WINE_MIXER, *LPWINE_MIXER;

typedef struct tagWINE_MCIDRIVER {
        UINT			wDeviceID;
        UINT			wType;
        LPWSTR			lpstrDeviceType;
        LPWSTR			lpstrAlias;
        HDRVR			hDriver;
        DWORD_PTR               dwPrivate;
        YIELDPROC		lpfnYieldProc;
        DWORD	                dwYieldData;
        DWORD                   CreatorThread;
        UINT			uTypeCmdTable;
        UINT			uSpecificCmdTable;
        struct tagWINE_MCIDRIVER*lpNext;
} WINE_MCIDRIVER, *LPWINE_MCIDRIVER;

struct IOProcList
{
    struct IOProcList*pNext;       /* Next item in linked list */
    FOURCC            fourCC;      /* four-character code identifying IOProc */
    LPMMIOPROC	      pIOProc;     /* pointer to IProc */
    BOOL              is_unicode;  /* 32A or 32W */
    int		      count;	   /* number of objects linked to it */
};

typedef struct tagWINE_MMIO {
    MMIOINFO			info;
    struct tagWINE_MMIO*	lpNext;
    struct IOProcList*		ioProc;
    unsigned			bTmpIOProc : 1,
                                bBufferLoaded : 1;
    DWORD                       dwFileSize;
} WINE_MMIO, *LPWINE_MMIO;

/* function prototypes */

LPWINE_DRIVER	DRIVER_FindFromHDrvr(HDRVR hDrvr) DECLSPEC_HIDDEN;
BOOL		DRIVER_GetLibName(LPCWSTR keyName, LPCWSTR sectName, LPWSTR buf, int sz) DECLSPEC_HIDDEN;
LPWINE_DRIVER	DRIVER_TryOpenDriver32(LPCWSTR fn, LPARAM lParam2) DECLSPEC_HIDDEN;
void            DRIVER_UnloadAll(void) DECLSPEC_HIDDEN;

void            MMDRV_Exit(void) DECLSPEC_HIDDEN;
UINT		MMDRV_GetNum(UINT) DECLSPEC_HIDDEN;
LPWINE_MLD	MMDRV_Alloc(UINT size, UINT type, LPHANDLE hndl, DWORD* dwFlags,
                            DWORD_PTR* dwCallback, DWORD_PTR* dwInstance) DECLSPEC_HIDDEN;
void		MMDRV_Free(HANDLE hndl, LPWINE_MLD mld) DECLSPEC_HIDDEN;
DWORD		MMDRV_Open(LPWINE_MLD mld, UINT wMsg, DWORD_PTR dwParam1, DWORD dwParam2) DECLSPEC_HIDDEN;
DWORD		MMDRV_Close(LPWINE_MLD mld, UINT wMsg) DECLSPEC_HIDDEN;
LPWINE_MLD	MMDRV_Get(HANDLE hndl, UINT type, BOOL bCanBeID) DECLSPEC_HIDDEN;
LPWINE_MLD	MMDRV_GetRelated(HANDLE hndl, UINT srcType, BOOL bSrcCanBeID, UINT dstTyped) DECLSPEC_HIDDEN;
DWORD           MMDRV_Message(LPWINE_MLD mld, UINT wMsg, DWORD_PTR dwParam1, DWORD_PTR dwParam2) DECLSPEC_HIDDEN;
UINT		MMDRV_PhysicalFeatures(LPWINE_MLD mld, UINT uMsg, DWORD_PTR dwParam1, DWORD_PTR dwParam2) DECLSPEC_HIDDEN;

DWORD           MCI_SendCommand(UINT wDevID, UINT16 wMsg, DWORD_PTR dwParam1, DWORD_PTR dwParam2) DECLSPEC_HIDDEN;

const char*     WINMM_ErrorToString(MMRESULT error) DECLSPEC_HIDDEN;

void		TIME_MMTimeStop(void) DECLSPEC_HIDDEN;

MMRESULT WINMM_CheckCallback(DWORD_PTR dwCallback, DWORD fdwOpen, BOOL mixer);

BOOL WINMM_InitWaveform(void);

/* Global variables */
extern CRITICAL_SECTION WINMM_cs DECLSPEC_HIDDEN;
extern HINSTANCE hWinMM32Instance DECLSPEC_HIDDEN;
extern HANDLE psLastEvent DECLSPEC_HIDDEN;
extern HANDLE psStopEvent DECLSPEC_HIDDEN;

/* GetDriverFlags() returned bits is not documented (nor the call itself)
 * Here are Wine only definitions of the bits
 */
#define WINE_GDF_EXIST	        0x80000000
#define WINE_GDF_EXTERNAL_MASK  0xF0000000
#define WINE_GDF_SESSION        0x00000001
