#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gtk

from winswitch.virt.vnc_client_base import VNCClientBase
from winswitch.virt.client_options_base import ClientOptionsBase
from winswitch.virt.options_common import JPEG_QUALITY_OPTION, COMPRESSION

class	VNCClientUtil(VNCClientBase, ClientOptionsBase):

	def	__init__(self, update_session_status, notify_callback):
		VNCClientBase.__init__(self, update_session_status, notify_callback)


	def get_desktop_sizes(self, server_command, command_type, shadowed_session):
		""" override so we always return sizes to choose from as VNC does not do real seamless mode """
		self.sdebug(None, server_command, command_type, shadowed_session)
		if shadowed_session:
			""" but when shadowing, we have no choice! """
			return	None
		return	self.desktop_sizes

	def get_jpeg_widget(self, server_command, options, change_cb=False):
		""" A combo box where users can select jpeg compression	"""
		cb = gtk.combo_box_new_text()
		#find the current value:
		current_jpeg_value = 8
		if options and JPEG_QUALITY_OPTION in options:
			try:
				current_jpeg_value = int(options[JPEG_QUALITY_OPTION])
			except:
				pass
		#populate drop down:
		cb.append_text("Disabled")
		cb.append_text("0 (Low)")
		for i in xrange(8):
			cb.append_text("%s" % (i+1))
		cb.append_text("9 (High)")
		if current_jpeg_value>=0:
			cb.set_active(current_jpeg_value+1)
		if change_cb:
			def jpeg_changed(widget):
				jpgq = widget.get_active()-1
				self.sdebug("jpeg quality=%s" % jpgq, widget)
				change_cb(JPEG_QUALITY_OPTION, jpgq)
			cb.connect("changed", jpeg_changed)
		return cb

	def get_compression_widget(self, server_command, current_options, change_cb=None):
		""" A combo box where users can select compression	"""
		cb = gtk.combo_box_new_text()
		#find the current value:
		current_compression_value = 6
		if current_options and COMPRESSION in current_options:
			try:
				current_compression_value = int(current_options[COMPRESSION])
			except:
				pass
		#populate drop down:
		cb.append_text("0 (Low)")
		for i in xrange(8):
			cb.append_text("%s" % (i+1))
		cb.append_text("9 (High)")
		if current_compression_value>=0:
			cb.set_active(current_compression_value)
		if change_cb:
			def jpeg_changed(widget):
				comp = widget.get_active()
				self.sdebug("compression=%s" % comp, widget)
				change_cb(COMPRESSION, comp)
			cb.connect("changed", jpeg_changed)
		return cb

	def get_options_widgets(self, server, server_command, shadowed_session=None, current_options=None, default_options=None, change_cb=None):
		""" vnc options: clipboard, fullscreen """
		options = self.get_options(current_options, default_options)
		widgets = [
					("JPEG Compression", self.get_jpeg_widget(server_command, options, change_cb)),
					("Compression", self.get_compression_widget(server_command, options, change_cb)),
					("Clipboard Sharing", self.get_clipboard_widget(server, options, change_cb)),
					("Read-only", self.get_readonly_widget(server, options, change_cb)),
					("Display Fullscreen", self.get_fullscreen_widget(server, options, change_cb))
				]
		if default_options is not None:	#not in edit mode
			self.add_timezone_locale_widgets(widgets, self.settings, server, options, change_cb)
			self.add_screen_size_widget(widgets, server, server_command, shadowed_session, options, change_cb)
		return widgets
