// This may look like C code, but it's really -*- C++ -*-
/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#ifndef CHARTS_EXAMPLE_H_
#define CHARTS_EXAMPLE_H_

#include <Wt/WApplication>

#include <iostream>

namespace Wt {
  class WAbstractItemModel;

  namespace Ext {
    class TableView;
  }
}

/**
 * \defgroup chartsexample Charts example
 */
/*@{*/

/*! \brief An application that demonstrates various aspects of the charting lib.
 */
class ChartsExample : public Wt::WApplication
{
public:
  /*! \brief Constructor.
   */
  ChartsExample(const Wt::WEnvironment& env);

private:
  //! Creates the time series scatterplot example
  void timeSeriesExample();

  //! Creates the category chart example
  void categoryExample();

  //! Creates the pie chart example
  void pieExample();

  void scatterPlotExample();

  //! Read the model from a CSV file
  Wt::WAbstractItemModel *readCsvFile(const char *fname);
};

/*@}*/

#endif // CHARTS_EXAMPLE_H_
