import os.path
import SCons.Errors
import SCons.Util
import SCons.Warnings
from BoolOption import BoolOption, True, False
from EnumOption import EnumOption
from ListOption import ListOption
from PackageOption import PackageOption
from PathOption import PathOption
class Options:
    def __init__(self, files=None, args={}):
        self.options=[]
        self.args=args
        self.files=None
        if SCons.Util.is_String(files):
           self.files=[ files ]
        elif files:
           self.files=files
    def _do_add(self, key, help="", default=None, validator=None, converter=None):
        class Option:
            pass
        option=Option()
        option.key=key
        option.help=help
        option.default=default
        option.validator=validator
        option.converter=converter
        self.options.append(option)
    def Add(self, key, help="", default=None, validator=None, converter=None, **kw):
        if SCons.Util.is_List(key) or type(key)==type(()):
            apply(self._do_add, key)
            return
        if not SCons.Util.is_String(key) or \
           not SCons.Util.is_valid_construction_var(key):
            raise SCons.Errors.UserError, "Illegal Options.Add() key `%s'" % str(key)
        if kw.has_key('validater'):
            SCons.Warnings.warn(SCons.Warnings.DeprecatedWarning,
                                "The 'validater' keyword of the Options.Add() method is deprecated\n" +\
                                "and should be changed to 'validator'.")
            if validator is None:
                validator=kw['validater']
        self._do_add(key, help, default, validator, converter)
    def AddOptions(self, *optlist):
        for o in optlist:
            apply(self._do_add, o)
    def Update(self, env, args=None):
        values={}
        for option in self.options:
            if not option.default is None:
                values[option.key]=option.default
        if self.files:
           for filename in self.files:
              if os.path.exists(filename):
                 execfile(filename, values)
        if args is None:
            args=self.args
        values.update(args)
        for option in self.options:
            try:
                env[option.key]=values[option.key]
            except KeyError:
                pass
        for option in self.options:
            if option.converter and values.has_key(option.key):
                value=env.subst('${%s}'%option.key)
                try:
                    env[option.key]=option.converter(value)
                except ValueError, x:
                    raise SCons.Errors.UserError, 'Error converting option: %s\n%s'%(option.key, x)
        for option in self.options:
            if option.validator:
                option.validator(option.key, env.subst('${%s}'%option.key), env)
    def Save(self, filename, env):
        try:
            fh=open(filename, 'w')
            try:
                for option in self.options:
                    try:
                        value=env[option.key]
                        try:
                            eval(repr(value))
                        except KeyboardInterrupt:
                            raise
                        except:
                            value=SCons.Util.to_String(value)
                        if env.subst('${%s}' % option.key) != \
                           env.subst(SCons.Util.to_String(option.default)):
                            fh.write('%s=%s\n' % (option.key, repr(value)))
                    except KeyError:
                        pass
            finally:
                fh.close()
        except IOError, x:
            raise SCons.Errors.UserError, 'Error writing options to file: %s\n%s' % (filename, x)
    def GenerateHelpText(self, env, sort=None):
        help_text=""
        if sort:
            options=self.options[:]
            options.sort(lambda x,y,func=sort: func(x.key,y.key))
        else:
            options=self.options
        for option in options:
            help_text=help_text + '\n%s: %s\n    default: %s\n'%(option.key, option.help, option.default)
            if env.has_key(option.key):
                help_text=help_text + '    actual: %s\n'%env.subst('${%s}'%option.key)
            else:
                help_text=help_text + '    actual: None\n'
        return help_text
