/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _QAPPLICATIONWINDOW_H_
#define _QAPPLICATIONWINDOW_H_

#define CAMBIAR_ESTILOS
#define HAVE_FILE_MENU

#include <qapplication.h>
#include <qmainwindow.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qiconset.h>
#include <qlabel.h>
#include <qmap.h>
#include "QMainWidget.h"
#include "QDiccionarios.h"
#include <QConfig.h>


class QMainWidget;
class QToolBar;
class QPopupMenu;
class QToolButton;
class QLabel;

//class HelpWindow;
class QListBox;

#ifdef HAVE_KDELIBS3
#include <kmainwindow.h>
#include <ktoolbar.h>
#include "misystemtray.h"
#endif


class QApplicationWindow: public QMainWindow
{
	 Q_OBJECT
public:
    QApplicationWindow(QDiccionarios *dictionary_list, bool ismainwindow, 
                       QWidget * parent = 0, const char * name = 0,
                       WFlags f = WType_TopLevel );
    ~QApplicationWindow();

	bool hayError() { return mainwidget->hayError(); };

protected slots:
	void newWindow();
	//void traduce();
	void aprender();
	void cambiaE2I();
	void cambiaI2E();
	void invierteIdioma();
	void cambiaClipboard();
	void cambiaClipboardMenu();
	//void clipProperties();
	void fullWords();
	void caseSensitive();
	void ignorarAcentos();
	void cambiaFormato();
	void cambiaFormato(bool con_formato);
	void changeDict( int id,  bool show_desc );
	void changeDict( int id );
	void changeDict( DiccionarioBase *dict );

	void nuevoDict();
	void editaDict();

	//void editaBrowser();
	void verManual( const QString& url, bool force_external=FALSE );
	void verManual();
	void invokeBrowser( const QString& url ) { verManual(url,TRUE); };
	void cuestionario();

	void activaDialogPreferencias();
	void aplicaPreferencias();

	void activaWizard();

	void acercaDe();
	void showAboutApplication(void); //Para la versin KDE
	void acercaDeQt();
	void salir();

	//Browser
	void avanzar();
	void retroceder();
	void refrescar();
	void textChanged();
//#ifdef MENU_HISTORY //No se pueden quitar ya que el moc genera informacin
	void histChosen( int );
	void clearHistory();
//#endif
	void historyChosen(const QString& enlace);
    void bookmChosen( int );
    void addBookmark();

	void showIntro();
	void showDesc();
	void showGenInfo();
	void showDictInfo();

	void cambiaTitulo(const QString& titulo, const QString& palabra, 
                      const QString& texto, unsigned int numTraducciones);
	void showLink(const QString & enlace);

	//void search_in_all(const QString & enlace);

	void cambiaEstilo( const QString & estilo);
	QString getEstiloActual() { return estilo_actual; }

	void setEfecto(int efecto);
	int getEfecto() { return tipo_efecto; }

	//void cambiaEstilo( int item_id);
	//void cambiaAnimaciones();
	//void cambiaAnimaciones(bool activado);

	void setDocked(bool docked);
	void setDocked();
	//void forceDocked();

	void setAutopopup(bool b);
	void setAutopopup();

	void setAppIconSmall(bool b);
	void cambiaAppIcon();

	void ocultaMenu(bool ocultar);
	void ocultaMenu();

	void ocultaStatusBar(bool ocultar);
	void ocultaStatusBar();

	void ocultaToolbar(bool ocultar);
	void ocultaToolbar();
	void changeSizeToolbar(bool grande);
	void bigToolbar();
	void smallToolbar();
	//void cambiaFuente();


protected:
	virtual void closeEvent(QCloseEvent *);
	virtual void hideEvent(QHideEvent *);
	void initConfig();
	void leeConfig();
	void leeBookmarks();
	void leeToolbars();
	void grabaConfig();
	void grabaBookmarks();
	void grabaToolbars();
	void changeIdioma(bool i2c);
	void setClipboard(bool b);
	void selectDict(QString alias, bool show_desc=FALSE);
	void syncWidgets();

	void grabaEstilo();
	void recuperaEstilo();

	void setStatusText(const QString & texto);

private:
	QMainWidget *mainwidget;

	QDiccionarios *dicts;
	DiccionarioBase *dict;

	QToolBar *tb;
#ifdef SEPARATE_TOOLBAR
	QToolBar *controles;
#endif
	//QToolButton *tbI2E;
	//QToolButton *tbE2I;

	QLabel *tbPixI2E;
	QLabel *tbPixE2I;
	QToolButton *tbInvertir;
	QToolButton *tbAprender;

	QToolButton *tbClip;
	QToolButton *tbAvanzar;
	QToolButton *tbRetroceder;
	QToolButton *tbSalir;

	QPopupMenu *archivo;
	QPopupMenu *translate;
	QPopupMenu *diccionarios;
	QPopupMenu *opciones;
	//QPopupMenu *clipboard;
	QPopupMenu *view;
	QPopupMenu *preferencias;
	//QPopupMenu *oculta_menu;
	//QPopupMenu *toolbar_prefs;
	QPopupMenu *bookm;
	QMap<int, QString> mBookmarks;
#ifdef MENU_HISTORY
	QPopupMenu *hist;
	QMap<int, QString> mHistory;
#endif

	QListBox *lista_historial;

	//QLabel *status;

	//QCadena getAcercaDe();

	QConfig *conf;

	int save_item,print_item;
	int dict1_item,dict2_item;
	int fullwords_item, casesensitive_item;
	int ignoraracentos_item;
	int conformato_item;
	//int raw_item, exact_item, fast_item;
	int i2e_item, e2i_item, learn_item;
	int clip_item;
	int geninfo_item, dictinfo_item;
	//int font_view_item;
	int animaciones_item;
	int docked_item;
	//int tb_hidden_item;
	//int tb_small_item, tb_big_item;
	int small_icon_item;
	//int color_view_item;
	//int menu_hidden_item;
	//int statusbar_hidden_item;

	//QPopupMenu *estilo;
	//int est_windows,est_motif,est_platinum,est_cde;
	//int est_sgi, est_motifplus; //Nuevos estilos qt 2.2.2
#ifdef TEMAS_EXTRA
	//int est_wood,est_metal;
#endif

	QString estilo_actual;
	int tipo_efecto;

	QPixmap icono_idioma1;
	QPixmap icono_idioma2;

	QIconSet iconInv1;
	QIconSet iconInv2;

	QPixmap big_app_icon;
	QPixmap small_app_icon;

	QString web_browser;
	bool use_internal_browser;
	//HelpWindow *help_window;

	QString version_loaded;

	QString old_status_mes;

	bool main_window;

#ifdef HAVE_KDELIBS3
	MiSystemTray *dock;
	int autopopup_item;
	int dock_clip_item;
#endif
	bool auto_popup;

};

#endif
