/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This file is based on the qbrowser example from Qt.
    The license of the modified files are the same as the
    example.
*/

/****************************************************************************
** $Id: main.cpp,v 1.7.2.1 1999/07/13 19:17:57 reggie Exp $
**
** Copyright (C) 1992-1999 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include <qapplication.h>
#include "helpwindow.h"
#include <stdlib.h>
#include "../intern.h"

int main( int argc, char ** argv )
{
	setLocales(); //En intern.h

    QApplication::setColorSpec( QApplication::ManyColor );
    QApplication a(argc, argv);

    QString home;

    if (argc > 1)
        home = argv[1];
    else
        home = QString(getenv("QTDIR")) + "/doc/index.html";

    ( new HelpWindow(home, ".", 0, "qbrowser") )->show();

    QObject::connect( &a, SIGNAL(lastWindowClosed()),
                      &a, SLOT(quit()) );

    return a.exec();
}
