
#ifndef _KDE_INTERFACE_H_
#define _KDE_INTERFACE_H_

#include <dcopobject.h>
#include <qobject.h>
#include <qstring.h>

class QDiccionarios;

class KdeInterface :  public QObject, virtual public DCOPObject
{
	Q_OBJECT
	K_DCOP

public:
	KdeInterface(QDiccionarios *dictionaries, 
                 QObject *parent, const char *name);
	~KdeInterface();

	void setDefaultDictionary(const QString& alias) {
		alias_default_dict = alias;
	}

k_dcop:
	// Searches for word "texto" in dictionary "alias"
	// If rich_text is TRUE then the returned text will have HTML tags
	// Returns the translation string
	virtual QString translation(const QString& texto, const QString& alias,
                                bool rich_text);

	// Searches for word "texto" in dictionary "alias"
	// If rich_text is TRUE then the returned text could have HTML tags
	// Returns only one line of the translation
	virtual QString shortTranslation(const QString& texto, const QString& alias,
                                     bool rich_text);

	// Pops up the wordtrans "miniwindow" displaying the tranlation text.
	// Returns the translation string
	virtual QString showMiniWindow(const QString& texto, 
                                   const QString& alias, bool rich_text);

	// Returns the list the aliases of all available dictionaries
	virtual QStringList getListDictionaries();

	// Returns the alias of the default dictionary (currently the
	// active dictionary when kwordtrans loaded)
	virtual QString defaultDictionary() { return alias_default_dict; }

	// Returns the first language of the dictionary "alias"
	virtual QString language1(const QString& alias);

	// Returns the second language of the dictionary "alias"
	virtual QString language2(const QString& alias);

	// DCOP complained if there weren't this function. I don't know 
	// what's for
	//virtual int newInstance() { return 0; }


protected:
	QDiccionarios *dicts;
	QString alias_default_dict;
};

#endif

