/* text.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: text.cc,v 1.12 2005/05/15 13:47:47 ralf Exp $ */

#include "text.h"
#include "lowlevelfunc.h"
#include "awindow.h"

const char *Text::type="Text";

Text::Text(AGUIX *taguix,int tx,int ty,const char *ttext,int tcolor):GUIElement(taguix)
{
  this->text=dupstring(ttext);
  _x=tx;
  _y=ty;
  _w=taguix->getCharWidth()*strlen(ttext)+1;
  _h=taguix->getCharHeight();
  this->color=tcolor;
  bgset=false;
  font=NULL;
  bg = 0;
  ownbg = false;
}

Text::Text( AGUIX *taguix, int tx, int ty, const char *ttext, int tfg, int tbg ):GUIElement( taguix )
{
  this->text = dupstring( ttext );
  _x = tx;
  _y = ty;
  _w = taguix->getCharWidth() * strlen( ttext ) + 1;
  _h = taguix->getCharHeight();
  this->color = tfg;
  bgset = false;
  font = NULL;
  bg = tbg;
  ownbg = true;
}

Text::~Text()
{
  if(text!=NULL) _freesafe(text);
}

const char *Text::getText() const
{
  return text;
}

void Text::setText(const char *new_text)
{
  if(text!=NULL) _freesafe(text);
  text=dupstring(new_text);
  if(font==NULL) _w=_aguix->getCharWidth()*strlen(text)+1;
  else _w=font->getCharWidth()*strlen(text)+1;
  if ( isCreated() == true ) {
    _parent->resizeSubWin(win,_w,_h);
  }
  redraw();
}

int Text::getColor() const
{
  return color;
}

void Text::setColor(int tcolor)
{
  if((tcolor<(_aguix->getMaxCols()))&&(tcolor>=0)) {
    this->color=tcolor;
    redraw();
  }
}

void Text::redraw()
{
  GC usegc;
  if ( isCreated() == true ) {
    if(font==NULL) usegc=0;
    else usegc=font->getGC();
    if ( bgset == false ) {
      if ( ownbg == true ) {
	_aguix->SetWindowBG( win, bg );
      } else {
	_aguix->SetWindowBG( win, _parent->getBG() );
      }
      bgset = true;
    }
    _aguix->ClearWin(win);
    _aguix->setFG(usegc,color);
    if(font==NULL) _aguix->DrawText(win,text,0,0);
    else _aguix->DrawText(win,font,text,0,0);
  }
}

void Text::flush()
{
}

bool Text::handleMessage(XEvent *E,Message *msg)
{
  if ( isCreated() == false ) return false;
  if((msg->type==Expose)&&(msg->window==win)) {
    redraw();
  }
  return false;
}

int Text::setFont(char *fontname)
{
  font=_aguix->getFont(fontname);
  if(font==NULL) return -1;
  _w=font->getCharWidth()*strlen(text)+1;
  _h=font->getCharHeight();
  if ( isCreated() == true ) {
    _parent->resizeSubWin(win,_w,_h);
  }
  return 0;
}

const char *Text::getType() const
{
  return type;
}

bool Text::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

void Text::setBG( int tcolor )
{
  if ( ( tcolor < ( _aguix->getMaxCols() ) ) && ( tcolor >= 0 ) ) {
    bg = tcolor;
    ownbg = true;
    bgset = false;
    redraw();
  }
}

int Text::getBG() const
{
  return bg;
}

void Text::setFG( int tcolor )
{
  setColor( tcolor );
}

int Text::getFG() const
{
  return color;
}
