/* showimagemode.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: showimagemode.cc,v 1.19 2005/05/15 20:55:58 ralf Exp $ */

#include "showimagemode.h"
#include "normalmode.h"
#include "worker_locale.h"
#include "wconfig.h"
#include "worker.h"
#include "configheader.h"
#include "configparser.tab.h"

const char *defaultviewers[] = { "xliwrapper_worker",
                                "displaywrapper_worker" };

const char *ShowImageMode::type="ShowImageMode";

ShowImageMode::ShowImageMode(Lister *parent):ListerMode(parent)
{
  x=0;
  y=0;
  w=1;
  h=1;
  imgwin=NULL;
  lastactivefe=NULL;
  show_program = dupstring( defaultviewers[0] );
  blanked=false;
}

ShowImageMode::~ShowImageMode()
{
  clearLastActiveFE();
  _freesafe(show_program);
}

void ShowImageMode::messageHandler(AGMessage *msg)
{
  int tx,ty,tw,th;
  bool ma=false;
  switch(msg->type) {
    case AG_SIZECHANGED:
      parentlister->getGeometry(&tx,&ty,&tw,&th);
      reconf(tx,ty,tw,th);
      break;
  }
  if(ma==true) parentlister->makeActive();
}

void ShowImageMode::on()
{
  parentlister->getGeometry(&x,&y,&w,&h);

  if ( w < 10 ) w = 10;
  if ( h < 10 ) h = 10;
  imgwin = new AWindow( aguix, x, y, w, h, 0, "" );
  parentawindow->add( imgwin );
  imgwin->create();
  imgwin->show();
  
  parentlister->setActiveMode(this);
  setName();
}

void ShowImageMode::off()
{
  parentlister->setActiveMode(NULL);
  parentlister->setName("");
  delete imgwin;
  imgwin=NULL;
  clearLastActiveFE();
}

void ShowImageMode::reconf(int tx,int ty,int tw,int th)
{
  if((tw!=w)||(th!=h)||(tx!=x)||(ty!=y)) {
    w=tw;
    h=th;
    if ( w < 10 ) w = 10;
    if ( h < 10 ) h = 10;
    x=tx;
    y=ty;
    imgwin->resize(w,h);
    imgwin->move(x,y);
    update(true);
  }
}

void ShowImageMode::activate()
{
}

void ShowImageMode::deactivate()
{
}

bool ShowImageMode::isType(const char *str)
{
  if(strcmp(str,type)==0) return true; else return false;
}

const char *ShowImageMode::getType()
{
  return type;
}

const char *ShowImageMode::getStaticType()
{
  return type;
}

int ShowImageMode::configure()
{
  Button *okb,*cb,*db;
  AWindow *win;
  StringGadget *sg;
  Text *ttext;
  int tw,ttw,tth,ttx,tty,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  char **liness;
  int lines;
  Requester *req;
  int i;
  
  ttw=tth=10;
  ttx=tty=5;

  tstr = (char*)_allocsafe( strlen( catalog.getLocale( 293 ) ) + strlen( getLocaleName() ) + 1 );
  sprintf( tstr, catalog.getLocale( 293 ), getLocaleName() );
  win = new AWindow( aguix, 10, 10, ttw, tth, 0, tstr );
  win->create();
  _freesafe(tstr);

  lines=createLines(catalog.getLocale(521),&liness);

  for(i=0;i<lines;i++) {
    ttext=(Text*)win->add(new Text(aguix,ttx,tty,liness[i],1));
    tty+=ttext->getHeight()+5;
    tw=ttx+ttext->getWidth()+5;
    if(tw>ttw) ttw=tw;
  }

  sg=(StringGadget*)win->add(new StringGadget(aguix,ttx,tty,ttw-10,show_program,0));
  
  tty+=sg->getHeight()+5;
  db=(Button*)win->add(new Button(aguix,ttx,tty,ttw-10,catalog.getLocale(110),1,0,0));
  tty+=db->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>ttw) ttw=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   tty,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  ttw-5-t2,
                                  tty,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  tty+=okb->getHeight()+5;
  
  tth=tty;
  
  sg->resize(ttw-10,sg->getHeight());
  db->resize(ttw-10,db->getHeight());
  
  win->setDoTabCycling( true );
  win->resize(ttw,tth);
  win->setMaxSize(ttw,tth);
  win->setMinSize(ttw,tth);
  win->show();
  req=new Requester(aguix);
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
            endmode = 0;
          } else if(msg->button.button==cb) endmode=1;
          else if(msg->button.button==db) {
            tstr = requestDefaultViewer();
            if ( tstr != NULL ) {
              sg->setText( tstr );
              _freesafe( tstr );
            }
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  delete req;
  
  if(endmode==0) {
    // ok
    _freesafe(show_program);
    show_program=dupstring(sg->getText());
  }
  
  delete win;

  for(i=0;i<lines;i++) _freesafe(liness[i]);
  _freesafe(liness);

  return endmode;
}

void ShowImageMode::cyclicfunc(cyclicfunc_mode_t mode)
{
  update(false);
}

const char* ShowImageMode::getLocaleName()
{
  return getStaticLocaleName();
}

const char* ShowImageMode::getStaticLocaleName()
{
  return catalog.getLocale(174);
}

int ShowImageMode::load()
{
  if ( worker_token == VIEWSTR_WCP ) {
    readtoken();

    if ( worker_token != '=' ) return 1;
    readtoken();

    if ( worker_token != STRING_WCP ) return 1;
    if ( show_program != NULL ) _freesafe( show_program );
    show_program = dupstring( yylval.strptr );
    readtoken();

    if ( worker_token != ';' ) return 1;
    readtoken();
  } else return 1; //parse error
  return 0;
}

int ShowImageMode::loadBin(Datei *fh)
{
  int chunksize=fh->getInt();
  int is=Datei::getIntSize();
  char *tstr;
  int len;

  if(chunksize>=is) {
    len=fh->getInt();
    chunksize-=is;
    tstr=fh->getString(len);
    chunksize-=len;
    
    // only use the string when not containing a "%s"
    // so it seems like it was written with worker <= 2.6.1
    // and I changed the format
    if ( strstr( tstr, "%s" ) == NULL ) {
      _freesafe(show_program);
      show_program=tstr;
    } else {
      _freesafe( tstr );
    }
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

bool ShowImageMode::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  
  WConfig::configPutPairString( fh, "viewstr", show_program );

  return false;
}

void ShowImageMode::setName()
{
  parentlister->setName(catalog.getLocale(174));
}

void ShowImageMode::reconfig()
{
}

void ShowImageMode::update(bool force)
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  Lister *ol=NULL;
  std::list<NM_specialsourceExt*> *files;
  std::list<NM_specialsourceExt*>::iterator it1;
  List *colors;
  WC_Color *bgcol;
  NM_specialsourceExt *ss1;
  const FileEntry *fe;
  char *buf,*colbuf, *buf2;
  std::string str1;
  
  ol=parentlister->getWorker()->getOtherLister(parentlister);
  if(ol!=NULL) {
    lm1=ol->getActiveMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true)
        nm1=(NormalMode*)lm1;
  }
  
  if(force==true) clearLastActiveFE();
  
  if(nm1!=NULL) {
    files=new std::list<NM_specialsourceExt*>;
    
    nm1->getSelFiles( files, NormalMode::NM_GETFILES_ONLYACTIVE );
    if ( files->begin() != files->end() )
      ss1 = *( files->begin() );
    else
      ss1 = NULL;
    if(ss1!=NULL) {
      fe = ss1->entry();
      if ( fe->equals( lastactivefe ) == false ) {
	clearLastActiveFE();
	if ( fe != NULL ) {
	  lastactivefe = new FileEntry( *fe );
	}
        if(lastactivefe!=NULL) {
          // first get the background color in the X format for xli
          colors=(List*)wconfig->getColors();
          bgcol=(WC_Color*)colors->getElementAt(0);
          colbuf = (char*)_allocsafe( strlen( "rgb://" ) + ( 3 * A_BYTESFORNUMBER( int ) ) + 1 );
          sprintf( colbuf, "rgb:%x/%x/%x", bgcol->getRed(), bgcol->getGreen(), bgcol->getBlue() );
        
          if ( show_program[0] != '/' ) {
            // no absolute path so check if we find
            // the file in the script directory
            str1 = Worker::getDataDir();
            str1 += "/scripts/";
            str1 += show_program;
            if ( Datei::fileExistsExt( str1.c_str() ) != Datei::D_FE_FILE ) {
              // not found so let the shell find it
              str1 = show_program;
            }
          } else {
            str1 = show_program;
          }

          buf = (char*)_allocsafe( strlen( "%s %d %d %d %d %x " ) +
                                   strlen( str1.c_str() ) +
                                   4 * A_BYTESFORNUMBER( int ) + 
                                   A_BYTESFORNUMBER( Window ) + 1 );
          sprintf( buf, "%s %d %d %d %d %x ", str1.c_str(), 0, 0, w, h, (unsigned int)imgwin->getWindow() );
          buf2 = AGUIX_catTrustedAndUnTrusted( buf, lastactivefe->fullname );
          _freesafe( buf );
          buf = catstring( buf2, " " );
          _freesafe( buf2 );
          buf2 = catstring( buf, colbuf );
          _freesafe( buf );
          buf = buf2;
          blank();
          system(buf);
          blanked=false;
          
          _freesafe(buf);
          _freesafe(colbuf);
        }
      }
    } else {
      clearLastActiveFE();
      blank();
    }
    
    for ( it1 = files->begin(); it1 != files->end(); it1++ ) {
      delete *it1;
    }
    
    delete files;
  }
}

void ShowImageMode::blank()
{
  if(blanked==false) {
    XSetWindowAttributes attr;
    attr.background_pixel=aguix->getPixel(0);
    attr.background_pixmap=None;
    XChangeWindowAttributes(aguix->getDisplay(),imgwin->getWindow(),CWBackPixel|CWBackPixmap,&attr);
    XClearWindow(aguix->getDisplay(),imgwin->getWindow());
    aguix->Flush();
  }
  blanked=true;
}

char *ShowImageMode::requestDefaultViewer()
{
  Button *okb,*cb;
  AWindow *win;
  int tw,ttw,tth,ttx,tty;
  AGMessage *msg;
  int endmode=-1;
  GUIElement *bs[2];
  FieldListView *lv;
  unsigned int i;
  int row;
  char *result;
  std::string str1;
  
  ttw = tth = 10;
  ttx = tty = 5;

  win = new AWindow( aguix, 10, 10, ttw, tth, 0, catalog.getLocale( 534 ) );
  win->create();

  win->addTextFromString( catalog.getLocale( 535 ),
                          ttx, tty, 5,
                          NULL, NULL, &tty );
  tty += 5;

  lv = (FieldListView*)win->add( new FieldListView( aguix,
                                                   ttx, tty,
                                                   10, 6 * aguix->getCharHeight(),
                                                   0 ) );
  for ( i = 0; i < ( sizeof( defaultviewers ) / sizeof( defaultviewers[0] ) ); i++ ) {
    row = lv->addRow();
    lv->setText( row, 0, defaultviewers[i] );
    lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    if ( i == 0 ) lv->setActiveRow( row );
  }
  tty += lv->getHeight() + 5;

  lv->setVBarState( 2 );
  lv->setHBarState( 0 );
  lv->setDisplayFocus( true );
  lv->setAcceptFocus( true );
  lv->maximizeX();

  okb = (Button*)win->add( new Button( aguix,
                                       5,
                                       tty,
                                       catalog.getLocale( 11 ),
                                       1,
                                       0,
                                       0 ) );
  cb = (Button*)win->add( new Button( aguix,
                                      5,
                                      tty,
                                      catalog.getLocale( 8 ),
                                      1,
                                      0,
                                      0 ) );
  tty += okb->getHeight() + 5;

  win->maximizeX();
  
  ttw = win->getWidth();
  
  bs[0] = okb;
  bs[1] = cb;
  tw = AGUIX::scaleElementsW( ttw, 5, 5, -1, false, false, bs, NULL, 2 );

  win->resize( ( tw > ttw ) ? tw : ttw, tty );
  lv->resize( win->getWidth() - 2 * win->getBorderWidth(), lv->getHeight() );

  win->setDoTabCycling( true );
  win->setMaxSize( win->getWidth(), win->getHeight() );
  win->setMinSize( win->getWidth(), win->getHeight() );
  win->show();
  
  result = NULL;
  
  for(;endmode == -1;) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) endmode = 1;
          break;
        case AG_BUTTONCLICKED:
          if ( msg->button.button == okb ) endmode = 0;
          else if ( msg->button.button == cb ) endmode = 1;
          break;
      }
      aguix->ReplyMessage( msg );
    }
  }
  
  if ( endmode == 0 ) {
    // ok
    row = lv->getActiveRow();
    if ( lv->isValidRow( row ) == true ) {
      str1 = lv->getText( row, 0 );
      if ( str1.length() > 0 ) {
        result = dupstring( str1.c_str() );
      }
    }
  }
  
  delete win;

  return result;
}

void ShowImageMode::clearLastActiveFE() {
  if ( lastactivefe != NULL ) {
    delete lastactivefe;
    lastactivefe = NULL;
  }
}
