/* startprogop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: startprogop.cc,v 1.30 2005/07/20 21:02:41 ralf Exp $ */

#include "startprogop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include <string>
#include <aguix/kartei.h>
#include <aguix/acontainerbb.h>
#include "execlass.h"
#include "basic_actions.h"

const char *StartProgOp::name="StartProgOp";

StartProgOp::StartProgOp() : FunctionProto()
{
  startprogstart=STARTPROGOP_START_NORMAL;

  view_str = "";
  
  global=false;
  inbackground = false;
  dontcd = false;
  hasConfigure = true;

  gui_msg = catalog.getLocale( 645 );
}

StartProgOp::~StartProgOp()
{
}

StartProgOp*
StartProgOp::duplicate() const
{
  StartProgOp *ta=new StartProgOp();
  ta->startprogstart=startprogstart;

  ta->view_str = view_str;
  ta->global=global;
  ta->inbackground = inbackground;
  ta->dontcd = dontcd;
  return ta;
}

bool
StartProgOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
StartProgOp::getName()
{
  return name;
}

int
StartProgOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister = msg->getWorker()->getOtherLister(startlister);
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodestartprog();
    }
  }
  return 0;
}

bool
StartProgOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  switch(startprogstart) {
    case STARTPROGOP_START_IN_TERMINAL:
      WConfig::configPutPair( fh, "start", "terminal" );
      break;
    case STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY:
      WConfig::configPutPair( fh, "start", "terminalwait" );
      break;
    case STARTPROGOP_SHOW_OUTPUT:
      WConfig::configPutPair( fh, "start", "showoutput" );
      break;
    default:
      WConfig::configPutPair( fh, "start", "normal" );
      break;
  }
  WConfig::configPutPairString( fh, "viewstr", view_str.c_str() );
  WConfig::configPutPairBool( fh, "global", global );
  WConfig::configPutPairBool( fh, "inbackground", inbackground );
  WConfig::configPutPairBool( fh, "dontcd", dontcd );
  return true;
}

const char *
StartProgOp::getDescription()
{
  return catalog.getLocaleCom(32);
}

int
StartProgOp::normalmodestartprog()
{
  NormalMode *nm1 = NULL;
  ListerMode *lm1 = NULL;

  char *tmpname, *tmpoutput, *exestr, *tstr;
  std::string string1;
  bool useint;
  bool removeTMPFiles;

  if ( startlister == NULL ) return 1;
  lm1 = startlister->getActiveMode();
  if ( lm1 == NULL ) return 1;
  if ( lm1->isType( "NormalMode" ) != true ) return 1;
  nm1 = (NormalMode*)lm1;

  std::list<NM_specialsourceExt*> filelist;

  nm1->getSelFiles( &filelist, NormalMode::NM_GETFILES_ONLYACTIVE );

  const FileEntry *tfe;
  if ( am->mode == am->AM_MODE_SPECIAL ) {
    // Copy of FE is not necessary because it's already duplicated in ActionMessage
    tfe = am->getFE();
  } else if ( ( filelist.begin() != filelist.end() ) &&
       ( ( *( filelist.begin() ) )->entry() != NULL ) ) {
    tfe = (*(filelist.begin()))->entry();
  } else {
    tfe = NULL;
  }
  if ( tfe != NULL ) {
    default_file = tfe->name;
  } else {
    default_file = "";
  }

  std::auto_ptr< StartSettings > m1;
  m1 = showGUI();
  if ( m1->_startmode == StartSettings::STARTPROG ) {
    tmpname = Datei::createTMPName();
    tmpoutput = Datei::createTMPName();
    removeTMPFiles = true;
    Datei fp;
    if ( fp.open( tmpname, "w" ) == 0 ) {
      fp.putString( "#! /bin/sh\n" );
      if ( nm1->getCurrentDir() != NULL ) {
	if ( ( worker_islocal( nm1->getCurrentDir() ) == 1 ) &&
	     ( m1->_dontcd == false ) ) {
	  tstr = AGUIX_catTrustedAndUnTrusted( "cd ", nm1->getCurrentDir() );
	  fp.putString( tstr );
	  _freesafe( tstr );
	  fp.putString( "\n" );
	}
      }
      if ( m1->_global == false ) fp.putString( "./" );
      
      string1 = Worker_secureCommandForShell( m1->_command.c_str() );
      if ( string1.length() > 0 ) {
	if ( m1->_start == STARTPROGOP_SHOW_OUTPUT ) {
	  string1 += " >";
	  string1 += tmpoutput;
	}
	fp.putString( string1.c_str() );
	fp.putString( "\n" );
      }
      if ( ( m1->_start == STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY )||
	   ( m1->_start == STARTPROGOP_START_IN_TERMINAL ) ) {
	/* in terminal starten */
	if ( m1->_start == STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY ) {
	  fp.putStringExt( "echo %s\n", catalog.getLocale( 201 ) );
	  fp.putString( "read x\n" );
	}
	exestr = (char*)_allocsafe( strlen( wconfig->getTerminalStr() ) + strlen( tmpname ) + 1 );
	sprintf( exestr, wconfig->getTerminalStr(), tmpname );
      } else {
	exestr = dupstring( tmpname );
      }
      if ( m1->_start == STARTPROGOP_SHOW_OUTPUT ) {
	useint = true;
	if ( m1->_view_str.length() > 2 )
	  if ( strstr( m1->_view_str.c_str(), "%s" ) != NULL ) useint = false;
	if ( useint == true ) fp.putStringExt( OUTPUT_BIN, tmpoutput );
	else fp.putStringExt( m1->_view_str.c_str(), tmpoutput );
	fp.putString( "\n" );
      }
      fp.close();

      if ( fp.errors() == 0 ) {
	worker_chmod( tmpname, 0700 );
	removeTMPFiles = false;
	am->getWorker()->runCommand( exestr, tmpname, tmpoutput, m1->_inbackground );
      } else {
	Requester req( Worker::getAGUIX() );
        char *textstr = (char*)_allocsafe( strlen( catalog.getLocale( 647 ) ) + strlen( tmpname ) + 1 );

        sprintf( textstr, catalog.getLocale( 647 ), tmpname );
	std::string button = catalog.getLocale( 11 );
	req.request( catalog.getLocale( 347 ), textstr, button.c_str() );
        _freesafe( textstr );
      }
      _freesafe( exestr );
    }
    if ( removeTMPFiles == true ) {
      worker_unlink( tmpname );
      worker_unlink( tmpoutput );
    }
    _freesafe( tmpname );
    _freesafe( tmpoutput );
  } else if ( m1->_startmode == StartSettings::HANDLE_TYPE ) {
    WCFiletype *ft = m1->_type;
    if ( ( ft != NULL ) && ( tfe != NULL ) ) {
      List *l = ft->getDoubleClickActions();
      if ( l != NULL ) {
	ActionMessage amsg( am->getWorker() );
	amsg.flags = ft->getDoubleClickActionsGF();
	
	amsg.mode = amsg.AM_MODE_SPECIAL;
	
	amsg.setFE( tfe );
	amsg.filetype = ft;
	amsg.getActionList = DoubleClickAction::getActionList;
	am->getWorker()->interpret( l, &amsg );
      }
    }
  } else if ( m1->_startmode == StartSettings::HANDLE_ARCHIVE ) {
    std::string dir;

    if ( tfe != NULL ) {
      dir = tfe->fullname;
      dir += "#";
      dir += m1->_archive;
      nm1->enterDir( dir.c_str() );
    }
  }
  NormalMode::freeSelFiles( &filelist );
  return 0;
}

int
StartProgOp::configure()
{
  return doconfigure();
}

std::auto_ptr< StartProgOp::SettingsWidgets > StartProgOp::buildW( AWindow *win )
{
  SettingsWidgets *m1;

  AGUIX *aguix = Worker::getAGUIX();
  StringGadget *sg;
  CycleButton *cyb;
  ChooseButton *gcb, *ibcb, *dcdcb;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  
  AContainer *ac1 = win->setContainer( new AContainerBB( win, 1, 6 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 638 ), 1 ), 0, 0, cincwnr );

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );

  ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 331 ), 1 ), 0, 0, cfix );
  cyb = (CycleButton*)ac1_1->add( new CycleButton( aguix, 0, 0, 100, 1, 0, 0 ), 1, 0, cincw );
  cyb->addOption(catalog.getLocale(332));
  cyb->addOption(catalog.getLocale(333));
  cyb->addOption(catalog.getLocale(334));
  cyb->addOption(catalog.getLocale(335));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  switch(startprogstart) {
    case STARTPROGOP_START_IN_TERMINAL:
      cyb->setOption(1);
      break;
    case STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY:
      cyb->setOption(2);
      break;
    case STARTPROGOP_SHOW_OUTPUT:
      cyb->setOption(3);
      break;
    default:
      cyb->setOption(0);
      break;
  }
  ac1_1->readLimits();
  
  AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 2 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( 5 );
  ac1_2->setBorderWidth( 0 );

  ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 337 ), 1 ), 0, 0, cfix );
  sg = (StringGadget*)ac1_2->add( new StringGadget( aguix, 0, 0, 100, view_str.c_str(), 0 ), 1, 0, cincw );

  gcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( global == true ) ? 1 : 0,
						   catalog.getLocale( 343 ), LABEL_RIGHT, 1, 0 ), 0, 3, cincwnr );
  ibcb = (ChooseButton*)ac1->add( new ChooseButton( aguix,
                                                    0,
                                                    0,
                                                    ( inbackground == true ) ? 1 : 0,
                                                    catalog.getLocale( 435 ),
                                                    LABEL_RIGHT,
                                                    1,
                                                    0 ), 0, 4, cincwnr );

  dcdcb = (ChooseButton*)ac1->add( new ChooseButton( aguix,
						     0,
						     0,
						     ( dontcd == true ) ? 1 : 0,
						     catalog.getLocale( 617 ),
						     LABEL_RIGHT,
						     1,
						     0 ), 0, 5, cincwnr );

  win->contMaximize( true );
  win->show();
  
  m1 = new SettingsWidgets( sg, cyb, gcb, ibcb, dcdcb );

  return std::auto_ptr< SettingsWidgets >( m1 );
}

int StartProgOp::doconfigure()
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  int i;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(32))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(32));
  win = new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe(tstr);

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 2 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  AWindow *subwin1 = new AWindow( aguix, 10, 10, 10, 10, 0, "" );
  ac1->add( subwin1, 0, 0, cmin );

  std::auto_ptr< SettingsWidgets > m1 = buildW( subwin1 );
  ac1->readLimits();

  AContainer *ac1_3 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( -1 );
  ac1_3->setBorderWidth( 0 );
  okb =(Button*)ac1_3->add( new Button( aguix,
					0,
					0,
					catalog.getLocale( 11 ),
					1,
					0,
					0 ), 0, 0, cfix );
  cb = (Button*)ac1_3->add( new Button( aguix,
					0,
					0,
					catalog.getLocale( 8 ),
					1,
					0,
					0 ), 1, 0, cfix );

  okb->takeFocus();
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();

  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
	    if ( m1->validate() == 1 ) endmode = 0;
          } else if(msg->button.button==cb) endmode=1;
          break;
	case AG_STRINGGADGET_DEACTIVATE:
          if(msg->stringgadget.sg==m1->_sg) {
	    m1->validate();
          }
	  break;
        case AG_KEYPRESSED:
          if(win->isParent(msg->key.window,false)==true) {
            switch(msg->key.key) {
              case XK_1:
                i=m1->_cyb->getSelectedOption()+1;
                if(i>=4) i=0;
                m1->_cyb->setOption(i);
                break;
              case XK_2:
                m1->_gcb->setState((m1->_gcb->getState()==1)?0:1);
                break;
              case XK_3:
                m1->_ibcb->setState( ( m1->_ibcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_Return:
                if ( cb->getHasFocus() == false ) {
		  if ( m1->validate() == 1 ) endmode = 0;
                }
                break;
              case XK_Escape:
                endmode=1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    view_str = m1->_sg->getText();
    switch(m1->_cyb->getSelectedOption()) {
      case 1:
	startprogstart=STARTPROGOP_START_IN_TERMINAL;
	break;
      case 2:
	startprogstart=STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY;
	break;
      case 3:
	startprogstart=STARTPROGOP_SHOW_OUTPUT;
	break;
      default:
	startprogstart=STARTPROGOP_START_NORMAL;
	break;
    }
    global=(m1->_gcb->getState()==1)?true:false;
    inbackground = ( m1->_ibcb->getState() == 1 ) ? true : false;
    dontcd = ( m1->_dcdcb->getState() == 1 ) ? true : false;
  }
  
  delete win;

  return endmode;
}

void StartProgOp::setStart(startprogstart_t nv)
{
  startprogstart=nv;
}

void StartProgOp::setGlobal(bool nv)
{
  global=nv;
}

void StartProgOp::setRequestFlags(bool nv)
{
}

void StartProgOp::setInBackground( bool nv )
{
  inbackground = nv;
}

void StartProgOp::setDontCD( bool nv )
{
  dontcd = nv;
}

void StartProgOp::setViewStr( std::string nv )
{
  view_str = nv;
}

StartProgOp::SettingsWidgets::SettingsWidgets( StringGadget *sg,
					       CycleButton *cyb,
					       ChooseButton *gcb,
					       ChooseButton *ibcb,
					       ChooseButton *dcdcb ) : _sg( sg ),
								      _cyb( cyb ),
								      _gcb( gcb ),
								      _ibcb( ibcb ),
								      _dcdcb( dcdcb )
{
}

int StartProgOp::SettingsWidgets::validate()
{
  const char *textstr;
  char *buttonstr;
  int erg;
  Requester req( Worker::getAGUIX() );

  if ( NormalMode::isCorrectViewProg( _sg->getText() ) == false ) {
    // show requester
    textstr = catalog.getLocale( 312 );
    buttonstr = (char*)_allocsafe( strlen( catalog.getLocale( 313 ) ) + 1 +
				   strlen( catalog.getLocale( 314 ) ) + 1 );
    sprintf( buttonstr, "%s|%s", catalog.getLocale( 313 ),
	     catalog.getLocale( 314 ) );
    erg = req.request( catalog.getLocale( 125 ), textstr, buttonstr );
    _freesafe( buttonstr );
    if ( erg == 0 ) {
      _sg->activate();
    } else {
      _sg->setText( "" );
    }
  } else return 1;
  return 0;
}

std::auto_ptr< StartProgOp::StartSettings > StartProgOp::showGUI()
{
  AGUIX *aguix = Worker::getAGUIX();
  int w, h, sw;
  AWindow *win;
  int row;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  int i;
  char *tstr;
  int lines;
  char **liness;
  std::string str1;

  win = new AWindow( aguix, 10, 10, 10, 10, 0, catalog.getLocaleCom( 32 ) );
  win->create();

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  
  ac1->add( new Text( aguix, 0, 0, gui_msg.c_str(), 1 ), 0, 0, cincwnr );

  Kartei *k1 = new Kartei( aguix, 10, 10, 10, 10, 0, "" );
  ac1->add( k1, 0, 1, cmin );
  k1->create();

  AWindow *subwin11 = new AWindow( aguix, 0, 0, 10, 10, 0, "" );
  k1->add( subwin11 );
  subwin11->create();
  
  AContainer *acsw11 = subwin11->setContainer( new AContainer( subwin11, 1, 3 ), true );
  acsw11->setMinSpace( 5 );
  acsw11->setMaxSpace( 5 );
  acsw11->setBorderWidth( 5 );

  lines = createLines( catalog.getLocale( 522 ), &liness );

  AContainer *acsw11_t = acsw11->add( new AContainer( subwin11, 1, lines ), 0, 0 );
  acsw11_t->setMinSpace( 5 );
  acsw11_t->setMaxSpace( 5 );
  acsw11_t->setBorderWidth( 0 );

  for ( i = 0; i < lines; i++ ) {
    acsw11_t->add( new Text( aguix, 0, 0, liness[i], 1 ),
		   0, i, cincwnr );
  }
  
  for ( i = 0; i < lines; i++ ) _freesafe( liness[i] );
  _freesafe( liness );

  AContainer *acsw11_1 = acsw11->add( new AContainer( subwin11, 2, 1 ), 0, 1 );
  acsw11_1->setMinSpace( 5 );
  acsw11_1->setMaxSpace( 5 );
  acsw11_1->setBorderWidth( 0 );

  tstr = AGUIX_catQuotedAndUnQuoted( "", default_file.c_str() );

  acsw11_1->add( new Text( aguix, 0, 0, catalog.getLocale( 639 ), 1 ), 0, 0, cfix );
  StringGadget *sg1 = (StringGadget*)acsw11_1->add( new StringGadget( aguix, 0,
								      0, 100, tstr, 0 ), 1, 0, cincw );
  _freesafe( tstr );

  AWindow *subwin11_2 = new AWindow( aguix, 0, 0, 10, 10, 0, "" );
  acsw11->add( subwin11_2, 0, 2, cmin );
  subwin11_2->create();
  std::auto_ptr< SettingsWidgets > m1 = buildW( subwin11_2 );
  acsw11->readLimits();

  AWindow *subwin12 = new AWindow( aguix, 0, 0, 10, 10, 0, "" );
  k1->add( subwin12 );
  subwin12->create();

  std::auto_ptr< FiletypeWindow > ftw = buildFTWindow( subwin12 );

  AWindow *subwin13 = new AWindow( aguix, 0, 0, 10, 10, 0, "" );
  k1->add( subwin13 );
  subwin13->create();

  std::auto_ptr< ArchiveWindow > arcw = buildArcWindow( subwin13 );

  str1 = catalog.getLocale( 641 );
  str1 += " - F1";
  k1->setOption( subwin11, 0, str1.c_str() );
  str1 = catalog.getLocale( 642 );
  str1 += " - F2";
  k1->setOption( subwin12, 1, str1.c_str() );
  str1 = catalog.getLocale( 643 );
  str1 += " - F3";
  k1->setOption( subwin13, 2, str1.c_str() );
  k1->maximize();
  k1->contMaximize();
  ac1->readLimits();

  AContainer *ac1_5 = ac1->add( new AContainer( win, 2, 1 ), 0, 2 );
  ac1_5->setMinSpace( 5 );
  ac1_5->setMaxSpace( -1 );
  ac1_5->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_5->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, cfix );
  Button *cancelb = (Button*)ac1_5->add( new Button( aguix,
                                                     0,
                                                     0,
                                                     catalog.getLocale( 8 ),
                                                     1,
                                                     0,
                                                     0 ), 1, 0, cfix );
  win->setDoTabCycling( true );
  win->contMaximize( true );

  w = win->getWidth();
  h = win->getHeight();

  sw = aguix->getRootWindowWidth();
  sw = (int)( (double)sw * 0.8 );
  if ( sw < 200 ) sw = 200;
  if ( w < sw ) w = sw;
  win->resize( w, h );

  win->show();
  k1->show();

  sg1->takeFocus();

  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch ( msg->type ) {
	case AG_CLOSEWINDOW:
	  if ( msg->closewindow.window == win->getWindow() ) ende = -1;
        case AG_BUTTONCLICKED:
          if ( msg->button.button == okb ) {
	    if ( m1->validate() == 1 ) ende = 1;
          } else if ( msg->button.button== cancelb ) ende = -1;
          break;
	case AG_STRINGGADGET_DEACTIVATE:
          if ( msg->stringgadget.sg == m1->_sg ) {
	    m1->validate();
	  }
	  break;
        case AG_FIELDLV_ONESELECT:
        case AG_FIELDLV_MULTISELECT:
          if ( msg->fieldlv.lv == arcw->_lv ) {
            row = arcw->_lv->getActiveRow();
            if ( arcw->_lv->isValidRow( row ) == true ) {
	      arcw->_sg->setText( arcw->_lv->getText( row, 0 ).c_str() );
            }
          }
          break;
	case AG_STRINGGADGET_OK:
	  if ( msg->stringgadget.sg == sg1 ) {
	    if ( m1->validate() == 1 ) ende = 1;
	  }
	  break;
        case AG_KEYPRESSED:
          if ( win->isParent( msg->key.window, false ) == true ) {
            switch ( msg->key.key ) {
              case XK_1:
                i = m1->_cyb->getSelectedOption() + 1;
                if ( i >= 4 ) i = 0;
                m1->_cyb->setOption( i );
                break;
              case XK_2:
                m1->_gcb->setState( ( m1->_gcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_3:
                m1->_ibcb->setState( ( m1->_ibcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_4:
                m1->_dcdcb->setState( ( m1->_dcdcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_Return:
                if ( cancelb->getHasFocus() == false ) {
		  if ( m1->validate() == 1 ) ende = 1;
                }
                break;
              case XK_Escape:
                ende = -1;
                break;
	      case XK_F1:
		//TODO Was passiert mit Focus, wenn ich per Key die Kartei wechsle?
		k1->optionChange( 0 );
		break;
	      case XK_F2:
		k1->optionChange( 1 );
		break;
	      case XK_F3:
		k1->optionChange( 2 );
		break;
            }
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }

  StartSettings *sets = new StartSettings();

  if ( ende == 1 ) {
    if ( k1->getCurOption() == 0 ) {
      sets->_startmode = StartSettings::STARTPROG;
      sets->_command = sg1->getText();

      sets->_view_str = m1->_sg->getText();
      switch ( m1->_cyb->getSelectedOption() ) {
	case 1:
	  sets->_start = STARTPROGOP_START_IN_TERMINAL;
	  break;
	case 2:
	  sets->_start = STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY;
	  break;
	case 3:
	  sets->_start = STARTPROGOP_SHOW_OUTPUT;
	  break;
	default:
	  sets->_start = STARTPROGOP_START_NORMAL;
	  break;
      }
      sets->_global = ( m1->_gcb->getState() == 1 ) ? true : false;
      sets->_inbackground = ( m1->_ibcb->getState() == 1 ) ? true : false;
      sets->_dontcd = ( m1->_dcdcb->getState() == 1 ) ? true : false;
    } else if ( k1->getCurOption() == 1 ) {
      sets->_startmode = StartSettings::HANDLE_TYPE;

      row = ftw->_lv->getActiveRow();
      if ( ( ftw->_lv->isValidRow( row ) == true ) &&
	   ( row < (int)ftw->_flatlist->size() ) ) {
	WCFiletype *ft = (*ftw->_flatlist)[row].filetype;
	if ( ft != NULL ) {
	  sets->_type = ft;
	}
      }
    } else if ( k1->getCurOption() == 2 ) {
      sets->_startmode = StartSettings::HANDLE_ARCHIVE;
      sets->_archive = arcw->_sg->getText();
    }
  }
  delete win;

  return std::auto_ptr< StartSettings >( sets );
}

StartProgOp::StartSettings::StartSettings() : _startmode( CANCEL ),
					      _type( NULL ),
					      _start( STARTPROGOP_START_NORMAL ),
					      _global( true ),
					      _inbackground( false ),
					      _dontcd( false )
{
}

std::auto_ptr< StartProgOp::FiletypeWindow > StartProgOp::buildFTWindow( AWindow *win )
{
  FiletypeWindow *m1;

  AGUIX *aguix = Worker::getAGUIX();
  FieldListView *lv;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  
  AContainer *ac1 = win->setContainer( new AContainerBB( win, 1, 2 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 644 ), 1 ), 0, 0, cincwnr );

  lv = (FieldListView*)ac1->add( new FieldListView( aguix, 0, 0, 100, 100, 0 ), 0, 1, cmin );
  lv->setHBarState( 2 );
  lv->setVBarState( 2 );
  lv->setDisplayFocus( true );
  lv->setAcceptFocus( true );

  std::vector<FlatTypeList::flattypelist_t> *l1 = wconfig->getFlatTypeList();
  wconfig->buildLVFromFlat( lv, l1, NULL );

  win->contMaximize( true );
  
  m1 = new FiletypeWindow( lv, l1 );

  return std::auto_ptr< FiletypeWindow >( m1 );
}

StartProgOp::FiletypeWindow::FiletypeWindow( FieldListView *lv,
					     std::vector<FlatTypeList::flattypelist_t> *flatlist ) : _lv( lv ),
												     _flatlist( flatlist )
{
}

StartProgOp::FiletypeWindow::~FiletypeWindow()
{
  if ( _flatlist != NULL ) delete _flatlist;
}

std::string find_next_vfs_handler( std::string &searchstr, std::string::size_type &pos )
{
  std::string res = "";
  std::string::size_type pos2;

  pos = searchstr.find_first_of( "0123456789", pos );
  if ( pos != std::string::npos ) {
    pos = searchstr.find_first_of( " \t", pos );
    if ( pos != std::string::npos ) {
      pos = searchstr.find_first_not_of( " \t", pos );
      if ( pos != std::string::npos ) {
	pos2 = searchstr.find( ":", pos );
	if ( pos2 != std::string::npos )
	  res.assign( searchstr, pos, pos2 - pos );
      }
    }
  }
  if ( pos != std::string::npos ) {
    pos = searchstr.find( "\n", pos );
  }
  return res;
}

std::auto_ptr< StartProgOp::ArchiveWindow > StartProgOp::buildArcWindow( AWindow *win )
{
  ArchiveWindow *m1;
  
  AGUIX *aguix = Worker::getAGUIX();
  FieldListView *lv;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  int fd, l, row;
  std::string::size_type pos;
  std::string a1, a2;
  std::vector<std::string> v;
  char buf[128];
  
  AContainer *ac1 = win->setContainer( new AContainerBB( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 640 ), 1 ), 0, 0, cincwnr );

  StringGadget *sg = (StringGadget*)ac1->add( new StringGadget( aguix, 0, 0, 100, "", 0 ), 0, 1, cincw );

  lv = (FieldListView*)ac1->add( new FieldListView( aguix, 0, 0, 100, 100, 0 ), 0, 2, cmin );
  lv->setHBarState( 2 );
  lv->setVBarState( 2 );
  lv->setDisplayFocus( true );
  lv->setAcceptFocus( true );

  a1 = "";
  fd = worker_open( "/#avfsstat/modules", O_RDONLY, 0 );
  if ( fd >= 0 ) {
    for (;;) {
      l = worker_read( fd, buf, sizeof( buf ) );
      if ( l > 0 ) {
	a1.append( buf, l );
      } else break;
    }
    worker_close( fd );
  }

  pos = 0;
  for (;;) {
    a2 = find_next_vfs_handler( a1, pos );
    if ( a2.length() < 1 ) break;
    v.push_back( a2 );
  }
  std::sort( v.begin(), v.end() );

  for ( std::vector<std::string>::iterator it = v.begin(); it != v.end(); it++ ) {
    row = lv->addRow();
    lv->setText( row, 0, *it );
    lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
  }

  win->contMaximize( true );
  m1 = new ArchiveWindow( lv, sg );

  return std::auto_ptr< ArchiveWindow >( m1 );
}

StartProgOp::ArchiveWindow::ArchiveWindow( FieldListView *lv,
					   StringGadget *sg ) : _lv( lv ),
								_sg( sg )
{
}

void StartProgOp::setGUIMsg( std::string msg )
{
  gui_msg = msg;
}
