/* togglelistermodeop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: togglelistermodeop.cc,v 1.13 2005/05/15 20:56:17 ralf Exp $ */

#include "togglelistermodeop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *ToggleListermodeOp::name="ToggleListermodeOp";

ToggleListermodeOp::ToggleListermodeOp() : FunctionProto()
{
  mode=0;
  lastmode=-1;
  hasConfigure = true;
}

ToggleListermodeOp::~ToggleListermodeOp()
{
}

ToggleListermodeOp*
ToggleListermodeOp::duplicate() const
{
  ToggleListermodeOp *ta=new ToggleListermodeOp();
  ta->mode=mode;

  return ta;
}

bool
ToggleListermodeOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
ToggleListermodeOp::getName()
{
  return name;
}

int
ToggleListermodeOp::run(ActionMessage *msg)
{
  int actmode;
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister = msg->getWorker()->getOtherLister(startlister);
      lm1=endlister->getActiveMode();
      if(lm1==NULL) actmode=-1;
      else actmode = msg->getWorker()->getID4Mode(lm1);
      if(actmode<0) {
        endlister->switch2Mode(mode);
      } else {
        if(actmode!=mode) endlister->switch2Mode(mode);
        else if((lastmode>=0)&&(lastmode!=mode)) endlister->switch2Mode(lastmode);
        else endlister->switch2Mode(0);
      }
      lastmode=actmode;
    }
  }
  return 0;
}

bool
ToggleListermodeOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  WConfig::configPutPairString( fh, "mode", Worker::getNameOfMode( mode ) );
  return true;
}

const char *
ToggleListermodeOp::getDescription()
{
  return catalog.getLocaleCom(39);
}

int
ToggleListermodeOp::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *cyb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  int i;
  char *tstr;
  
  w=h=10;
  x=y=5;

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(39))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(39));
  win = new AWindow( aguix, 10, 10, w, h, 0, tstr );
  win->create();
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(112),1));
  y+=ttext->getHeight()+5;
  tw=x+ttext->getWidth()+5;
  if(tw>w) w=tw;

  cyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  for ( i = 0; i < Worker::getMaxModeNr(); i++ ) {
    cyb->addOption( Worker::getLocaleNameOfMode( i ) );
  }
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  cyb->setOption(mode);
  
  y+=cyb->getHeight()+5;
  tw=x+cyb->getWidth()+5;
  if(tw>w) w=tw;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    mode=cyb->getSelectedOption();
  }
  
  delete win;

  return endmode;
}

void ToggleListermodeOp::setMode(int nm)
{
  if ( ( nm >= 0 ) && ( nm < Worker::getMaxModeNr() ) ) {
    mode=nm;
  }
}

