/* dirbookmarkop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "dirbookmarkop.hh"
#include "listermode.h"
#include "normalmode.h"
#include "ownop.h"
#include "bookmarkdb.hh"
#include "bookmarkdbentry.hh"
#include "dirbookmarkui.hh"
#include "dirbookmarkaddui.hh"
#include "nwc_fsentry.hh"
#include "nwc_path.hh"

const char *DirBookmarkOp::name = "DirBookmarkOp";
BookmarkDB *DirBookmarkOp::bookmarks = NULL;
int DirBookmarkOp::bookmarks_count = 0;

DirBookmarkOp::DirBookmarkOp() : FunctionProto()
{
    if ( bookmarks == NULL ) {
        std::string cfgfile = Worker::getWorkerConfigDir();
        cfgfile = NWC::Path::join( cfgfile, "bookmarks" );
        bookmarks = new BookmarkDB( cfgfile );
    }
    bookmarks_count++;
}

DirBookmarkOp::~DirBookmarkOp()
{
    if ( --bookmarks_count == 0 ) {
        delete bookmarks;
        bookmarks = NULL;
    }
}

DirBookmarkOp *DirBookmarkOp::duplicate() const
{
    DirBookmarkOp *ta = new DirBookmarkOp();
    return ta;
}

bool DirBookmarkOp::isName(const char *str)
{
    if ( strcmp( str, name ) == 0 )
        return true;
    else
        return false;
}

const char *DirBookmarkOp::getName()
{
    return name;
}

int DirBookmarkOp::run( WPUContext *wpu, ActionMessage *msg )
{
    Lister *l1;
    ListerMode *lm1;
    NormalMode *nm1;
    
    l1 = msg->getWorker()->getActiveLister();
    if ( l1 == NULL )
        return 1;

    msg->getWorker()->setWaitCursor();

    bookmarks->read();
    DirBookmarkUI ui( *Worker::getAGUIX(), *bookmarks );

    lm1 = l1->getActiveMode();
    if ( lm1 != NULL && lm1->isType( "NormalMode" ) == true ) {
        nm1 = (NormalMode*)lm1;
            
        std::list<NM_specialsourceExt*> sellist;
        nm1->getSelFiles( &sellist, NormalMode::NM_GETFILES_ONLYACTIVE );
            
        std::string dirname, basename;

        if ( nm1->getCurrentDir() != NULL )
            dirname = nm1->getCurrentDir();

        if ( sellist.empty() == false ) {
            if ( (*sellist.begin())->entry() != NULL ) {
                basename = (*sellist.begin())->entry()->name;
            }
        }
        nm1->freeSelFiles( &sellist );
            
        ui.setCurrentDirname( dirname );
        ui.setCurrentBasename( basename );
    }
        
    if ( ui.mainLoop() == 1 ) {
        try {
            BookmarkDBEntry sel_entry = ui.getSelectedEntry();

            std::string dir = sel_entry.getName();
            std::string highlight_entry;
                
            if ( sel_entry.getUseParent() == true ) {
                NWC::FSEntry fse( dir );
                    
                highlight_entry = fse.getBasename();
                dir = fse.getDirname();
            }

            l1->switch2Mode( 0 );
            lm1 = l1->getActiveMode();
            if ( lm1 != NULL && lm1->isType( "NormalMode" ) == true ) {
                nm1 = (NormalMode*)lm1;
                    
                nm1->enterPath( dir );
                if ( highlight_entry.empty() == false ) {
                    nm1->activateEntry( highlight_entry );
                }
            }
        } catch ( int e ) {
        }
    }

    msg->getWorker()->unsetWaitCursor();
    return 0;
}

const char *DirBookmarkOp::getDescription()
{
    return catalog.getLocaleCom( 51 );
}
