/* nmextlist.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NMEXTLIST_HH
#define NMEXTLIST_HH

#include "wdefines.h"
#include "nmexternfe.hh"
#include "functionproto.h"
#include "nmspecialsourceext.hh"

class NMExtList
{
public:
  NMExtList();
  ~NMExtList();
  NMExtList( const NMExtList &other );
  NMExtList &operator=( const NMExtList &other );

  int getSize();
  int getRealSize();
  void setTakeDirs( bool nv);
  int initEnum();
  void closeEnum( int );
  NM_extern_fe *getFirstElement( int id );
  NM_extern_fe *getNextElement( int id );
  int removeElement( NM_extern_fe * );
  void createExtList( class NormalMode *nm, bool rec );
  void createExtList( class NormalMode *nm, ActionMessage *msg, bool rec );
protected:
  List *extlist;
  int files, dirs;
  bool take_dirs;

  int create_externfe_rec( const char *fullname,
                           bool rec,
                           const FileEntry *fe );
  int createExtList( std::list<NM_specialsourceExt*> *splist, bool rec);
  int getEntriesRealSize();
};

#endif
