/* wcglobalflags.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006-2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "wcglobalflags.hh"
#include "datei.h"
#include <aguix/lowlevelfunc.h>
#include "simplelist.hh"
 
WCGlobalFlags::WCGlobalFlags()
{
  flags=0;
}

WCGlobalFlags::~WCGlobalFlags()
{
}

WCGlobalFlags *WCGlobalFlags::duplicate() const
{
  WCGlobalFlags *tf=new WCGlobalFlags();
  tf->setFlags(flags);
  return tf;
}

unsigned long WCGlobalFlags::getFlags() const
{
  return flags;
}

void WCGlobalFlags::setFlags(unsigned long nf)
{
  flags=nf;
}

List* WCGlobalFlags::getNameOfFlags()
{
  List *names=new List();
//  names->addElement(dupstring("All in one shell"));
  return names;
}

void WCGlobalFlags::freeNameOfFlags(List *names)
{
  while(names->size()>0) {
    _freesafe(names->getFirstElement());
    names->removeFirstElement();
  }
  delete names;
}

bool WCGlobalFlags::save(Datei *fh) const
{
  if ( fh == NULL ) return false;
  // I don't use any flags at the moment
  return true;
}
