/* worker.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WORKER_H
#define WORKER_H

#include "wdefines.h"
#include <aguix/lowlevelfunc.h>
#include <aguix/aguix.h>
#include <aguix/util.h>
#include <aguix/message.h>
#include <aguix/button.h>
#include <aguix/solidbutton.h>
#include <aguix/request.h>
#include "functionproto.h"
#include "wconfig.h"
#include "dnd.h"
#include "partspace.h"
#include <aguix/acontainer.h>
#include <string>
#include "generic_callback.hh"

class ListerMode;
class Lister;
class BookmarkDBProxy;
class PopUpMenu;

class Worker
{
public:
  Worker(int argc,char **argv);
  ~Worker();
  Worker( const Worker &other );
  Worker &operator=( const Worker &other );

  void run();
  static AGUIX *getAGUIX();
  static int getMaxModeNr();
  static int getID4Mode(ListerMode*);
  static const char *getNameOfMode( int nr );
  static const char *getLocaleNameOfMode( int nr );
  static int getID4Name( const char *str );
  ListerMode *getMode4ID(int,Lister *);
  AWindow *getMainWin();
  void setStatebarText(const char*);
  void resetStatebarText();
  static int getNrOfCommands();
  FunctionProto *getCommand4ID(int);
  static int getID4Command(FunctionProto*);
  Lister *getOtherLister(Lister*);
  int getSide(Lister*);
  Lister *getLister(int);
  Lister *getActiveLister();
  int interpret(List*,ActionMessage *);
  AWindow *getListerWin( Lister *l );
  
  int quit(int mode);
  void checkfirststart( char **setlang );
  void setTitle(const char *add_infos);
  
  static Requester *getRequester();
  void activateShortkeyFromList();

  int PS_readSpace( const char*name );
  
  loff_t PS_getBlocksize();
  loff_t PS_getFreeSpace();
  loff_t PS_getSpace();
  
  std::string PS_getFreeSpaceH() const;
  std::string PS_getSpaceH() const;
  void PS_setLifetime( double t );
  void showLicense();
  void setWaitCursor();
  void unsetWaitCursor();
  static const std::string getDataDir();
  
  int runCommand( const char *exestr,
		  const char *tmpname,
		  const char *tmpoutput,
		  bool inbackground );

  static std::string getWorkerConfigDir();

  void openWorkerMenu();

  int getStatebarWidth();

  static BookmarkDBProxy &getBookmarkDBInstance();

  void registerPopUpCallback( RefCount<GenericCallbackArg<void, AGMessage*> > cb,
                              const PopUpMenu *menu );
  void unregisterPopUpCallback( RefCount<GenericCallbackArg<void, AGMessage*> > cb );
 protected:
  void createMainWin();
  void setupMainWin();
  void closeMainWin();
  void shufflePath();
  void shuffleButton( int dir );
  void shuffleButton( int dir, bool nocycle );
  void about();
  bool configure();
  void showPathBank();
  void showButtonBank();
  void setPath(int);
  void setPath( WCPath *);
  int activateShortkey(AGMessage*);
  void activateButton(int,int,int);
  int saveListerState();
  int initListerState();
  void updateTime();

  static AGUIX *aguix;
  static int workerInstances;
  Lister *lister[2];
  AWindow *mainwin;
  Button *aboutb,*configureb,*clockbar;
  Button *statebar;
  Button **pathbs;
  Button **buttons;
  AWindow *listerwin[2];
  AContainer *maincont;
  
  int w,h;
  unsigned int curRows,curColumns;
  int pbanknr,bbanknr;
  
  enum {WORKER_NORMAL,WORKER_QUIT};
  int runningmode;
  static int argc;
  static char **argv;
  static std::string startcwd;
  time_t lasttimep;
  
  DNDMsg *dm;

  static Requester *req_static;
  
  static int shortkeysort(void*p1,void*p2);
  struct shortkeylisttype {WCHotkey *h;
                           WCButton *b;
                           WCPath *p;};
  PartSpace *freesp;
  bool isRoot;
  
  KeySym lastkey;
  unsigned int lastmod;
  Time lastkey_time;
  
  typedef struct _keyhash {
    WCButton *b;
    WCHotkey *h;
    WCPath *p;
    struct _keyhash *next;
  } keyhash;
  keyhash **keyhashtable;
  int keyhashtable_size;
  void buildtable();
  void deletetable();
  unsigned int keyhashfunc( KeySym k, unsigned int m );
  void insertkey( KeySym k, unsigned int m, WCButton *b, WCHotkey *h, WCPath *p );
  int findkey( KeySym k, unsigned int m, WCButton **b, WCHotkey **h, WCPath **p );
  int findkey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2, WCButton **b, WCHotkey **h, WCPath **p );
  int waitcursorcount;
  
  int getMaxButtonsWidth();

  bool restart;
  bool configstarted;

  std::string last_statebar_text[2];

  std::string queryLanguage();

  void createWorkerMenu();
  PopUpMenu *m_worker_menu;
  void startMenuAction( AGMessage *msg );
  void saveWorkerState();

  int m_interpret_recursion_depth;
  static const int m_interpret_max_recursion = 1000;

  static std::auto_ptr<BookmarkDBProxy> m_bookmarkproxy;

  std::map<const PopUpMenu *, std::list< RefCount<GenericCallbackArg<void, AGMessage*> > > > m_popup_callbacks;

  void handlePopUps( AGMessage *msg );
};

#endif

