/* listermode.h
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2005,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef LISTERMODE_H
#define LISTERMODE_H

#include "wdefines.h"
#include <aguix/message.h>
#include "generic_callback.hh"
#include <aguix/refcount.hh>
#include "lister.h"
#include <map>

class ArgClass;
class Datei;
class DNDMsg;

class ListerMode
{
public:
  ListerMode(Lister *);
  virtual ~ListerMode();
  ListerMode( const ListerMode &other );
  ListerMode &operator=( const ListerMode &other );

  virtual void messageHandler(AGMessage *);
  virtual void on();
  virtual void off();
  virtual void activate();
  virtual void deactivate();
  virtual bool isType(const char *);
  virtual const char *getType();
  virtual int configure();
  virtual void cyclicfunc(cyclicfunc_mode_t mode);
  virtual const char *getLocaleName();

  virtual int loadBin(Datei*);
  virtual int load();
  virtual bool save(Datei *);
  
  virtual void reconfig();
/*  static ListerMode *preload(Worker*,Datei*,int side);
  static int presave(Datei*,ListerMode*);*/
  
  virtual bool startdnd(DNDMsg *dm);
  virtual bool isyours( Widget *elem );
  virtual void lvbDoubleClicked();

    virtual void runCommand( const std::string &command );
    virtual void runCommand( const std::string &command, const std::list< RefCount< ArgClass > > &args );
    virtual void registerCommand( const std::string &command,
                                  const RefCount< GenericCallback< void > > &callback );
    virtual void registerCommand( const std::string &command,
                                  const RefCount< GenericCallbackArg< void, const std::list< RefCount< ArgClass > > & > > &callback );
protected:
  Lister *parentlister;
  AGUIX *aguix;
  AWindow *parentawindow;
  static const char *type;

private:
    std::map< std::string, RefCount< GenericCallback< void > > > m_commands;
    std::map< std::string, RefCount< GenericCallbackArg< void, const std::list< RefCount< ArgClass > > & > > > m_commands_with_args;
};

#endif

/* Local Variables: */
/* mode:c++ */
/* End: */
