/* wconfig_color.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2006-2008,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wconfig_color.hh"
#include "wconfig.h"
#include "worker.h"
#include "worker_locale.h"
#include <aguix/button.h>
#include <aguix/solidbutton.h>
#include <aguix/bevelbox.h>
#include <aguix/fieldlistview.h>

ColorPanel::ColorPanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
  tempconfig = _baseconfig.duplicate();

  sbsb = NULL;
  sbvb = NULL;
  sbhb = NULL;
  slvbsb = NULL;
  slvbvb = NULL;
  slvbhb = NULL;
  ulvbsb = NULL;
  ulvbvb = NULL;
  ulvbhb = NULL;
  lv = NULL;

  for ( int i = 0; i < 10; i++ ) {
      b[i][0] = NULL;
      b[i][1] = NULL;
  }

  cbsb = NULL;
  cbvb = NULL;
  cbhb = NULL;
  rsb = NULL;
  rvb = NULL;
  rhb = NULL;
  _tv_fg_b = NULL;
  _tv_bg_b = NULL;
  _tv_hfg_b = NULL;
  _tv_hbg_b = NULL;
  _tv_sel_fg_b = NULL;
  _tv_sel_bg_b = NULL;
  _tv_cols_sb = NULL;
  _tv_high_sb = NULL;
  _tv_sel_sb = NULL;
}

ColorPanel::~ColorPanel()
{
  delete tempconfig;
}

int ColorPanel::create()
{
  int res;
  int i;
  int trow;
  int fg,bg;
  
  res = Panel::create();

  AContainer *ac1 = setContainer( new AContainer( this, 1, 13 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  
  addMultiLineText( catalog.getLocale( 672 ),
                    *ac1,
                    0, 0,
                    NULL, NULL );

  AContainer *ac1_1 = ac1->add( new AContainer( this, 3, 1 ), 0, 1 );
  ac1_1->setBorderWidth( 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );

  sbsb = (SolidButton*)ac1_1->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 31 ),
                                                    _baseconfig.getStatusbar( 0 ),
                                                    _baseconfig.getStatusbar( 1 ),
                                                    false ), 0, 0, AContainer::CO_INCW );
  sbvb = (Button*)ac1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                              1, 0, AContainer::CO_FIX );
  sbvb->connect( this );
  sbhb = (Button*)ac1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                              2, 0, AContainer::CO_FIX );
  sbhb->connect( this );

  ac1->add( new BevelBox( _aguix, 0, 0, 10, 2, 0 ), 0, 2, AContainer::CO_INCW );

  AContainer *ac1_2 = ac1->add( new AContainer( this, 3, 1 ), 0, 3 );
  ac1_2->setBorderWidth( 0 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( 5 );

  slvbsb = (SolidButton*)ac1_2->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 34 ),
                                                      _baseconfig.getSelLVB( 0 ),
                                                      _baseconfig.getSelLVB( 1 ), false ),
                                     0, 0, AContainer::CO_INCW );
  slvbvb = (Button*)ac1_2->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                                1, 0, AContainer::CO_FIX );
  slvbvb->connect( this );
  slvbhb = (Button*)ac1_2->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                                2, 0, AContainer::CO_FIX );
  slvbhb->connect( this );

  AContainer *ac1_3 = ac1->add( new AContainer( this, 3, 1 ), 0, 4 );
  ac1_3->setBorderWidth( 0 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( 5 );

  ulvbsb = (SolidButton*)ac1_3->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 35 ),
                                                      _baseconfig.getUnselLVB( 0),
                                                      _baseconfig.getUnselLVB( 1 ), false ),
                                     0, 0, AContainer::CO_INCW );
  ulvbvb = (Button*)ac1_3->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                                1, 0, AContainer::CO_FIX );
  ulvbvb->connect( this );
  ulvbhb = (Button*)ac1_3->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                                2, 0, AContainer::CO_FIX );
  ulvbhb->connect( this );

  ac1->add( new BevelBox( _aguix, 0, 0, 10, 2, 0 ),
                                       0, 5, AContainer::CO_INCW );
  
  AContainer *ac1_4 = ac1->add( new AContainer( this, 2, 1 ), 0, 6 );
  ac1_4->setBorderWidth( 0 );
  ac1_4->setMinSpace( 5 );
  ac1_4->setMaxSpace( 5 );

  lv = (FieldListView*)ac1_4->add( new FieldListView( _aguix, 0, 0, 50, 50, 0 ),
                                   0, 0, AContainer::CO_INCW );
  lv->setHBarState(0);
  lv->setVBarState(0);
  lv->setShowHeader( true );
  lv->setFieldText( 0, catalog.getLocale( 555 ) );
  lv->setHeaderFG( _baseconfig.getLVHeader( 0 ) );
  lv->setHeaderBG( _baseconfig.getLVHeader( 1 ) );

  fg = _baseconfig.getUnselDir( 0 );
  bg = _baseconfig.getUnselDir( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 36 ) );
  setLVColors( trow, fg, bg );

  fg = _baseconfig.getSelDir( 0 );
  bg = _baseconfig.getSelDir( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 37 ) );
  setLVColors( trow, fg, bg );

  fg = _baseconfig.getUnselFile( 0 );
  bg = _baseconfig.getUnselFile( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 38 ) );
  setLVColors( trow, fg, bg );

  fg = _baseconfig.getSelFile( 0 );
  bg = _baseconfig.getSelFile( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 39 ) );
  setLVColors( trow, fg, bg );

  fg = _baseconfig.getUnselDirAct( 0 );
  bg = _baseconfig.getUnselDirAct( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 375 ) );
  setLVColors( trow, fg, bg );

  fg = _baseconfig.getSelDirAct( 0 );
  bg = _baseconfig.getSelDirAct( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 376 ) );
  setLVColors( trow, fg, bg );

  fg = _baseconfig.getUnselFileAct( 0 );
  bg = _baseconfig.getUnselFileAct( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 377 ) );
  setLVColors( trow, fg, bg );

  fg = _baseconfig.getSelFileAct( 0 );
  bg = _baseconfig.getSelFileAct( 1 );
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 378 ) );
  setLVColors( trow, fg, bg );

  fg=1;
  bg = _baseconfig.getListerBG();
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 379 ) );
  setLVColors( trow, fg, bg );
  
  lv->maximizeY();
  lv->maximizeX();
  lv->redraw();
  ac1_4->readLimits();

  AContainer *ac1_4_1 = ac1_4->add( new AContainer( this, 2, 10 ), 1, 0 );
  ac1_4_1->setBorderWidth( 0 );
  ac1_4_1->setMinSpace( 0 );
  ac1_4_1->setMaxSpace( 0 );

  for ( i = 0; i < 8; i++ ) {
    b[i][0] = (Button*)ac1_4_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                                     0, i + 1, AContainer::CO_FIX );
    b[i][0]->resize( b[i][0]->getWidth(), lv->getRowHeight() );
    
    b[i][1] = (Button*)ac1_4_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                                     1, i + 1, AContainer::CO_FIX );
    b[i][1]->resize( b[i][1]->getWidth(), lv->getRowHeight() );
  }

  b[8][0]=NULL;
  b[8][1] = (Button*)ac1_4_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                                   1, 9, AContainer::CO_FIX );
  b[8][1]->resize( b[8][1]->getWidth(), lv->getRowHeight() );

  b[9][0] = (Button*)ac1_4_1->add( new Button( _aguix,
                                               0,
                                               0,
                                               catalog.getLocale( 32 ), 1, 0, 0 ),
                                   0, 0, AContainer::CO_FIX );
  b[9][0]->resize( b[9][0]->getWidth(), lv->getHeaderHeight() );
  b[9][1] = (Button*)ac1_4_1->add( new Button( _aguix,
                                               0,
                                               0,
                                               catalog.getLocale( 33 ), 1, 0, 0 ),
                                   1, 0, AContainer::CO_FIX );
  b[9][1]->resize( b[9][1]->getWidth(), lv->getHeaderHeight() );
  
  ac1_4_1->readLimits();

  for ( int brow = 0; brow < 10; brow++ ) {
    for ( int bcol = 0; bcol < 2; bcol++ ) {
      if ( b[brow][bcol] != NULL )
        b[brow][bcol]->connect( this );
    }
  }

  ac1->add( new BevelBox( _aguix, 0, 0, 10, 2, 0 ),
                                       0, 7, AContainer::CO_INCW );

  AContainer *ac1_5 = ac1->add( new AContainer( this, 3, 1 ), 0, 8 );
  ac1_5->setBorderWidth( 0 );
  ac1_5->setMinSpace( 5 );
  ac1_5->setMaxSpace( 5 );

  cbsb = (SolidButton*)ac1_5->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 43 ),
                                                    _baseconfig.getClockbar( 0 ),
                                                    _baseconfig.getClockbar( 1 ), false ),
                                   0, 0, AContainer::CO_INCW );
  cbvb = (Button*)ac1_5->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                              1, 0, AContainer::CO_FIX );
  cbvb->connect( this );
  cbhb = (Button*)ac1_5->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                              2, 0, AContainer::CO_FIX );
  cbhb->connect( this );

  ac1->add( new BevelBox( _aguix, 0, 0, 10, 2, 0 ), 0, 9, AContainer::CO_INCW );
  
  AContainer *ac1_6 = ac1->add( new AContainer( this, 3, 1 ), 0, 10 );
  ac1_6->setBorderWidth( 0 );
  ac1_6->setMinSpace( 5 );
  ac1_6->setMaxSpace( 5 );

  rsb = (SolidButton*)ac1_6->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 44 ),
                                                   _baseconfig.getRequest( 0 ),
                                                   _baseconfig.getRequest( 1 ), false ),
                                  0, 0, AContainer::CO_INCW );
  rvb = (Button*)ac1_6->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                             1, 0, AContainer::CO_FIX );
  rvb->connect( this );
  rhb = (Button*)ac1_6->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                             2, 0, AContainer::CO_FIX );
  rhb->connect( this );

  /*
   * Code for textview color config
   */

  ac1->add( new BevelBox( _aguix, 0, 0, 10, 2, 0 ), 0, 11, AContainer::CO_INCW );
  
  AContainer *ac1_7 = ac1->add( new AContainer( this, 3, 3 ), 0, 12 );
  ac1_7->setBorderWidth( 0 );
  ac1_7->setMinSpace( 5 );
  ac1_7->setMaxSpace( 5 );

  WConfig::ColorDef current_cols = _baseconfig.getColorDefs();
        
  _tv_cols_sb = (SolidButton*)ac1_7->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 752 ),
                                                           current_cols.getTextViewTextColor(),
                                                           current_cols.getTextViewBackground(), false ),
                                          0, 0, AContainer::CO_INCW );
  _tv_fg_b = (Button*)ac1_7->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                                  1, 0, AContainer::CO_FIX );
  _tv_fg_b->connect( this );
  _tv_bg_b = (Button*)ac1_7->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                                  2, 0, AContainer::CO_FIX );
  _tv_bg_b->connect( this );

  _tv_high_sb = (SolidButton*)ac1_7->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 753 ),
                                                           current_cols.getTextViewHighlightedFG(),
                                                           current_cols.getTextViewHighlightedBG(), false ),
                                          0, 1, AContainer::CO_INCW );
  _tv_hfg_b = (Button*)ac1_7->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                                   1, 1, AContainer::CO_FIX );
  _tv_hfg_b->connect( this );
  _tv_hbg_b = (Button*)ac1_7->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                                   2, 1, AContainer::CO_FIX );
  _tv_hbg_b->connect( this );

  _tv_sel_sb = (SolidButton*)ac1_7->add( new SolidButton( _aguix, 0, 0, catalog.getLocale( 791 ),
                                                          current_cols.getTextViewSelectionFG(),
                                                          current_cols.getTextViewSelectionBG(), false ),
                                         0, 2, AContainer::CO_INCW );
  _tv_sel_fg_b = (Button*)ac1_7->add( new Button( _aguix, 0, 0, catalog.getLocale( 32 ), 1, 0, 0 ),
                                      1, 2, AContainer::CO_FIX );
  _tv_sel_fg_b->connect( this );
  _tv_sel_bg_b = (Button*)ac1_7->add( new Button( _aguix, 0, 0, catalog.getLocale( 33 ), 1, 0, 0 ),
                                      2, 2, AContainer::CO_FIX );
 _tv_sel_bg_b->connect( this );

  contMaximize( true );
  return 0;
}

int ColorPanel::saveValues()
{
  _baseconfig.setStatusbar( 0, tempconfig->getStatusbar(0) );
  _baseconfig.setStatusbar( 1, tempconfig->getStatusbar(1) );
  _baseconfig.setSelLVB( 0, tempconfig->getSelLVB(0) );
  _baseconfig.setSelLVB( 1, tempconfig->getSelLVB(1) );
  _baseconfig.setUnselLVB( 0, tempconfig->getUnselLVB(0) );
  _baseconfig.setUnselLVB( 1, tempconfig->getUnselLVB(1) );
  _baseconfig.setSelDir( 0, tempconfig->getSelDir(0) );
  _baseconfig.setSelDir( 1, tempconfig->getSelDir(1) );
  _baseconfig.setUnselDir( 0, tempconfig->getUnselDir(0) );
  _baseconfig.setUnselDir( 1, tempconfig->getUnselDir(1) );
  _baseconfig.setSelFile( 0, tempconfig->getSelFile(0) );
  _baseconfig.setSelFile( 1, tempconfig->getSelFile(1) );
  _baseconfig.setUnselFile( 0, tempconfig->getUnselFile(0) );
  _baseconfig.setUnselFile( 1, tempconfig->getUnselFile(1) );
  _baseconfig.setSelDirAct( 0, tempconfig->getSelDirAct(0) );
  _baseconfig.setSelDirAct( 1, tempconfig->getSelDirAct(1) );
  _baseconfig.setUnselDirAct( 0, tempconfig->getUnselDirAct(0) );
  _baseconfig.setUnselDirAct( 1, tempconfig->getUnselDirAct(1) );
  _baseconfig.setSelFileAct( 0, tempconfig->getSelFileAct(0) );
  _baseconfig.setSelFileAct( 1, tempconfig->getSelFileAct(1) );
  _baseconfig.setUnselFileAct( 0, tempconfig->getUnselFileAct(0) );
  _baseconfig.setUnselFileAct( 1, tempconfig->getUnselFileAct(1) );
  _baseconfig.setClockbar( 0, tempconfig->getClockbar(0) );
  _baseconfig.setClockbar( 1, tempconfig->getClockbar(1) );
  _baseconfig.setRequest( 0, tempconfig->getRequest(0) );
  _baseconfig.setRequest( 1, tempconfig->getRequest(1) );
  _baseconfig.setLVHeader( 0, tempconfig->getLVHeader( 0 ) );
  _baseconfig.setLVHeader( 1, tempconfig->getLVHeader( 1 ) );
  _baseconfig.setListerBG( tempconfig->getListerBG() );

  WConfig::ColorDef current_cols = _baseconfig.getColorDefs();
  current_cols.setTextViewTextColor( _tv_cols_sb->getFG() );
  current_cols.setTextViewBackground( _tv_cols_sb->getBG() );
  current_cols.setTextViewHighlightedFG( _tv_high_sb->getFG() );
  current_cols.setTextViewHighlightedBG( _tv_high_sb->getBG() );
  current_cols.setTextViewSelectionFG( _tv_sel_sb->getFG() );
  current_cols.setTextViewSelectionBG( _tv_sel_sb->getBG() );
  _baseconfig.setColorDefs( current_cols );
  return 0;
}

WConfigPanel::panel_action_t ColorPanel::setColors( List *colors )
{
  if ( colors != tempconfig->getColors() ) {
    tempconfig->setColors( colors );
  }
  return PANEL_NOACTION;
}

void ColorPanel::run( Widget *elem, AGMessage &msg )
{
  int col;
  
  if(msg.type==AG_BUTTONCLICKED) {
    if(msg.button.button==sbvb) {
      col = tempconfig->palette( tempconfig->getStatusbar( 0 ) );
      if(col>=0) {
        tempconfig->setStatusbar( 0, col );
        sbsb->setFG(col);
      }
    } else if(msg.button.button==sbhb) {
      col=tempconfig->palette( tempconfig->getStatusbar( 1 ) );
      if(col>=0) {
        tempconfig->setStatusbar( 1, col );
        sbsb->setBG(col);
      }
    } else if(msg.button.button==slvbvb) {
      col=tempconfig->palette( tempconfig->getSelLVB( 0 ) );
      if(col>=0) {
        tempconfig->setSelLVB( 0, col );
        slvbsb->setFG(col);
      }
    } else if(msg.button.button==slvbhb) {
      col=tempconfig->palette( tempconfig->getSelLVB( 1 ) );
      if(col>=0) {
        tempconfig->setSelLVB( 1, col );
        slvbsb->setBG(col);
      }
    } else if(msg.button.button==ulvbvb) {
      col=tempconfig->palette( tempconfig->getUnselLVB( 0 ) );
      if(col>=0) {
        tempconfig->setUnselLVB( 0, col );
        ulvbsb->setFG(col);
      }
    } else if(msg.button.button==ulvbhb) {
      col=tempconfig->palette( tempconfig->getUnselLVB( 1 ) );
      if(col>=0) {
        tempconfig->setUnselLVB( 1, col );
        ulvbsb->setBG(col);
      }
    } else if(msg.button.button==cbvb) {
      col=tempconfig->palette( tempconfig->getClockbar( 0 ) );
      if(col>=0) {
        tempconfig->setClockbar( 0, col );
        cbsb->setFG(col);
      }
    } else if(msg.button.button==cbhb) {
      col=tempconfig->palette( tempconfig->getClockbar( 1 ) );
      if(col>=0) {
        tempconfig->setClockbar( 1, col );
        cbsb->setBG(col);
      }
    } else if(msg.button.button==rvb) {
      col=tempconfig->palette( tempconfig->getRequest( 0 ) );
      if(col>=0) {
        tempconfig->setRequest( 0, col );
        rsb->setFG(col);
      }
    } else if(msg.button.button==rhb) {
      col=tempconfig->palette( tempconfig->getRequest( 1 ) );
      if(col>=0) {
        tempconfig->setRequest( 1, col );
        rsb->setBG(col);
      }
    } else if ( msg.button.button == _tv_fg_b ) {
        col = tempconfig->palette( _tv_cols_sb->getFG() );
        if ( col >= 0 ) {
            _tv_cols_sb->setFG( col );
        }
    } else if ( msg.button.button == _tv_bg_b ) {
        col = tempconfig->palette( _tv_cols_sb->getBG() );
        if ( col >= 0 ) {
            _tv_cols_sb->setBG( col );
        }
    } else if ( msg.button.button == _tv_hfg_b ) {
        col = tempconfig->palette( _tv_high_sb->getFG() );
        if ( col >= 0 ) {
            _tv_high_sb->setFG( col );
        }
    } else if ( msg.button.button == _tv_hbg_b ) {
        col = tempconfig->palette( _tv_high_sb->getBG() );
        if ( col >= 0 ) {
            _tv_high_sb->setBG( col );
        }
    } else if ( msg.button.button == _tv_sel_fg_b ) {
        col = tempconfig->palette( _tv_sel_sb->getFG() );
        if ( col >= 0 ) {
            _tv_sel_sb->setFG( col );
        }
    } else if ( msg.button.button == _tv_sel_bg_b ) {
        col = tempconfig->palette( _tv_sel_sb->getBG() );
        if ( col >= 0 ) {
            _tv_sel_sb->setBG( col );
        }
    } else {
      for ( int i = 0; i < 10; i++ ) {
        if(msg.button.button==b[i][0]) {
          switch(i) {
            case 1:
              col=tempconfig->palette( tempconfig->getSelDir( 0 ) );
              if(col>=0) {
                tempconfig->setSelDir(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 2:
              col=tempconfig->palette( tempconfig->getUnselFile( 0 ) );
              if(col>=0) {
                tempconfig->setUnselFile(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 3:
              col=tempconfig->palette( tempconfig->getSelFile( 0 ) );
              if(col>=0) {
                tempconfig->setSelFile(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 4:
              col=tempconfig->palette( tempconfig->getUnselDirAct( 0 ) );
              if(col>=0) {
                tempconfig->setUnselDirAct(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 5:
              col=tempconfig->palette( tempconfig->getSelDirAct( 0 ) );
              if(col>=0) {
                tempconfig->setSelDirAct(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 6:
              col=tempconfig->palette( tempconfig->getUnselFileAct( 0 ) );
              if(col>=0) {
                tempconfig->setUnselFileAct(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 7:
              col=tempconfig->palette( tempconfig->getSelFileAct( 0 ) );
              if(col>=0) {
                tempconfig->setSelFileAct(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 8:
              break;
            case 9:
              col = tempconfig->palette( tempconfig->getLVHeader( 0 ) );
              if ( col >= 0 ) {
                tempconfig->setLVHeader( 0, col );
                lv->setHeaderFG( col );
              }
              break;
            default:
              col=tempconfig->palette( tempconfig->getUnselDir( 0 ) );
              if(col>=0) {
                tempconfig->setUnselDir(0,col);
                lv->setFG( i, FieldListView::CC_NORMAL, col );
                lv->setFG( i, FieldListView::CC_SELECT, col );
                lv->setFG( i, FieldListView::CC_ACTIVE, col );
                lv->setFG( i, FieldListView::CC_SELACT, col );
              }
              break;
          }
        } else if(msg.button.button==b[i][1]) {
          switch(i) {
            case 1:
              col=tempconfig->palette( tempconfig->getSelDir( 1 ) );
              if(col>=0) {
                tempconfig->setSelDir(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 2:
              col=tempconfig->palette( tempconfig->getUnselFile( 1 ) );
              if(col>=0) {
                tempconfig->setUnselFile(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 3:
              col=tempconfig->palette( tempconfig->getSelFile( 1 ) );
              if(col>=0) {
                tempconfig->setSelFile(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 4:
              col=tempconfig->palette( tempconfig->getUnselDirAct( 1 ) );
              if(col>=0) {
                tempconfig->setUnselDirAct(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 5:
              col=tempconfig->palette( tempconfig->getSelDirAct( 1 ) );
              if(col>=0) {
                tempconfig->setSelDirAct(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 6:
              col=tempconfig->palette( tempconfig->getUnselFileAct( 1 ) );
              if(col>=0) {
                tempconfig->setUnselFileAct(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 7:
              col=tempconfig->palette( tempconfig->getSelFileAct( 1 ) );
              if(col>=0) {
                tempconfig->setSelFileAct(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 8:
              col=tempconfig->palette( tempconfig->getListerBG() );
              if(col>=0) {
                tempconfig->setListerBG( col );
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
            case 9:
              col = tempconfig->palette( tempconfig->getLVHeader( 1 ) );
              if ( col >= 0 ) {
                tempconfig->setLVHeader( 1, col );
                lv->setHeaderBG( col );
              }
              break;
            default:
              col=tempconfig->palette( tempconfig->getUnselDir( 1 ) );
              if(col>=0) {
                tempconfig->setUnselDir(1,col);
                lv->setBG( i, FieldListView::CC_NORMAL, col );
                lv->setBG( i, FieldListView::CC_SELECT, col );
                lv->setBG( i, FieldListView::CC_ACTIVE, col );
                lv->setBG( i, FieldListView::CC_SELACT, col );
              }
              break;
          }
        }
      }
      lv->redraw();
    }
  }
}

void ColorPanel::setLVColors( int row, int fg, int bg )
{
  lv->setFG( row, FieldListView::CC_NORMAL, fg );
  lv->setFG( row, FieldListView::CC_SELECT, fg );
  lv->setFG( row, FieldListView::CC_ACTIVE, fg );
  lv->setFG( row, FieldListView::CC_SELACT, fg );
  lv->setBG( row, FieldListView::CC_NORMAL, bg );
  lv->setBG( row, FieldListView::CC_SELECT, bg );
  lv->setBG( row, FieldListView::CC_ACTIVE, bg );
  lv->setBG( row, FieldListView::CC_SELACT, bg );
}
