/* text.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: text.cc,v 1.8 2004/01/22 21:19:50 ralf Exp $ */

#include "text.h"
#include "lowlevelfunc.h"
#include "awindow.h"

const char *Text::type="Text";

Text::Text(AGUIX *taguix):GUIElement(taguix)
{
  text=(char*)_allocsafe(1);
  text[0]='\0';
  color=1;
  bgset=false;
  font=NULL;
}

Text::Text(AGUIX *taguix,int tx,int ty,const char *ttext,int tcolor):GUIElement(taguix)
{
  this->text=dupstring(ttext);
  this->x=tx;
  this->y=ty;
  this->w=taguix->getCharWidth()*strlen(ttext)+1;
  this->h=taguix->getCharHeight();
  this->color=tcolor;
  bgset=false;
  font=NULL;
}

Text::~Text()
{
  if(text!=NULL) _freesafe(text);
}

const char *Text::getText() const
{
  return text;
}

void Text::setText(const char *new_text)
{
  if(text!=NULL) _freesafe(text);
  text=dupstring(new_text);
  if(font==NULL) this->w=aguix->getCharWidth()*strlen(text)+1;
  else this->w=font->getCharWidth()*strlen(text)+1;
  if(parent!=NULL) {
    parent->resizeSubWin(win,w,h);
  }
  redraw();
}

int Text::getColor() const
{
  return color;
}

void Text::setColor(int tcolor)
{
  if((tcolor<(aguix->getMaxCols()))&&(tcolor>=0)) {
    this->color=tcolor;
    redraw();
  }
}

void Text::redraw()
{
  GC usegc;
  if(parent!=NULL) {
    if(font==NULL) usegc=0;
    else usegc=font->getGC();
    if(bgset==false) {
      aguix->SetWindowBG(win,parent->getBG());
      bgset=true;
    }
    aguix->ClearWin(win);
    aguix->setFG(usegc,color);
    if(font==NULL) aguix->DrawText(win,text,0,0);
    else aguix->DrawText(win,font,text,0,0);
  }
}

void Text::flush()
{
}

bool Text::handleMessage(XEvent *E,Message *msg)
{
  if ( parent == NULL ) return false;
  if((msg->type==Expose)&&(msg->window==win)) {
    redraw();
  }
  return false;
}

int Text::setFont(char *fontname)
{
  font=aguix->getFont(fontname);
  if(font==NULL) return -1;
  this->w=font->getCharWidth()*strlen(text)+1;
  this->h=font->getCharHeight();
  if(parent!=NULL) {
    parent->resizeSubWin(win,w,h);
  }
  return 0;
}

const char *Text::getType() const
{
  return type;
}

bool Text::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}
