/* chownop.c
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: chownop.cc,v 1.9 2003/05/04 00:36:43 ralf Exp $ */

#include "chownop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *ChOwnOp::name = "ChOwnOp";

ChOwnOp::ChOwnOp() : FunctionProto()
{
  onfiles = true;
  ondirs = false;
  recursive = false;
  requestflags = true;
  hasConfigure = true;
}

ChOwnOp::~ChOwnOp()
{
}

ChOwnOp*
ChOwnOp::duplicate() const
{
  ChOwnOp *ta = new ChOwnOp();
  ta->onfiles = onfiles;
  ta->ondirs = ondirs;
  ta->recursive = recursive;
  ta->requestflags = requestflags;
  return ta;
}

bool
ChOwnOp::isName( const char *str )
{
  if ( strcmp( str, name ) == 0 ) return true; else return false;
}

const char *
ChOwnOp::getName()
{
  return name;
}

int
ChOwnOp::run( ActionMessage *msg )
{
  ListerMode *lm1;

  am = msg;
  if ( msg->mode != msg->AM_MODE_DNDACTION ) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if ( l1 != NULL ) {
      startlister = l1;
      lm1 = startlister->getActiveMode();
      if ( lm1 != NULL )
        if ( lm1->isType( "NormalMode" ) == true )
          normalmodechown();
    }
  }
  return 0;
}

bool
ChOwnOp::save( Datei *fh )
{
  if ( fh == NULL ) return false;
  WConfig::configPutPairBool( fh, "onfiles", onfiles );
  WConfig::configPutPairBool( fh, "ondirs", ondirs );
  WConfig::configPutPairBool( fh, "recursive", recursive );
  WConfig::configPutPairBool( fh, "requestflags", requestflags );
  return true;
}

const char *
ChOwnOp::getDescription()
{
  return catalog.getLocaleCom( 43 );
}

int
ChOwnOp::normalmodechown()
{
  NormalMode *nm1 = NULL;
  ListerMode *lm1 = NULL;
  struct NM_specialsource *specialsource = NULL;
  bool cont = true;
  struct NM_chownorder coorder;
  
  if ( startlister == NULL ) return 1;
  lm1 = startlister->getActiveMode();
  if ( lm1 == NULL ) return 1;
  if ( lm1->isType( "NormalMode" ) != true ) return 1;
  nm1 = (NormalMode*)lm1;

  if ( requestflags == true ) {
    if ( doconfigure( 1 ) != 0 ) cont = false;
  } else {
    // set values in t* variables
    tonfiles = onfiles;
    tondirs = ondirs;
    trecursive = recursive;
  }
  
  if ( cont == true ) {
    memset( &coorder, 0, sizeof( coorder ) );
    if ( am->mode == am->AM_MODE_ONLYACTIVE )
      coorder.source = coorder.NM_ONLYACTIVE;
    else if ( am->mode == am->AM_MODE_DNDACTION ) {
      // insert DND-element into list
      coorder.source = coorder.NM_SPECIAL;
      coorder.sources = new List;
      specialsource = (struct NM_specialsource*)_allocsafe( sizeof( struct NM_specialsource ) );
      specialsource->entry = NULL;
      specialsource->row = -1;
      //TODO: specialsource nach am besetzen (je nachdem wir ich das realisiere)
      coorder.sources->addElement( specialsource );
    } else if ( am->mode == am->AM_MODE_SPECIAL ) {
      coorder.source = coorder.NM_SPECIAL;
      coorder.sources = new List;
      specialsource = (struct NM_specialsource*)_allocsafe( sizeof( struct NM_specialsource ) );
      specialsource->entry = (FileEntry*)am->extraInfo;
      specialsource->row = -1;
      coorder.sources->addElement( specialsource );
    } else
      coorder.source = coorder.NM_ALLENTRIES;

    coorder.onfiles = tonfiles;
    coorder.ondirs = tondirs;
    coorder.recursive = trecursive;
    nm1->chownf( &coorder );
    if ( coorder.source == coorder.NM_SPECIAL ) {
      if ( specialsource != NULL ) _freesafe( specialsource );
      delete coorder.sources;
    }
  }
  return 0;
}

int
ChOwnOp::configure()
{
  return doconfigure( 0 );
}

int
ChOwnOp::doconfigure( int mode )
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb, *cb;
  AWindow *win;
  ChooseButton *ofcb, *odcb, *rfcb = NULL, *rcb;
  int tw, w, h, x, y;
  AGMessage *msg;
  int endmode = -1;
  char *tstr;
  GUIElement *li[2];
  
  w = h = 10;
  x = y = 5;
  win = new AWindow( aguix );
  tstr = (char*)_allocsafe( strlen( catalog.getLocale( 293 ) ) + strlen( catalog.getLocaleCom( 43 ) ) + 1 );
  sprintf( tstr, catalog.getLocale( 293 ), catalog.getLocaleCom( 43 ) );
  win->create( NULL, 10, 10, w, h, 0, tstr );
  _freesafe( tstr );

  Text *tt1 = (Text*)win->add( new Text( aguix, x, y, catalog.getLocaleCom( 43 ), 1 ) );
  y += tt1->getHeight() + 5;

  ofcb = (ChooseButton*)win->add( new ChooseButton( aguix, x, y, ( onfiles == true ) ? 1 : 0,
                                                    catalog.getLocale( 295 ), LABEL_RIGHT, 1, 0 ) );
  y += ofcb->getHeight() + 5;
  tw = ofcb->getWidth() + 10;
  if ( tw > w ) w = tw;

  odcb = (ChooseButton*)win->add( new ChooseButton( aguix, x, y, ( ondirs == true ) ? 1 : 0,
                                                    catalog.getLocale( 296 ), LABEL_RIGHT, 1, 0 ) );
  y += odcb->getHeight() + 5;
  tw = odcb->getWidth() + 10;
  if ( tw > w ) w = tw;

  rcb = (ChooseButton*)win->add( new ChooseButton( aguix, x, y, ( recursive == true ) ? 1 : 0,
                                                   catalog.getLocale( 297 ), LABEL_RIGHT, 1, 0 ) );
  y += rcb->getHeight() + 5;
  tw = rcb->getWidth() + 10;
  if ( tw > w ) w = tw;

  if ( mode == 0 ) {
    rfcb = (ChooseButton*)win->add( new ChooseButton( aguix, x, y, ( requestflags == true ) ? 1 : 0,
                                                      catalog.getLocale( 294 ), LABEL_RIGHT, 1, 0 ) );
    y += rfcb->getHeight() + 5;
    tw = rfcb->getWidth() + 10;
    if ( tw > w ) w = tw;
  }

  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  5,
                                  y,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  li[0] = okb;
  li[1] = cb;
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, li, NULL, 2 );
  if ( tw > w ) w = tw;
  y += okb->getHeight() + 5;
  
  h = y;
  okb->takeFocus();
  win->setDoTabCycling( true );
  win->resize( w, h );
  win->setMaxSize( w, h );
  win->setMinSize( w, h );
  win->show();
  for( ; endmode == -1; ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) endmode = 1;
          break;
        case AG_BUTTONCLICKED:
          if ( msg->button.button == okb ) endmode = 0;
          else if ( msg->button.button == cb ) endmode = 1;
          break;
        case AG_KEYPRESSED:
          if ( win->isParent( msg->key.window, false ) == true ) {
            switch ( msg->key.key ) {
              case XK_1:
                ofcb->setState( ( ofcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_2:
                odcb->setState( ( odcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_3:
                rcb->setState( ( rcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_Return:
                if ( cb->hasFocus() == false ) {
                  endmode = 0;
                }
                break;
              case XK_Escape:
                endmode = 1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage( msg );
    }
  }
  
  if ( endmode == 0 ) {
    // ok
    if ( mode == 1 ) {
      tonfiles = ( ofcb->getState() == 1 ) ? true : false;
      tondirs = ( odcb->getState() == 1 ) ? true : false;
      trecursive = ( rcb->getState() == 1 ) ? true : false;
    } else {
      onfiles = ( ofcb->getState() == 1 ) ? true : false;
      ondirs = ( odcb->getState() == 1 ) ? true : false;
      recursive = ( rcb->getState() == 1 ) ? true : false;
      requestflags = ( rfcb->getState() == 1 ) ? true : false;
    }
  }
  
  win->close();
  delete win;

  return endmode;
}

void ChOwnOp::setOnFiles( bool nv )
{
  onfiles = nv;
}

void ChOwnOp::setOnDirs( bool nv )
{
  ondirs = nv;
}

void ChOwnOp::setRecursive( bool nv )
{
  recursive = nv;
}

void ChOwnOp::setRequestFlags( bool nv )
{
  requestflags = nv;
}

