/* dndelement.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: dndelement.cc,v 1.11 2004/03/18 06:59:25 ralf Exp $ */

#include "dndelement.h"
#include "aguix.h"
#include "guielement.h"
#include "awindow.h"

DNDElement::DNDElement( AGUIX *parent )
{
  aguix=parent;
  Display *dsp=aguix->getDisplay();
  int scr=aguix->getScreen();
  Visual *vis=DefaultVisual(dsp,scr);
  unsigned long mask=CWEventMask|CWBackPixel|CWOverrideRedirect|CWSaveUnder;
  XSetWindowAttributes attr;
  attr.event_mask=ExposureMask|ButtonPressMask|ButtonReleaseMask|ButtonMotionMask|PointerMotionHintMask|KeyReleaseMask;
  attr.background_pixel=0;
  attr.override_redirect=true;
  attr.save_under=true;

  int xw,yw,xr,yr;
  Window root,child;
  unsigned int keys_button;
  XQueryPointer(dsp,RootWindow(dsp,scr),&root,&child,&xr,&yr,&xw,&yw,&keys_button);

  win=XCreateWindow(dsp,RootWindow(dsp,scr),xr,yr,1,1,0,aguix->getDepth(),InputOutput,vis,mask,&attr);
  XClearWindow(dsp,win);
  XFlush(dsp);

  delx=0;
  dely=0;

  created = false;
}

DNDElement::~DNDElement()
{
  if(grabbed==GrabSuccess) {
    XUngrabPointer(aguix->getDisplay(),CurrentTime);
  }
  close();
}

void DNDElement::handler( Message *msg )
{
  int tx, ty;
  if ( created == false ) {
    create();
  }
  if ( msg->type == MotionNotify ) {
    aguix->queryRootPointer( &tx, &ty );
    XMoveWindow( aguix->getDisplay(), win, delx + tx, dely + ty );
    aguix->Flush();
  } else if ( msg->type == Expose ) {
    if ( msg->window == win ) redraw();
  }
}

void DNDElement::redraw()
{
}

void DNDElement::close()
{
  if(win!=0) XDestroyWindow(aguix->getDisplay(),win);
  win=0;
}

void DNDElement::create()
{
  XMapRaised(aguix->getDisplay(),win);
  grabbed=XGrabPointer(aguix->getDisplay(),
                       RootWindow(aguix->getDisplay(),aguix->getScreen()),
		       True,
		       ButtonMotionMask|ButtonReleaseMask|ButtonPressMask,
		       GrabModeAsync,
		       GrabModeAsync,
		       None,
		       None,
		       CurrentTime);
  created = true;
}
