/* grouphash.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: grouphash.cc,v 1.12 2004/03/18 07:07:33 ralf Exp $ */

#include "grouphash.h"
#include <aguix/lowlevelfunc.h>

GroupHash *ugdb;

GroupHash::GroupHash()
{
  size=1024;
  users=new struct scl*[size];
  groups=new struct scl*[size];
  for(int i=0;i<size;i++) {
    users[i]=NULL;
    groups[i]=NULL;
  }
}

GroupHash::~GroupHash()
{
  struct scl *te,*te2;
  for(int i=0;i<size;i++) {
    te=users[i];
    while(te!=NULL) {
      te2=te->next;
      _freesafe(te->name);
      _freesafe(te);
      te=te2;
    }
    te=groups[i];
    while(te!=NULL) {
      te2=te->next;
      _freesafe(te->name);
      _freesafe(te);
      te=te2;
    }
  }
  delete [] users;
  delete [] groups;
}

char *GroupHash::getUserNameS(uid_t user)
{
  #ifdef DEBUG
//  printf("entering getUserNameS\n");
  #endif
  int entry=hash((int)user);
  if(entry<0) return NULL;
  bool found=false;
  struct scl *te,*te2;
  struct passwd *nus;
  te2=NULL;
  te=users[entry];
  #ifdef DEBUG
//  printf("  step 1\n");
  #endif
  while(te!=NULL) {
    if(te->uid==user) {
      found=true;
      break;
    }
    te2=te;
    te=te->next;
  }
  #ifdef DEBUG
//  printf("  step 2\n");
  #endif
  if(found==false) {
    // neuen Eintrag
    te=(struct scl*)_allocsafe(sizeof(struct scl));
    te->next=NULL;
    te->uid=user;
    nus=getpwuid(user);
    if(nus!=NULL) {
      te->name=dupstring(nus->pw_name);
    } else {
      te->name = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
      sprintf(te->name,"%d",(int)user);
    }
    if(te2==NULL) {
      users[entry]=te;
    } else {
      te2->next=te;
    }
  }
  #ifdef DEBUG
//  printf("leaving getUserNameS\n");
  #endif
  return te->name;
}

char *GroupHash::getUserName(uid_t user)
{
  char *tstr=getUserNameS(user);
  if(tstr==NULL) return NULL;
  return dupstring(tstr);
}

void GroupHash::getUserName(uid_t user,char *buf,int len)
{
  if(len<2) return;
  char *str=getUserNameS(user);
  if(str==NULL) {
    strcpy(buf,"");
  } else {
    strncpy(buf,str,len-1);
    buf[len-1]=0;
  }
}

char *GroupHash::getGroupNameS(gid_t gr)
{
#ifdef DEBUG
//printf("entering getGroupNameS\n");
#endif
  int entry=hash((int)gr);
  if(entry<0) return NULL;
  bool found=false;
  struct scl *te,*te2;
  struct group *ngr;
  te2=NULL;
  te=groups[entry];
  while(te!=NULL) {
    if(te->gid==gr) {
      found=true;
      break;
    }
    te2=te;
    te=te->next;
  }
  if(found==false) {
    // neuen Eintrag
    te=(struct scl*)_allocsafe(sizeof(struct scl));
    te->next=NULL;
    te->gid=gr;
    ngr=getgrgid(gr);
    if(ngr!=NULL) {
      te->name=dupstring(ngr->gr_name);
    } else {
      te->name = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
      sprintf(te->name,"%d",(int)gr);
    }
    if(te2==NULL) {
      groups[entry]=te;
    } else {
      te2->next=te;
    }
  }
#ifdef DEBUG
//printf("leaving getGroupNameS\n");
#endif
  return te->name;
}

char *GroupHash::getGroupName(gid_t gr)
{
  char *tstr=getGroupNameS(gr);
  if(tstr==NULL) return NULL;
  return dupstring(tstr);
}

void GroupHash::getGroupName(gid_t gr,char *buf,int len)
{
  if(len<2) return;
  char *str=getGroupNameS(gr);
  if(str==NULL) {
    strcpy(buf,"");
  } else {
    strncpy(buf,str,len-1);
    buf[len-1]=0;
  }
}

int GroupHash::hash(int id)
{
  //TODO: Nicht gerade die beste Hashfunktione :-(
  int hashcode=abs(id);
  hashcode%=size;
  if((hashcode<0)||(hashcode>=size)) hashcode=0;  // to be sure returning right
                                                  // values
  return hashcode;
}

