/* partspace.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: partspace.h,v 1.11 2004/03/18 20:19:48 ralf Exp $ */

#ifndef PARTSPACE_H
#define PARTSPACE_H

#include "wdefines.h"
#include <aguix/lowlevelfunc.h>
#include <aguix/util.h>

#ifdef WANT_THREADS  
#include <aguix/mutex.h>
#include <aguix/condvar.h>
#endif

class PartSpace
{
public:
  PartSpace();
  ~PartSpace();
  PartSpace( const PartSpace &other );
  PartSpace &operator=( const PartSpace &other );

  int readSpace( const char*name );
  
  loff_t getBlocksize();
  loff_t getFreeSpace();
  loff_t getSpace();
  
  loff_t getFreeSpaceH(char **unit_return);
  loff_t getSpaceH(char **unit_return);

#ifdef WANT_THREADS  
  void slavehandler();
#endif
  
  void setLifetime( double t );
protected:
  loff_t blocksize;
  loff_t freespace;
  loff_t space;
  
  double info_lifetime, info_maxlifetime;
  
#ifdef WANT_THREADS  
  struct {
    int running;
    bool stop;
    pthread_t th;
    
    CondVar waitvar;
  } slave;
#endif
  bool thread_usage;

#ifdef WANT_THREADS  
  class SpaceRequestList
  {
  public:
    typedef struct _space_request_list_t {
      char *name;
#ifdef HAVE_STATVFS
      worker_struct_statvfs fsstatistic;
#elif defined( HAVE_STATFS )
      struct statfs fsstatistic;
#else
      int fsstatistic;
#endif
      int error;
      time_t readtime;
      struct _space_request_list_t *next;
    } space_request_list_t;

    SpaceRequestList();
    ~SpaceRequestList();
    SpaceRequestList( const SpaceRequestList &other );
    SpaceRequestList &operator=( const SpaceRequestList &other );

    bool isEmpty_locked();
    int put_locked( space_request_list_t *elem );
    space_request_list_t *remove_locked();

    void lock();
    void unlock();
    void wait();
    void signal();
  protected:
    CondVar ex;
    space_request_list_t *head, *tail;
    int elements;
  };

  SpaceRequestList *spacerequest;
  SpaceRequestList *spaceanswer;
#endif

#ifdef HAVE_STATVFS
  int getSpace( const char *name, worker_struct_statvfs *statbuf );
#elif defined( HAVE_STATFS )
  int getSpace( const char *name, struct statfs *statbuf );
#else
  int getSpace( const char *name, int *statbuf );
#endif

#ifdef WANT_THREADS  
  List *spaceinfo;
#endif
};

#endif

