/* commandmenuop.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2013,2017 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "commandmenuop.hh"
#include "worker.h"
#include "wpucontext.h"
#include "worker_locale.h"
#include <aguix/aguix.h>
#include <aguix/choosebutton.h>
#include <aguix/button.h>
#include <aguix/acontainer.h>
#include <aguix/awindow.h>

const char *CommandMenuOp::name = "CommandMenuOp";

CommandMenuOp::CommandMenuOp() : FunctionProto(),
                                 m_show_recently_used( false )
{
    m_category = FunctionProto::CAT_OTHER;
    hasConfigure = true;
}

CommandMenuOp::~CommandMenuOp()
{
}

CommandMenuOp* CommandMenuOp::duplicate() const
{
    CommandMenuOp *ta = new CommandMenuOp();
    ta->m_show_recently_used = m_show_recently_used;
    return ta;
}

bool CommandMenuOp::isName( const char *str )
{
    if ( strcmp( str, name ) == 0 ) return true; else return false;
}

const char *CommandMenuOp::getName()
{
    return name;
}

int CommandMenuOp::run( WPUContext *wpu, ActionMessage *msg )
{
    msg->getWorker()->openCommandMenu( m_show_recently_used );

    return 0;
}

const char *CommandMenuOp::getDescription()
{
    return catalog.getLocaleCom( 62 );
}

int CommandMenuOp::configure()
{
    AGUIX *aguix = Worker::getAGUIX();
    AWindow *win;
    AGMessage *msg;
    int endmode=-1;
    char *tstr;
  
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 293 ) ) + strlen( getDescription() ) + 1 );
    sprintf( tstr, catalog.getLocale( 293 ), getDescription() );
    win = new AWindow( aguix, 10, 10, 10, 10, tstr, AWindow::AWINDOW_DIALOG );
    win->create();
    _freesafe( tstr );

    AContainer *ac1 = win->setContainer( new AContainer( win, 1, 2 ), true );
    ac1->setMinSpace( 5 );
    ac1->setMaxSpace( 5 );

    ChooseButton *recently_cb = ac1->addWidget( new ChooseButton( aguix, 0, 0,
                                                                  m_show_recently_used,
                                                                  catalog.getLocale( 1169 ),
                                                                  LABEL_LEFT, 0 ),
                                                0, 0, AContainer::CO_INCWNR );

    AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
    ac1_2->setMinSpace( 5 );
    ac1_2->setMaxSpace( -1 );
    ac1_2->setBorderWidth( 0 );
    Button *okb =(Button*)ac1_2->add( new Button( aguix,
                                                  0,
                                                  0,
                                                  catalog.getLocale( 11 ),
                                                  0 ), 0, 0, AContainer::CO_FIX );
    Button *cb = (Button*)ac1_2->add( new Button( aguix,
                                                  0,
                                                  0,
                                                  catalog.getLocale( 8 ),
                                                  0 ), 1, 0, AContainer::CO_FIX );
  
    win->setDoTabCycling( true );
    win->contMaximize( true );
    win->show();

    for ( ; endmode == -1; ) {
        msg = aguix->WaitMessage( win );
        if ( msg != NULL ) {
            switch ( msg->type ) {
                case AG_CLOSEWINDOW:
                    if ( msg->closewindow.window == win->getWindow() ) endmode = 1;
                    break;
                case AG_BUTTONCLICKED:
                    if ( msg->button.button == okb ) endmode = 0;
                    else if ( msg->button.button == cb ) endmode = 1;
                    break;
            }
            aguix->ReplyMessage( msg );
        }
    }
  
    if ( endmode == 0 ) {
        // ok
        if ( recently_cb->getState() ) {
            m_show_recently_used = true;
        } else {
            m_show_recently_used = false;
        }
    }
  
    delete win;

    return endmode;
}

bool CommandMenuOp::save( Datei *fh )
{
    if ( fh == NULL ) return false;

    if ( m_show_recently_used ) {
        fh->configPutPairBool( "showrecent", m_show_recently_used );
    }

    return true;
}

void CommandMenuOp::setShowRecentlyUsed( bool nv )
{
    m_show_recently_used = nv;
}
