/* persdeeppathstore.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2012-2015 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PERSDEEPPATHSTORE_HH
#define PERSDEEPPATHSTORE_HH

#include "wdefines.h"
#include "deeppathstore.hh"
#include <list>
#include <string>
#include <thread>
#include <aguix/condvar.h>

class PersDeepPathStore
{
public:
    PersDeepPathStore( const std::string &filename );
    ~PersDeepPathStore();

    void storePath( const std::string &path, time_t ts );
    std::list< std::pair< std::string, time_t > > getPaths();

    void relocateEntries( const std::string &dest,
                          const std::string &source,
                          time_t ts,
                          bool move );

    void removeEntry( const std::string &path );
private:
    DeepPathStore m_store;
    std::string m_filename;
    time_t m_lastmod;
    loff_t m_lastsize;

    struct bg_threading {
        bg_threading() : current_result_id( 0 ),
                         wanted_result_id( 0 ),
                         stop_thread( false )
        {}

        std::thread thread_id;
        CondVar order_cv;
        CondVar result_cv;

        int current_result_id;
        int wanted_result_id;

        std::list< std::pair< std::string, time_t > > result_list;
        std::list< std::pair< std::string, time_t > > push_list;
        std::list< std::tuple< std::string, std::string, time_t, bool > > relocate_list;
        std::list< std::string > remove_list;
        bool stop_thread;
    } m_bg_threading;

    void read();
    void write();

    void bg_thread();

    void addPaths( const std::list< std::pair< std::string, time_t > > &list );

    void processRelocateOrders( const std::list< std::tuple< std::string, std::string, time_t, bool > > &relocate_list );

    void removeEntries( const std::list< std::string > &paths );
};

#endif
