// $Id: TerrainView.h,v 1.13 2001/10/29 23:08:48 nekeme Exp $
#ifndef WE_TERRAINVIEW_H
#define WE_TERRAINVIEW_H

#include "Ark/ArkRenderer.h"
#include "ViewWidget.h"

// Forward declarations
class World;
class Tool;


class TerrainView
{
  protected:
      Ark::Vector3 m_ViewPos;
      scalar m_FOV;
      scalar m_AngleY;
      scalar m_Pitch;
      scalar m_Distance;
      
      World* m_World;
      ViewWidget* m_View;

      Tool* m_Tool;
      
      Ark::Camera m_Camera;

      void ComputeView();

   public:
      TerrainView();
      virtual ~TerrainView();
      
      virtual bool Render();
      void Center();

      // Tools operations, may change too
      void SetTool(Tool* tool);
      void UpdateTool();
      
      // World Operations
      World* GetWorld() const { return m_World; }
      void SetWorld(World* world) { m_World = world; }

      // View Operations
      void Update();
      ViewWidget* GetView() const { return m_View; }
      void SetView(ViewWidget* view) { m_View = view; }

      // Get current renderer
      inline Ark::Renderer* GetRenderer() const { return m_View->GetRenderer(); }

      // FIXME Renderers should take CONST cameras !
      Ark::Camera* GetCamera() const { return (Ark::Camera*)&m_Camera; }

      /// UI changes
      
      // Drag position (pan to newpos)
      void Drag(scalar, scalar);

      // Zoom (distance += zoom)
      void Zoom(scalar zoom);

      // Rotate around Y axis
      void Rotate(scalar angle);

      // Change pitch (slope)
      void Pitch(scalar angle);
      
      // Action on heightfield at (X, whatever, Z)
      void Change(Ark::Vector3 newpos, const Ark::Collision &col);
};

#endif
