// $Id: CallbacksGroundOperations.cpp,v 1.10 2002/10/14 05:14:41 mrq Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string>
#include <iostream>

#include <gtk/gtk.h>

#include "support.h"
#include "interface.h"

#include <Ark/ArkMaterial.h>
#include <Ark/ArkFileSys.h>

#include "../Main.h"
#include "../Application.h"
#include "../HFChangeGround.h"

#include "CallbacksGround.h"
#include "UIGtk.h"

// Default directory for brushes
static const char GroundDialogDirectory[] = "{shaders}/";
  
// Open a file dialog
void AddGroundBrushDialog()
{
  GtkWidget* dialog = create_AddGroundDialog();
  assert(dialog);

  gtk_file_selection_set_filename( GTK_FILE_SELECTION(dialog), 
      Ark::Sys()->FS()->GetFileName(GroundDialogDirectory).c_str());

  // Shows dialog
  gtk_widget_show_all(dialog);
}

// Read a ground file to memory
bool AddGroundFile(const char* name)
{
  if (name)
  {
    return g_Application->GetWorld()->LoadGround(name); 
  }

  return false;
}

static void AddOneGroundToList(GtkCList* list, const Ark::Material* mat)
{
  // FIXME non const char for CLists sucks
  const char* name = mat->m_DecorName.c_str();
  gchar *columns[] = { (char*)name };

  gtk_clist_append(list, columns);
}

// Add a ground to the list of brushes
void AddGroundToList(Ark::Material* mat)
{
  GtkWidget* widget = lookup_widget( GTK_WIDGET(g_MainWindow), "BrushList");
  GtkCList* list = GTK_CLIST( widget );
  AddOneGroundToList(list, mat);
}

// Set the ground list to the list given
void AddGroundsToList(const Ark::MaterialList& mats)
{
  GtkWidget* widget = lookup_widget( GTK_WIDGET(g_MainWindow), "BrushList");
  GtkCList* list = GTK_CLIST( widget );

  gtk_clist_freeze(list);
  gtk_clist_clear(list);

  // FIXME use for_each algorithm
  for (Ark::MaterialList::const_iterator i = mats.begin() ;
        i != mats.end() ; 
        ++i)
  {
    AddOneGroundToList(list, i->Get());
  }
  
  gtk_clist_thaw(list);
}


static void CreateAndSetNewTool()
{
  Application* a = Application::GetApplication();

  // Passed an height field of 0, the Application should deal with it
  a->SetTool( HFChangeGround::CreateNewTool(0) );
}

// Ground tool has been chosen
void UpdateGround()
{
  CreateAndSetNewTool();
}
  
// Ground size has been changed
void UpdateGroundSize(int size)
{
  HFChangeGround::s_CurrentGround.m_BrushSize = size;
  CreateAndSetNewTool();
}
  
// Ground Brush Type has been changed
void UpdateGroundType(int type)
{
  // do something
  // CreateAndSetNewTool();
}
  
// A ground has been selected for painting
void SelectGround(int ground)
{
  HFChangeGround::s_CurrentGround.m_GroundType = ground;
  CreateAndSetNewTool();
}
  
