// $Id: ClassSelector.cpp,v 1.3 2002/10/08 09:12:56 zongo Exp $
#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "../Application.h"
#include "ClassSelector.h"


extern void widget_setResult (GtkWidget *widget, int val);

void ClassTree_setClass (GtkWidget *widget, char *val)
{
   GtkWidget *root = lookup_widget (widget, "ClassSelectorWindow");
   
   char **rclassname = 
      (char**) gtk_object_get_data (GTK_OBJECT(root), "classname");
   
   if (rclassname != NULL)
      *rclassname = val;
}

void
on_ClassSelectorTree_selection_changed (GtkTree         *tree,
                                        gpointer         user_data)
{
      GList *select = GTK_TREE_SELECTION(tree);

      if (!select)
      {
	 ClassTree_setClass (GTK_WIDGET(tree), NULL);
	 return;
      }

      GtkObject *iselect = GTK_OBJECT(select->data);

      ClassTree_setClass (GTK_WIDGET(tree),
			  (char*) gtk_object_get_data
			  (iselect, "classname"));

}

void
on_ClassSelectorOkButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
   widget_setResult (GTK_WIDGET(button), RES_OK);
}

void
on_ClassSelectorCancelButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
   widget_setResult (GTK_WIDGET(button), RES_CANCEL);
}


////////////////////////////////////////////////////////////////////////////
void TemplateSelector_setResult (GtkWidget *widget, int val)
{
   GtkWidget *root = lookup_widget (widget, "TemplateSelectorWindow");
   
   int *res = (int*) gtk_object_get_data (GTK_OBJECT(root), "result");
   
   if (res != NULL)
      *res = val;
}

void TemplateSelector_setTemplate (GtkWidget *widget, char *val)
{
   GtkWidget *root = lookup_widget (widget, "TemplateSelectorWindow");
   char **rtemplate = 
      (char**) gtk_object_get_data (GTK_OBJECT(root), "template");
   
   if (rtemplate != NULL)
      *rtemplate = val;
}



void
on_TemplateSelectorList_selection_changed
                                        (GtkList         *list,
                                        gpointer         user_data)
{
      GList *select = list->selection;
      
      if (!select)
      {
	 TemplateSelector_setTemplate (GTK_WIDGET(list), NULL);
	 return;
      }

      GtkObject *iselect = GTK_OBJECT(select->data);

      TemplateSelector_setTemplate (GTK_WIDGET(list),
			      (char*) gtk_object_get_data
			      (iselect, "template"));

}


void
on_TemplateSelectorOkButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
   widget_setResult (GTK_WIDGET(button), RES_OK);
}


void
on_TemplateSelectorCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
   widget_setResult (GTK_WIDGET(button), RES_CANCEL);
}


gboolean
on_ClassSelectorWindow_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}

gboolean
on_TemplateSelectorWindow_delete_event (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}

//////////////////////////////////////////////////////////////////////////

ClassList::ClassList ()
{
   m_CList = NULL;
}


void
ClassList::buildTree (Ark::ClassDef *parentclass,
		       GtkWidget *tree)
{
   std::vector<Ark::ClassDef>::iterator it;
   GtkWidget *item_subtree = NULL;
   GtkWidget *item_new = NULL;

   if (GTK_IS_TREE (tree))
      item_subtree = tree;

   for (it = m_CList->m_Classes.begin(); it != m_CList->m_Classes.end(); it++)
   {
      if (it->m_Parent == parentclass)
      {
	 if (item_subtree == NULL)
	 {
	    item_subtree = gtk_tree_new();
	    gtk_tree_item_set_subtree(GTK_TREE_ITEM(tree),item_subtree);
	 }

	 item_new = gtk_tree_item_new_with_label(it->m_Name.c_str());
	 gtk_widget_ref(item_new);

	 gtk_object_set_data(GTK_OBJECT(item_new),"classname",
			     const_cast<char*>(it->m_Name.c_str()));
 
	 gtk_tree_append(GTK_TREE(item_subtree),item_new);
	 gtk_widget_show(item_new);

	 Ark::ClassDef& item = *it;
	 buildTree (&item, item_new);
      }
   }
}

Ark::ClassDef *
ClassList::SelectClass ()
{
   GtkWidget *wClassSelector = create_ClassSelectorWindow ();
   m_CList = g_Application->GetClasses();

   char *classname;
   int result = RES_NONE;

   gtk_object_set_data(GTK_OBJECT(wClassSelector), "classname", &classname);
   gtk_object_set_data(GTK_OBJECT(wClassSelector), "result", &result);

   gtk_widget_show (wClassSelector);

   GtkWidget *tree = lookup_widget (wClassSelector, "ClassTree");
   buildTree (NULL, tree);

   while (result == RES_NONE)
      gtk_main_iteration();

   gtk_widget_destroy (wClassSelector);

   if (result == RES_OK && classname != NULL)
      return m_CList->Find (classname);
   else
      return NULL;
}

////////////////////////////////////////////////////////////////////////////

void
ClassList::buildList (Ark::ClassDef *templateclass,
		       GtkWidget *list)
{
   std::map<Ark::String,Ark::EntryList>::iterator it;

   for (it = m_CList->m_Templates.begin();
	it != m_CList->m_Templates.end(); it++)
   {
      if (templateclass == NULL ||
	  (*it->second["class"].d_str == templateclass->m_Name))
      {
	 GtkWidget *item = gtk_list_item_new_with_label (it->first.c_str());

	 gtk_object_set_data(GTK_OBJECT(item),"template",
			     (char*)it->first.c_str());
	 gtk_widget_show (item);
	 gtk_container_add (GTK_CONTAINER(list), item);
      }
   }

   if (templateclass && templateclass->m_Parent)
      buildList (templateclass->m_Parent, list);
}

Ark::String 
ClassList::SelectTemplate (Ark::ClassDef *def)
{
   m_CList = g_Application->GetClasses();

   GtkWidget *wTmplSelector = create_TemplateSelectorWindow ();

   char *rtemplate;
   int result = RES_NONE;

   gtk_object_set_data(GTK_OBJECT(wTmplSelector), "template", &rtemplate);
   gtk_object_set_data(GTK_OBJECT(wTmplSelector), "result", &result);

   gtk_widget_show (wTmplSelector);

   GtkWidget *list = lookup_widget (wTmplSelector, "TemplateSelectorList");
   buildList (def, list);

   while (result == RES_NONE)
      gtk_main_iteration();

   // This is just to avoid a warning...
   gtk_signal_disconnect_by_func (GTK_OBJECT(list),
				  GTK_SIGNAL_FUNC
				  (on_TemplateSelectorList_selection_changed),
				  NULL);
   gtk_widget_destroy (wTmplSelector);

   if (result == RES_OK && rtemplate != NULL)
      return rtemplate;
   else
      return "";
}

Ark::EntryList&
ClassList::GetTemplate (const Ark::String &name)
{
   return m_CList->m_Templates[name];
}


ClassList g_EntityClasses;
