/******************************************************************************
 *  Wormux, a free clone of the game Worms from Team17.
 *  Copyright (C) 2001-2004 Lawrence Azzoug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ******************************************************************************
 * Messages s'affichant en haut de l'ecran (et crit dans la console).
 *****************************************************************************/

#ifndef GAME_MESSAGES_H
#define GAME_MESSAGES_H
//-----------------------------------------------------------------------------
#include "../include/base.h"
#include "../graphic/text.h"
#include <string>
#include <list>
//-----------------------------------------------------------------------------

class GameMessages
{
public:
  typedef struct message_t
  {
    Text * text;
    uint time;
    message_t (Text * t, Text * t2, uint _time) { text = t; time = _time; }
  } message_t;
  std::list<message_t> liste;
  typedef std::list<message_t>::iterator iterator;

 private:
  static GameMessages * singleton;

 public:
  static GameMessages * GetInstance();

  // Remise a zro
  void Reset();
  
  // Affiche tous les messages
  void Draw();

  // Actualisation : Supprime les anciens messages
  void Refresh();

  // Ajoute un message
  // [titre] message
  void Add(const std::string &message);

 private:
  GameMessages();
};

//-----------------------------------------------------------------------------
#endif
