/* Style: A base class from which all other styles are inherited, includes
 * a name.
 *
 * Copyright (C) 2002-2003 William Lachance (william.lachance@sympatico.ca)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 *
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _STYLE_H
#define _STYLE_H
#include <libwpd/libwpd.h>
#include <gsf/gsf-utils.h>
#include <gsf/gsf-output-stdio.h>
#include <gsf/gsf-outfile.h>
class DocumentElement;


class TopLevelElementStyle
{
public:
	TopLevelElementStyle() : mpsMasterPageName(NULL) { }
	virtual ~TopLevelElementStyle() { if (mpsMasterPageName) delete mpsMasterPageName; }
	void setMasterPageName(UTF8String &sMasterPageName) { mpsMasterPageName = new UTF8String(sMasterPageName); }
	const UTF8String * getMasterPageName() const { return mpsMasterPageName; }

private:
	UTF8String *mpsMasterPageName;
};

class Style
{
 public:
	Style(const gchar *psName) : mpsName(g_string_new(psName)) {}
	virtual ~Style() { g_string_free(mpsName, TRUE); }

	virtual void write(GsfOutput *pOutput) const {};
	const GString * getName() const { return mpsName; }

 private:
	GString *mpsName;
};
#endif
