// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_3_0_autogen.cpp:
//   Defines the GL 3.0 entry points.

#include "libGL/entry_points_gl_3_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL3_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BeginConditionalRender(GLuint id, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BeginConditionalRender, "glBeginConditionalRender",
          "context = %d, id = %u, mode = %s", CID(context), id,
          GLenumToString(GLenumGroup::TypeEnum, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBeginConditionalRender(context, id, mode));
        if (isCallValid)
        {
            context->beginConditionalRender(id, mode);
        }
        ANGLE_CAPTURE(BeginConditionalRender, isCallValid, context, id, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BeginTransformFeedback(GLenum primitiveMode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BeginTransformFeedback, "glBeginTransformFeedback",
          "context = %d, primitiveMode = %s", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, primitiveMode));

    if (context)
    {
        PrimitiveMode primitiveModePacked = FromGL<PrimitiveMode>(primitiveMode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBeginTransformFeedback(context, primitiveModePacked));
        if (isCallValid)
        {
            context->beginTransformFeedback(primitiveModePacked);
        }
        ANGLE_CAPTURE(BeginTransformFeedback, isCallValid, context, primitiveModePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindBufferBase(GLenum target, GLuint index, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindBufferBase, "glBindBufferBase",
          "context = %d, target = %s, index = %u, buffer = %u", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target), index, buffer);

    if (context)
    {
        BufferBinding targetPacked                            = FromGL<BufferBinding>(target);
        BufferID bufferPacked                                 = FromGL<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindBufferBase(context, targetPacked, index, bufferPacked));
        if (isCallValid)
        {
            context->bindBufferBase(targetPacked, index, bufferPacked);
        }
        ANGLE_CAPTURE(BindBufferBase, isCallValid, context, targetPacked, index, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
BindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindBufferRange, "glBindBufferRange",
          "context = %d, target = %s, index = %u, buffer = %u, offset = %llu, size = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target), index, buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        BufferBinding targetPacked                            = FromGL<BufferBinding>(target);
        BufferID bufferPacked                                 = FromGL<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindBufferRange(context, targetPacked, index, bufferPacked, offset, size));
        if (isCallValid)
        {
            context->bindBufferRange(targetPacked, index, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(BindBufferRange, isCallValid, context, targetPacked, index, bufferPacked,
                      offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindFragDataLocation(GLuint program, GLuint color, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindFragDataLocation, "glBindFragDataLocation",
          "context = %d, program = %u, color = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          color, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindFragDataLocation(context, programPacked, color, name));
        if (isCallValid)
        {
            context->bindFragDataLocation(programPacked, color, name);
        }
        ANGLE_CAPTURE(BindFragDataLocation, isCallValid, context, programPacked, color, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindFramebuffer(GLenum target, GLuint framebuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindFramebuffer, "glBindFramebuffer",
          "context = %d, target = %s, framebuffer = %u", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target), framebuffer);

    if (context)
    {
        FramebufferID framebufferPacked                       = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindFramebuffer(context, target, framebufferPacked));
        if (isCallValid)
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE(BindFramebuffer, isCallValid, context, target, framebufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindRenderbuffer, "glBindRenderbuffer",
          "context = %d, target = %s, renderbuffer = %u", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target), renderbuffer);

    if (context)
    {
        RenderbufferID renderbufferPacked = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindRenderbuffer(context, target, renderbufferPacked));
        if (isCallValid)
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE(BindRenderbuffer, isCallValid, context, target, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindVertexArray(GLuint array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindVertexArray, "glBindVertexArray", "context = %d, array = %u",
          CID(context), array);

    if (context)
    {
        VertexArrayID arrayPacked                             = FromGL<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindVertexArray(context, arrayPacked));
        if (isCallValid)
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE(BindVertexArray, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BlitFramebuffer(GLint srcX0,
                                 GLint srcY0,
                                 GLint srcX1,
                                 GLint srcY1,
                                 GLint dstX0,
                                 GLint dstY0,
                                 GLint dstX1,
                                 GLint dstY1,
                                 GLbitfield mask,
                                 GLenum filter)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlitFramebuffer, "glBlitFramebuffer",
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlitFramebuffer(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                    dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE(BlitFramebuffer, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLenum GL_APIENTRY CheckFramebufferStatus(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::CheckFramebufferStatus, "glCheckFramebufferStatus",
          "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCheckFramebufferStatus(context, target));
        if (isCallValid)
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
        }
        ANGLE_CAPTURE(CheckFramebufferStatus, isCallValid, context, target, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY ClampColor(GLenum target, GLenum clamp)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClampColor, "glClampColor",
          "context = %d, target = %s, clamp = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, clamp));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClampColor(context, target, clamp));
        if (isCallValid)
        {
            context->clampColor(target, clamp);
        }
        ANGLE_CAPTURE(ClampColor, isCallValid, context, target, clamp);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClearBufferfi, "glClearBufferfi",
          "context = %d, buffer = %s, drawbuffer = %d, depth = %f, stencil = %d", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, depth, stencil);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferfi(context, buffer, drawbuffer, depth, stencil));
        if (isCallValid)
        {
            context->clearBufferfi(buffer, drawbuffer, depth, stencil);
        }
        ANGLE_CAPTURE(ClearBufferfi, isCallValid, context, buffer, drawbuffer, depth, stencil);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClearBufferfv, "glClearBufferfv",
          "context = %d, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferfv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferfv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferfv, isCallValid, context, buffer, drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClearBufferiv, "glClearBufferiv",
          "context = %d, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferiv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferiv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferiv, isCallValid, context, buffer, drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClearBufferuiv, "glClearBufferuiv",
          "context = %d, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferuiv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferuiv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferuiv, isCallValid, context, buffer, drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ColorMaski, "glColorMaski",
          "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s", CID(context), index,
          GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b), GLbooleanToString(a));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaski(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaski, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DeleteFramebuffers, "glDeleteFramebuffers",
          "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context)
    {
        const FramebufferID *framebuffersPacked = FromGL<const FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteFramebuffers(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(DeleteFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DeleteRenderbuffers, "glDeleteRenderbuffers",
          "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)renderbuffers);

    if (context)
    {
        const RenderbufferID *renderbuffersPacked = FromGL<const RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteRenderbuffers(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(DeleteRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DeleteVertexArrays(GLsizei n, const GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DeleteVertexArrays, "glDeleteVertexArrays",
          "context = %d, n = %d, arrays = 0x%016" PRIxPTR "", CID(context), n, (uintptr_t)arrays);

    if (context)
    {
        const VertexArrayID *arraysPacked = FromGL<const VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteVertexArrays(context, n, arraysPacked));
        if (isCallValid)
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(DeleteVertexArrays, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Disablei(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Disablei, "glDisablei", "context = %d, target = %s, index = %u",
          CID(context), GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDisablei(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(Disablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Enablei(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Enablei, "glEnablei", "context = %d, target = %s, index = %u",
          CID(context), GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEnablei(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(Enablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY EndConditionalRender()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::EndConditionalRender, "glEndConditionalRender", "context = %d",
          CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEndConditionalRender(context));
        if (isCallValid)
        {
            context->endConditionalRender();
        }
        ANGLE_CAPTURE(EndConditionalRender, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY EndTransformFeedback()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::EndTransformFeedback, "glEndTransformFeedback", "context = %d",
          CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEndTransformFeedback(context));
        if (isCallValid)
        {
            context->endTransformFeedback();
        }
        ANGLE_CAPTURE(EndTransformFeedback, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY FlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::FlushMappedBufferRange, "glFlushMappedBufferRange",
          "context = %d, target = %s, offset = %llu, length = %llu", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context)
    {
        BufferBinding targetPacked                            = FromGL<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFlushMappedBufferRange(context, targetPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedBufferRange, isCallValid, context, targetPacked, offset, length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY FramebufferRenderbuffer(GLenum target,
                                         GLenum attachment,
                                         GLenum renderbuffertarget,
                                         GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::FramebufferRenderbuffer, "glFramebufferRenderbuffer",
          "context = %d, target = %s, attachment = %s, renderbuffertarget = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context)
    {
        RenderbufferID renderbufferPacked = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferRenderbuffer(context, target, attachment, renderbuffertarget,
                                             renderbufferPacked));
        if (isCallValid)
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE(FramebufferRenderbuffer, isCallValid, context, target, attachment,
                      renderbuffertarget, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY FramebufferTexture1D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::FramebufferTexture1D, "glFramebufferTexture1D",
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context)
    {
        TextureTarget textargetPacked                         = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                               = FromGL<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferTexture1D(context, target, attachment,
                                                         textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture1D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture1D, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY FramebufferTexture2D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::FramebufferTexture2D, "glFramebufferTexture2D",
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context)
    {
        TextureTarget textargetPacked                         = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                               = FromGL<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferTexture2D(context, target, attachment,
                                                         textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture2D, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY FramebufferTexture3D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level,
                                      GLint zoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::FramebufferTexture3D, "glFramebufferTexture3D",
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "zoffset = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, zoffset);

    if (context)
    {
        TextureTarget textargetPacked                         = FromGL<TextureTarget>(textarget);
        TextureID texturePacked                               = FromGL<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture3D(context, target, attachment, textargetPacked,
                                          texturePacked, level, zoffset));
        if (isCallValid)
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texturePacked, level,
                                          zoffset);
        }
        ANGLE_CAPTURE(FramebufferTexture3D, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level, zoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
FramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::FramebufferTextureLayer, "glFramebufferTextureLayer",
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d, layer = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level, layer);

    if (context)
    {
        TextureID texturePacked                               = FromGL<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferTextureLayer(context, target, attachment,
                                                            texturePacked, level, layer));
        if (isCallValid)
        {
            context->framebufferTextureLayer(target, attachment, texturePacked, level, layer);
        }
        ANGLE_CAPTURE(FramebufferTextureLayer, isCallValid, context, target, attachment,
                      texturePacked, level, layer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GenFramebuffers, "glGenFramebuffers",
          "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context)
    {
        FramebufferID *framebuffersPacked = FromGL<FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenFramebuffers(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(GenFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GenRenderbuffers, "glGenRenderbuffers",
          "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)renderbuffers);

    if (context)
    {
        RenderbufferID *renderbuffersPacked = FromGL<RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenRenderbuffers(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(GenRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GenVertexArrays(GLsizei n, GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GenVertexArrays, "glGenVertexArrays",
          "context = %d, n = %d, arrays = 0x%016" PRIxPTR "", CID(context), n, (uintptr_t)arrays);

    if (context)
    {
        VertexArrayID *arraysPacked                           = FromGL<VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenVertexArrays(context, n, arraysPacked));
        if (isCallValid)
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(GenVertexArrays, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GenerateMipmap(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GenerateMipmap, "glGenerateMipmap", "context = %d, target = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target));

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateMipmap(context, targetPacked));
        if (isCallValid)
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE(GenerateMipmap, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetBooleani_v(GLenum target, GLuint index, GLboolean *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetBooleani_v, "glGetBooleani_v",
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target), index, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetBooleani_v(context, target, index, data));
        if (isCallValid)
        {
            context->getBooleani_v(target, index, data);
        }
        ANGLE_CAPTURE(GetBooleani_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLint GL_APIENTRY GetFragDataLocation(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetFragDataLocation, "glGetFragDataLocation",
          "context = %d, program = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFragDataLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataLocation, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetFramebufferAttachmentParameteriv(GLenum target,
                                                     GLenum attachment,
                                                     GLenum pname,
                                                     GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetFramebufferAttachmentParameteriv,
          "glGetFramebufferAttachmentParameteriv",
          "context = %d, target = %s, attachment = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferAttachmentParameteriv(
                                              context, target, attachment, pname, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameteriv, isCallValid, context, target, attachment,
                      pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetIntegeri_v(GLenum target, GLuint index, GLint *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetIntegeri_v, "glGetIntegeri_v",
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TypeEnum, target), index, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetIntegeri_v(context, target, index, data));
        if (isCallValid)
        {
            context->getIntegeri_v(target, index, data);
        }
        ANGLE_CAPTURE(GetIntegeri_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetRenderbufferParameteriv, "glGetRenderbufferParameteriv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::RenderbufferParameterName, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetRenderbufferParameteriv(context, target, pname, params));
        if (isCallValid)
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameteriv, isCallValid, context, target, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

const GLubyte *GL_APIENTRY GetStringi(GLenum name, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetStringi, "glGetStringi",
          "context = %d, name = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::StringName, name), index);

    const GLubyte *returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetStringi(context, name, index));
        if (isCallValid)
        {
            returnValue = context->getStringi(name, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetStringi, const GLubyte *>();
        }
        ANGLE_CAPTURE(GetStringi, isCallValid, context, name, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::GetStringi, const GLubyte *>();
    }
    return returnValue;
}

void GL_APIENTRY GetTexParameterIiv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexParameterIiv, "glGetTexParameterIiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexParameterIuiv, "glGetTexParameterIuiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTransformFeedbackVarying(GLuint program,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLsizei *size,
                                             GLenum *type,
                                             GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTransformFeedbackVarying, "glGetTransformFeedbackVarying",
          "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTransformFeedbackVarying(context, programPacked, index,
                                                                bufSize, length, size, type, name));
        if (isCallValid)
        {
            context->getTransformFeedbackVarying(programPacked, index, bufSize, length, size, type,
                                                 name);
        }
        ANGLE_CAPTURE(GetTransformFeedbackVarying, isCallValid, context, programPacked, index,
                      bufSize, length, size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetUniformuiv(GLuint program, GLint location, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetUniformuiv, "glGetUniformuiv",
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformuiv(context, programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformuiv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE(GetUniformuiv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetVertexAttribIiv(GLuint index, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetVertexAttribIiv, "glGetVertexAttribIiv",
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribEnum, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetVertexAttribIiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribIiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIiv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetVertexAttribIuiv, "glGetVertexAttribIuiv",
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribEnum, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetVertexAttribIuiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribIuiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIuiv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY IsEnabledi(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsEnabledi, "glIsEnabledi",
          "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnabledi(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsEnabledi, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnabledi, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsEnabledi, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsFramebuffer(GLuint framebuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsFramebuffer, "glIsFramebuffer",
          "context = %d, framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (context)
    {
        FramebufferID framebufferPacked                       = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsFramebuffer(context, framebufferPacked));
        if (isCallValid)
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsFramebuffer, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsRenderbuffer(GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsRenderbuffer, "glIsRenderbuffer",
          "context = %d, renderbuffer = %u", CID(context), renderbuffer);

    GLboolean returnValue;
    if (context)
    {
        RenderbufferID renderbufferPacked = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsRenderbuffer(context, renderbufferPacked));
        if (isCallValid)
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsRenderbuffer, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsVertexArray(GLuint array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsVertexArray, "glIsVertexArray", "context = %d, array = %u",
          CID(context), array);

    GLboolean returnValue;
    if (context)
    {
        VertexArrayID arrayPacked                             = FromGL<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsVertexArray(context, arrayPacked));
        if (isCallValid)
        {
            returnValue = context->isVertexArray(arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArray, GLboolean>();
        }
        ANGLE_CAPTURE(IsVertexArray, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsVertexArray, GLboolean>();
    }
    return returnValue;
}

void *GL_APIENTRY MapBufferRange(GLenum target,
                                 GLintptr offset,
                                 GLsizeiptr length,
                                 GLbitfield access)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MapBufferRange, "glMapBufferRange",
          "context = %d, target = %s, offset = %llu, length = %llu, access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context)
    {
        BufferBinding targetPacked                            = FromGL<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMapBufferRange(context, targetPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRange, void *>();
        }
        ANGLE_CAPTURE(MapBufferRange, isCallValid, context, targetPacked, offset, length, access,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::MapBufferRange, void *>();
    }
    return returnValue;
}

void GL_APIENTRY RenderbufferStorage(GLenum target,
                                     GLenum internalformat,
                                     GLsizei width,
                                     GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::RenderbufferStorage, "glRenderbufferStorage",
          "context = %d, target = %s, internalformat = %s, width = %d, height = %d", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRenderbufferStorage(context, target, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorage, isCallValid, context, target, internalformat, width,
                      height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY RenderbufferStorageMultisample(GLenum target,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::RenderbufferStorageMultisample,
          "glRenderbufferStorageMultisample",
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisample(context, target, samples,
                                                                   internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisample, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexParameterIiv(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexParameterIiv, "glTexParameterIiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexParameterIuiv(GLenum target, GLenum pname, const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexParameterIuiv, "glTexParameterIuiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIuiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TransformFeedbackVaryings(GLuint program,
                                           GLsizei count,
                                           const GLchar *const *varyings,
                                           GLenum bufferMode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TransformFeedbackVaryings, "glTransformFeedbackVaryings",
          "context = %d, program = %u, count = %d, varyings = 0x%016" PRIxPTR ", bufferMode = %s",
          CID(context), program, count, (uintptr_t)varyings,
          GLenumToString(GLenumGroup::DefaultGroup, bufferMode));

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTransformFeedbackVaryings(
                                              context, programPacked, count, varyings, bufferMode));
        if (isCallValid)
        {
            context->transformFeedbackVaryings(programPacked, count, varyings, bufferMode);
        }
        ANGLE_CAPTURE(TransformFeedbackVaryings, isCallValid, context, programPacked, count,
                      varyings, bufferMode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform1ui(GLint location, GLuint v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform1ui, "glUniform1ui",
          "context = %d, location = %d, v0 = %u", CID(context), location, v0);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1ui(context, locationPacked, v0));
        if (isCallValid)
        {
            context->uniform1ui(locationPacked, v0);
        }
        ANGLE_CAPTURE(Uniform1ui, isCallValid, context, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform1uiv(GLint location, GLsizei count, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform1uiv, "glUniform1uiv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform1uiv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform1uiv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform1uiv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform2ui(GLint location, GLuint v0, GLuint v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform2ui, "glUniform2ui",
          "context = %d, location = %d, v0 = %u, v1 = %u", CID(context), location, v0, v1);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2ui(context, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->uniform2ui(locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2ui, isCallValid, context, locationPacked, v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform2uiv(GLint location, GLsizei count, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform2uiv, "glUniform2uiv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform2uiv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform2uiv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform2uiv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform3ui, "glUniform3ui",
          "context = %d, location = %d, v0 = %u, v1 = %u, v2 = %u", CID(context), location, v0, v1,
          v2);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3ui(context, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3ui(locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3ui, isCallValid, context, locationPacked, v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform3uiv(GLint location, GLsizei count, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform3uiv, "glUniform3uiv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform3uiv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform3uiv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform3uiv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform4ui, "glUniform4ui",
          "context = %d, location = %d, v0 = %u, v1 = %u, v2 = %u, v3 = %u", CID(context), location,
          v0, v1, v2, v3);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform4ui(context, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4ui(locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4ui, isCallValid, context, locationPacked, v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform4uiv(GLint location, GLsizei count, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform4uiv, "glUniform4uiv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform4uiv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform4uiv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform4uiv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI1i(GLuint index, GLint x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI1i, "glVertexAttribI1i",
          "context = %d, index = %u, x = %d", CID(context), index, x);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI1i(context, index, x));
        if (isCallValid)
        {
            context->vertexAttribI1i(index, x);
        }
        ANGLE_CAPTURE(VertexAttribI1i, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI1iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI1iv, "glVertexAttribI1iv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI1iv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI1iv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI1iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI1ui(GLuint index, GLuint x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI1ui, "glVertexAttribI1ui",
          "context = %d, index = %u, x = %u", CID(context), index, x);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI1ui(context, index, x));
        if (isCallValid)
        {
            context->vertexAttribI1ui(index, x);
        }
        ANGLE_CAPTURE(VertexAttribI1ui, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI1uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI1uiv, "glVertexAttribI1uiv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI1uiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI1uiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI1uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI2i(GLuint index, GLint x, GLint y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI2i, "glVertexAttribI2i",
          "context = %d, index = %u, x = %d, y = %d", CID(context), index, x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI2i(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttribI2i(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttribI2i, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI2iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI2iv, "glVertexAttribI2iv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI2iv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI2iv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI2iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI2ui(GLuint index, GLuint x, GLuint y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI2ui, "glVertexAttribI2ui",
          "context = %d, index = %u, x = %u, y = %u", CID(context), index, x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI2ui(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttribI2ui(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttribI2ui, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI2uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI2uiv, "glVertexAttribI2uiv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI2uiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI2uiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI2uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI3i(GLuint index, GLint x, GLint y, GLint z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI3i, "glVertexAttribI3i",
          "context = %d, index = %u, x = %d, y = %d, z = %d", CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI3i(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttribI3i(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttribI3i, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI3iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI3iv, "glVertexAttribI3iv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI3iv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI3iv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI3iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI3ui, "glVertexAttribI3ui",
          "context = %d, index = %u, x = %u, y = %u, z = %u", CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI3ui(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttribI3ui(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttribI3ui, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI3uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI3uiv, "glVertexAttribI3uiv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI3uiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI3uiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI3uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4bv(GLuint index, const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4bv, "glVertexAttribI4bv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4bv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI4bv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI4bv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4i, "glVertexAttribI4i",
          "context = %d, index = %u, x = %d, y = %d, z = %d, w = %d", CID(context), index, x, y, z,
          w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4i(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttribI4i(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttribI4i, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4iv, "glVertexAttribI4iv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4iv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI4iv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI4iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4sv, "glVertexAttribI4sv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI4sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI4sv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4ubv(GLuint index, const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4ubv, "glVertexAttribI4ubv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4ubv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI4ubv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI4ubv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4ui, "glVertexAttribI4ui",
          "context = %d, index = %u, x = %u, y = %u, z = %u, w = %u", CID(context), index, x, y, z,
          w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4ui(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttribI4ui(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttribI4ui, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4uiv, "glVertexAttribI4uiv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4uiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI4uiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI4uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribI4usv(GLuint index, const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribI4usv, "glVertexAttribI4usv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribI4usv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribI4usv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribI4usv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
VertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribIPointer, "glVertexAttribIPointer",
          "context = %d, index = %u, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR
          "",
          CID(context), index, size, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = FromGL<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribIPointer(context, index, size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->vertexAttribIPointer(index, size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(VertexAttribIPointer, isCallValid, context, index, size, typePacked, stride,
                      pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}
}  // namespace gl
