/************************************************************************

WorldPrint aka wprint

This is the wprint program that allows Netscape users to print web
pages written in (at least) UNICODE, BIG5, SJIS and all ISO-8859-*
charsets provided a suitable TTF font.

Copyright (C) 2000  Eduardo Trapani (etrapani@unesco.org.uy)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#if !defined(_WPRINT_H)
#define	_WPRINT_H
#if	defined(TT_1)
#include <freetype/freetype.h>
#else
#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_TRUETYPE_TABLES_H
#include FT_BBOX_H
#include FT_GLYPH_H

#include FT_CONFIG_CONFIG_H
#include FT_CONFIG_OPTIONS_H
#include FT_ERRORS_H
#include FT_SYSTEM_H
#include FT_IMAGE_H
#include FT_TYPES_H
#include FT_OUTLINE_H
#include FT_MODULE_H
#include FT_RENDER_H
#include FT_TYPE1_TABLES_H
#include FT_TRUETYPE_IDS_H
#include FT_TRUETYPE_TAGS_H
#include FT_CACHE_H
#include FT_CACHE_IMAGE_H
#include FT_CACHE_SMALL_BITMAPS_H
#include FT_MULTIPLE_MASTERS_H
#include FT_SFNT_NAMES_H
#endif

#define	MAXENCODING	20
#define	MAXPSTEXT	500
#define	MAXWORD		500
#define	MAXFILENAME	180
#define	MAXLINE		400
#define	MAXNAME		80
#define	MAXNAMEFONT	80
#define	MAXFONTS	14

#define	AUTOMOZILLA	0x010
#define	MOZILLA		0x020
#define	NETSCAPE	0x030
#define	HTMLDOC		0x040
#define	HTMLDOC1_8	0x041
#define	UNKNOWN		0x200

#define	NEXTWORDPS		1
#define	NEXTWORDTEXT		2

#define	FONT		1
#define	COMMAND		2
#define	SHOW		3

#define ONOROFF 0x01

#define	composedFont(a,b)	((a << 8) + b)
#define maximize(x,xval) if((x)<(xval)) {x=(xval);}
#define minimize(x,xval) if((x)>(xval)) {x=(xval);}

#define	versionfromparts(x,y) ((x << 16) | (y << 8))

#define	TN_NOTICE	0
#define	TN_FAMILY	1
#define	TN_WEIGHT	2
#define	TN_X3		3
#define	TN_FULLNAME	4
#define	TN_VERSION	5
#define	TN_FONTNAME	6
#define	TN_X7		7
#define	TN_MAX		8

typedef struct creator
{
	int	id;
	int	major;
	int	minor;
	long	version;
	char	name[MAXNAME + 1];
	char	desc[MAXNAME + 1];
} Creator;

struct extraConv
{
	iconv_t	convorig;
	iconv_t	convascii;
	iconv_t	convlocal;
};

struct tt_info
{
#if	defined(TT_1)
	TT_Engine	ttengine;
#else
	FT_Library	ttengine;
#endif
	struct
	{
		double		charsize;
#if	defined(TT_1)
		TT_Face		ttface;
		TT_Instance	ttinstance;
#else
		FT_Face		ttface;
#endif
		int		xr;
		int		yr;
		char		names[10][MAXNAME + 1];
		TT_Postscript	*ttpostscript;
		TT_Header	*ttheader;
	} font;
};

typedef struct fonts
{
	unsigned short	id;
	unsigned short	eid;
	unsigned short	*map;
	int		nextchar;
	struct fonts	*next;
	struct fonts	*nexteid;
} Font;

struct fontInfo {
	char	original[MAXNAMEFONT];
	char	filename[MAXNAMEFONT];
	iconv_t	iconv;
	Font	*firstpage;
	int	xr;
	int	yr;
	double	pt;
};
typedef struct
{
	unsigned char	*rows[256];
} Map;

Font	*newFont(unsigned short fid,unsigned short feid);
Font	*addChar(unsigned short unicode,int fontid);
int	initTT(struct tt_info *ti);
int	setFont(struct tt_info *ti,char *);
int	unsetFont(struct tt_info *ti);
void	finalizeTT(struct tt_info *ti);
FILE	*processConfiguration(FILE *in,char *entry,char *encoding);
void	Error(char *string);
int	printTranslatedPs(FILE *tmp,FILE *out);
int	convertPsText(const char *encoding,FILE *in,FILE *tmp);
int	createGlyphs (FILE *out,struct tt_info *ti,unsigned short unicode, char *b64name);
int	generateFont(FILE *out,Font *aux,struct tt_info *ti);
int	processFontList(char *fontlist,const char *path);

char	*wordMemory(int id,char *word);
int	nextWord(FILE *in,char *buf,int maxlength,int *actuallength,char **orignumber);

typedef struct
{
	void	*extraData;
	Creator creator;
	int (*sourceInit)(); /*Source *s,char *encoding);*/
	iconv_t (*sourceConversion)(); /*Source *s,char *text);*/
	int (*sourceGetFonts)(); /*Source *s,char *word);*/
	int (*sourceFontId)(); /*Source *s,char *text)*/
	char *(*sourceCommand)(); /*Source *s,int type,int id)*/
	int (*sourceConvertibleTextContext)(); /*(wordMemory(0,NULL)) == 0)*/
	int (*sourceFinalize)(); /*Source *s);*/
} Source;

#if	defined(TT_1)
short PS_CharString(FILE *out, unsigned short char_Code,TT_CharMap cmap,TT_Glyph_Metrics metrics, TT_Glyph glyph,TT_Instance instance,TT_Face face);
int drawGlyph(FILE *out,TT_Glyph glyphno, TT_Glyph parent,TT_Outline outline);
int	glyphToPs(FILE *out, unsigned short char_Code,TT_CharMap cmap,TT_Glyph_Metrics metrics, TT_Glyph glyph,struct tt_info *ti,char *b64name);
#else
int glyphToPs(FILE *out,unsigned short unicode,struct tt_info *ti,char *b64name);
#endif

#endif
