/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.StyleConverter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.StyleMap;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class ParConverter
extends StyleConverter {
    private boolean bNeedArrayBslash = false;

    public ParConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedArrayBslash) {
            decl.append("\\makeatletter").nl().append("\\newcommand\\arraybslash{\\let\\\\\\@arraycr}").nl().append("\\makeatother").nl();
        }
        if (this.config.formatting() >= 3) {
            decl.append("\\raggedbottom").nl();
        }
        if (this.config.formatting() >= 3) {
            decl.append("% Paragraph styles").nl();
            this.palette.getCharSc().applyDefaultFont(this.ofr.getDefaultParStyle(), decl);
            super.appendDeclarations(pack, decl);
        }
    }

    public void handleParagraph(Element node, LaTeXDocumentPortion ldp, Context oc, boolean bLastInBlock) {
        if (this.palette.getMathmlCv().handleDisplayEquation(node, ldp)) {
            return;
        }
        String sStyleName = node.getAttribute("text:style-name");
        String sDisplayName = this.ofr.getParStyles().getDisplayName(sStyleName);
        if (this.config.otherStyles() != 1 && !this.config.getParStyleMap().contains(sDisplayName)) {
            if (this.config.otherStyles() == 2) {
                System.err.println("Warning: A paragraph with style " + sDisplayName + " was ignored");
            } else if (this.config.otherStyles() == 3) {
                ldp.append("% Error in source document: A paragraph with style ").append(this.palette.getI18n().convert(sDisplayName, false, oc.getLang())).append(" was ignored").nl();
            }
            return;
        }
        if (OfficeReader.isWhitespaceContent(node)) {
            BeforeAfter baPage = new BeforeAfter();
            StyleWithProperties style = this.ofr.getParStyle(sStyleName);
            this.palette.getPageSc().applyPageBreak(style, true, baPage);
            if (!oc.isInTable()) {
                ldp.append(baPage.getBefore());
            }
            if (!this.config.ignoreEmptyParagraphs()) {
                if (!oc.isInTable()) {
                    ldp.nl().append("\\bigskip").nl();
                } else {
                    ldp.append("~").nl();
                }
                if (!bLastInBlock) {
                    ldp.nl();
                }
            }
            if (!oc.isInTable()) {
                ldp.append(baPage.getAfter());
            }
            return;
        }
        Context ic = (Context)oc.clone();
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getParStyle(sStyleName)));
        BeforeAfter ba = new BeforeAfter();
        if (oc.isInTable()) {
            this.applyCellParStyle(sStyleName, ba, ic, OfficeReader.getCharacterCount(node) == 0, bLastInBlock);
        } else {
            this.applyParStyle(sStyleName, ba, ic, OfficeReader.getCharacterCount(node) == 0);
        }
        ldp.append(ba.getBefore());
        this.palette.getInlineCv().traverseInlineText(node, ldp, ic, false);
        ldp.append(ba.getAfter());
        if (!(bLastInBlock || ic.isVerbatim() || ic.isInSimpleTable())) {
            ldp.nl();
        }
        this.palette.getFieldCv().flushReferenceMarks(ldp, oc);
        this.palette.getIndexCv().flushIndexMarks(ldp, oc);
        this.palette.getDrawCv().flushFloatingFrames(ldp, oc);
        this.palette.getI18n().popSpecialTable();
    }

    private void applyCellParStyle(String sName, BeforeAfter ba, Context context, boolean bNoTextPar, boolean bLastInBlock) {
        StyleWithProperties style;
        if (!bLastInBlock) {
            ba.add("", "\n");
        }
        if (context.isInSimpleTable()) {
            if (this.config.formatting() != 0 && (style = this.ofr.getParStyle(sName)) != null) {
                this.palette.getI18n().applyLanguage(style, true, true, ba);
                this.palette.getCharSc().applyFont(style, true, true, ba, context);
                if (ba.getBefore().length() > 0) {
                    ba.add(" ", "");
                }
            }
        } else if (bNoTextPar && (this.config.formatting() == 2 || this.config.formatting() == 1)) {
            style = this.ofr.getParStyle(sName);
            if (style != null) {
                this.palette.getPageSc().applyPageBreak(style, false, ba);
                String sTextAlign = style.getProperty("fo:text-align", true);
                if (bLastInBlock && context.isInLastTableColumn()) {
                    if ("center".equals(sTextAlign)) {
                        ba.add("\\centering\\arraybslash ", "");
                    } else if ("end".equals(sTextAlign)) {
                        ba.add("\\raggedleft\\arraybslash ", "");
                    }
                    this.bNeedArrayBslash = true;
                } else if (bLastInBlock) {
                    if ("center".equals(sTextAlign)) {
                        ba.add("\\centering ", "");
                    } else if ("end".equals(sTextAlign)) {
                        ba.add("\\raggedleft ", "");
                    }
                } else if ("center".equals(sTextAlign)) {
                    ba.add("{\\centering ", "\\par}");
                } else if ("end".equals(sTextAlign)) {
                    ba.add("{\\raggedleft ", "\\par}");
                }
            }
        } else {
            BeforeAfter baText = new BeforeAfter();
            StyleWithProperties style2 = this.ofr.getParStyle(sName);
            if (style2 != null) {
                String sTextAlign = style2.getProperty("fo:text-align", true);
                if (bLastInBlock && context.isInLastTableColumn()) {
                    if ("center".equals(sTextAlign)) {
                        ba.add("\\centering\\arraybslash ", "");
                    } else if ("end".equals(sTextAlign)) {
                        ba.add("\\raggedleft\\arraybslash ", "");
                    }
                    this.bNeedArrayBslash = true;
                } else if (bLastInBlock) {
                    if ("center".equals(sTextAlign)) {
                        ba.add("\\centering ", "");
                    } else if ("end".equals(sTextAlign)) {
                        ba.add("\\raggedleft ", "");
                    }
                } else if ("center".equals(sTextAlign)) {
                    ba.add("\\centering ", "\\par");
                } else if ("end".equals(sTextAlign)) {
                    ba.add("\\raggedleft ", "\\par");
                }
                this.palette.getI18n().applyLanguage(style2, true, true, baText);
                this.palette.getCharSc().applyFont(style2, true, true, baText, context);
            }
            if (!baText.isEmpty() && !bLastInBlock) {
                ba.add("{", "}");
            }
            ba.add(baText.getBefore(), baText.getAfter());
            if (baText.getBefore().length() > 0) {
                ba.add(" ", "");
            }
        }
        if ((style = this.ofr.getParStyle(sName)) == null) {
            return;
        }
        context.updateFormattingFromStyle(style);
        context.setVerbatim(this.styleMap.getVerbatim(sName));
    }

    private void applyParStyle(String sName, BeforeAfter ba, Context context, boolean bNoTextPar) {
        this.applyParStyle(sName, ba, context, bNoTextPar, true);
    }

    private void applyParStyle(String sName, BeforeAfter ba, Context context, boolean bNoTextPar, boolean bBreakInside) {
        StyleWithProperties style;
        if (sName == null) {
            return;
        }
        if (context.isInSimpleTable()) {
            if (this.config.formatting() != 0 && (style = this.ofr.getParStyle(sName)) != null) {
                this.palette.getI18n().applyLanguage(style, true, true, ba);
                this.palette.getCharSc().applyFont(style, true, true, ba, context);
                if (ba.getBefore().length() > 0) {
                    ba.add(" ", "");
                }
            }
        } else if (bNoTextPar && (this.config.formatting() == 2 || this.config.formatting() == 1)) {
            ba.add("", "\n");
            style = this.ofr.getParStyle(sName);
            if (style != null) {
                this.palette.getPageSc().applyPageBreak(style, false, ba);
                String sTextAlign = style.getProperty("fo:text-align", true);
                if ("center".equals(sTextAlign)) {
                    ba.add("{\\centering ", "\\par}");
                } else if ("end".equals(sTextAlign)) {
                    ba.add("{\\raggedleft ", "\\par}");
                }
            }
        } else {
            ba.add("", "\n");
            if (!this.styleMap.contains(sName)) {
                this.createParStyle(sName);
            }
            String sBefore = this.styleMap.getBefore(sName);
            String sAfter = this.styleMap.getAfter(sName);
            ba.add(sBefore, sAfter);
            if (bBreakInside && this.styleMap.getLineBreak(sName)) {
                if (sBefore.length() > 0) {
                    ba.add("\n", "");
                }
                if (sAfter.length() > 0 && !"}".equals(sAfter)) {
                    ba.add("", "\n");
                }
            }
        }
        if ((style = this.ofr.getParStyle(sName)) == null) {
            return;
        }
        context.updateFormattingFromStyle(style);
        context.setVerbatim(this.styleMap.getVerbatim(sName));
    }

    private void createParStyle(String sName) {
        Context context = (Context)this.palette.getMainContext().clone();
        String sDisplayName = this.ofr.getParStyles().getDisplayName(sName);
        StyleMap sm = this.config.getParStyleMap();
        if (sm.contains(sDisplayName)) {
            this.styleMap.put(sName, sm.getBefore(sDisplayName), sm.getAfter(sDisplayName), sm.getLineBreak(sDisplayName), sm.getVerbatim(sDisplayName));
            return;
        }
        StyleWithProperties style = this.ofr.getParStyle(sName);
        if (style == null) {
            this.styleMap.put(sName, "", "");
            return;
        }
        switch (this.config.formatting()) {
            case 3: {
                if (style.isAutomatic()) {
                    this.createAutomaticParStyle(style, context);
                    return;
                }
            }
            case 4: {
                this.createSoftParStyle(style, context);
                return;
            }
            case 1: 
            case 2: {
                this.createSimpleParStyle(style, context);
                return;
            }
        }
        this.styleMap.put(sName, "", "");
    }

    private void createAutomaticParStyle(StyleWithProperties style, Context context) {
        BeforeAfter ba = new BeforeAfter();
        BeforeAfter baPar = new BeforeAfter();
        BeforeAfter baText = new BeforeAfter();
        String sParentName = style.getParentName();
        if (this.styleMap.getVerbatim(sParentName)) {
            this.styleMap.put(style.getName(), this.styleMap.getBefore(sParentName), this.styleMap.getAfter(sParentName), this.styleMap.getLineBreak(sParentName), this.styleMap.getVerbatim(sParentName));
            return;
        }
        this.applyParStyle(sParentName, baPar, context, false, false);
        this.palette.getPageSc().applyPageBreak(style, false, ba);
        this.palette.getI18n().applyLanguage(style, true, false, baText);
        this.palette.getCharSc().applyFont(style, true, false, baText, context);
        if (baPar.isEmpty() && !baText.isEmpty()) {
            ba.add("{", "}");
        } else {
            ba.add(baPar.getBefore(), baPar.getAfter());
        }
        ba.add(baText.getBefore(), baText.getAfter());
        boolean bLineBreak = this.styleMap.getLineBreak(sParentName);
        if (!bLineBreak && !baText.isEmpty()) {
            ba.add(" ", "");
        }
        this.styleMap.put(style.getName(), ba.getBefore(), ba.getAfter(), bLineBreak, false);
    }

    private void createSimpleParStyle(StyleWithProperties style, Context context) {
        if (style.isAutomatic() && this.config.getParStyleMap().contains(this.ofr.getParStyles().getDisplayName(style.getParentName()))) {
            this.createAutomaticParStyle(style, context);
            return;
        }
        BeforeAfter ba = new BeforeAfter();
        BeforeAfter baText = new BeforeAfter();
        this.palette.getPageSc().applyPageBreak(style, false, ba);
        String sTextAlign = style.getProperty("fo:text-align", true);
        if ("center".equals(sTextAlign)) {
            baText.add("\\centering", "\\par");
        } else if ("end".equals(sTextAlign)) {
            baText.add("\\raggedleft", "\\par");
        }
        this.palette.getI18n().applyLanguage(style, true, true, baText);
        this.palette.getCharSc().applyFont(style, true, true, baText, context);
        if (!baText.isEmpty()) {
            ba.add("{", "}");
        }
        ba.add(baText.getBefore(), baText.getAfter());
        this.styleMap.put(style.getName(), ba.getBefore(), ba.getAfter());
    }

    private void createSoftParStyle(StyleWithProperties style, Context context) {
        if (style.isAutomatic() && this.config.getParStyleMap().contains(this.ofr.getParStyles().getDisplayName(style.getParentName()))) {
            this.createAutomaticParStyle(style, context);
        }
        BeforeAfter ba = new BeforeAfter();
        this.applyParProperties(style, ba);
        ba.add("\\writerlistparindent\\writerlistleftskip", "");
        this.palette.getI18n().applyLanguage(style, true, true, ba);
        ba.add("\\leavevmode", "");
        this.palette.getCharSc().applyNormalFont(ba);
        this.palette.getCharSc().applyFont(style, true, true, ba, context);
        ba.add("\\writerlistlabel", "");
        ba.add("\\ignorespaces", "");
        String sTeXName = "style" + this.styleNames.getExportName(style.getDisplayName());
        this.styleMap.put(style.getName(), "\\begin{" + sTeXName + "}", "\\end{" + sTeXName + "}");
        this.declarations.append("\\newenvironment{").append(sTeXName).append("}{").append(ba.getBefore()).append("}{").append(ba.getAfter()).append("}").nl();
    }

    private void applyLineSpacing(StyleWithProperties style, BeforeAfter ba) {
        if (style == null) {
            return;
        }
        String sLineHeight = style.getProperty("fo:line-height");
        if (sLineHeight == null || !sLineHeight.endsWith("%")) {
            return;
        }
        float fPercent = Misc.getFloat(sLineHeight.substring(0, sLineHeight.length() - 1), 100.0f);
        if (fPercent < 120.0f) {
            fPercent = 120.0f;
        }
        ba.add("\\renewcommand\\baselinestretch{" + fPercent / 120.0f + "}", "");
    }

    private String createBorder(String sLeft, String sRight, String sTop, String sHeight, String sColor) {
        BeforeAfter baColor = new BeforeAfter();
        this.palette.getColorCv().applyColor(sColor, false, baColor, new Context());
        return "{\\setlength\\parindent{0pt}\\setlength\\leftskip{" + sLeft + "}" + "\\setlength\\baselineskip{0pt}\\setlength\\parskip{" + sHeight + "}" + baColor.getBefore() + "\\rule{\\textwidth-" + sLeft + "-" + sRight + "}{" + sHeight + "}" + baColor.getAfter() + "\\par}";
    }

    private void applyMargins(StyleWithProperties style, BeforeAfter ba) {
        String sRubberMarginBottom;
        String sPaddingTop = style.getAbsoluteLength("fo:padding-top");
        String sPaddingBottom = style.getAbsoluteLength("fo:padding-bottom");
        String sPaddingLeft = style.getAbsoluteLength("fo:padding-left");
        String sPaddingRight = style.getAbsoluteLength("fo:padding-right");
        String sMarginTop = style.getAbsoluteLength("fo:margin-top");
        String sMarginBottom = style.getAbsoluteLength("fo:margin-bottom");
        String sMarginLeft = style.getAbsoluteLength("fo:margin-left");
        String sMarginRight = style.getAbsoluteLength("fo:margin-right");
        String sTextIndent = "true".equals(style.getProperty("style:auto-text-indent")) ? "2em" : style.getAbsoluteLength("fo:text-indent");
        boolean bRaggedLeft = false;
        boolean bRaggedRight = false;
        boolean bParFill = false;
        String sTextAlign = style.getProperty("fo:text-align");
        if ("center".equals(sTextAlign)) {
            bRaggedLeft = true;
            bRaggedRight = true;
        } else if ("start".equals(sTextAlign)) {
            bRaggedRight = true;
            bParFill = true;
        } else if ("end".equals(sTextAlign)) {
            bRaggedLeft = true;
        } else if (!"justify".equals(style.getProperty("fo:text-align-last"))) {
            bParFill = true;
        }
        String sRubberMarginTop = Misc.multiply("10%", sMarginTop);
        if (Misc.length2px(sRubberMarginTop).equals("0")) {
            sRubberMarginTop = "1pt";
        }
        if (Misc.length2px(sRubberMarginBottom = Misc.multiply("10%", sMarginBottom)).equals("0")) {
            sRubberMarginBottom = "1pt";
        }
        ba.add("\\setlength\\leftskip{" + sMarginLeft + (bRaggedLeft ? " plus 1fil" : "") + "}", "");
        ba.add("\\setlength\\rightskip{" + sMarginRight + (bRaggedRight ? " plus 1fil" : "") + "}", "");
        ba.add("\\setlength\\parindent{" + sTextIndent + "}", "");
        ba.add("\\setlength\\parfillskip{" + (bParFill ? "0pt plus 1fil" : "0pt") + "}", "");
        ba.add("\\setlength\\parskip{" + sMarginTop + " plus " + sRubberMarginTop + "}", "\\unskip\\vspace{" + sMarginBottom + " plus " + sRubberMarginBottom + "}");
    }

    public void applyAlignment(StyleWithProperties style, boolean bIsSimple, boolean bInherit, BeforeAfter ba) {
        if (bIsSimple || style == null) {
            return;
        }
        String sTextAlign = style.getProperty("fo:text-align", bInherit);
        if ("center".equals(sTextAlign)) {
            ba.add("\\centering", "");
        } else if ("start".equals(sTextAlign)) {
            ba.add("\\raggedright", "");
        } else if ("end".equals(sTextAlign)) {
            ba.add("\\raggedleft", "");
        }
    }

    private void applyParProperties(StyleWithProperties style, BeforeAfter ba) {
        this.palette.getPageSc().applyPageBreak(style, true, ba);
        ba.add("", "\\par");
        this.applyLineSpacing(style, ba);
        this.applyMargins(style, ba);
    }
}

